/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.base.thread;

import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.LegoBaseConfig;
import com.huawei.lego.core.sdk.util.NumberUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.tomcat.util.threads.TaskQueue;
import org.apache.tomcat.util.threads.ThreadPoolExecutor;

public class ThreadPoolConfig {
    public static final int DEFAULT_CORE_POOL_SIZE = 30;
    public static final int DEFAULT_MAX_POOL_SIZE = 500;
    public static final int DEFAULT_WORK_QUEUE_SIZE = 200;
    public static final int HCS_DEFAULT_WORK_QUEUE_SIZE = 1;
    public static final int RUNTIME_ENVIROMENT_CPU_PROCESSOR = 8;
    public static final String FUSION_CLOUD_VERSION = "fusioncloud.version";
    private static final String FC_VERSION = "6.3";
    private static final Log LOGGER = LogFactory.getInstance(ThreadPoolConfig.class);
    private static final Map<String, ThreadPoolConfig> CONFIGS = new HashMap<String, ThreadPoolConfig>();
    private static final long DEFAULT_KEEP_ALIVE_TIME = 120L;
    private final String name;
    private int corePoolSize = 30;
    private int maximumPoolSize = 500;
    private int workQueueSize = 200;
    private long keepAliveTime = 120L;
    private final AtomicReference<ThreadPoolExecutor> reference = new AtomicReference();

    private ThreadPoolConfig(String name) {
        this.name = Objects.requireNonNull(name);
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ThreadPoolConfig initialize() {
        InputStream inputStream;
        Properties props;
        block6: {
            props = new Properties();
            inputStream = null;
            try {
                ClassLoader classLoader = ThreadPoolConfig.class.getClassLoader();
                if (classLoader != null) {
                    inputStream = classLoader.getResourceAsStream("common_threadpool.properties");
                }
                if (inputStream == null) break block6;
                props.load(inputStream);
            }
            catch (IOException e) {
                try {
                    LOGGER.warn((Object)"Loading configuration failed, exception: %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
                }
                catch (Throwable throwable) {
                    CommonUtil.close(inputStream);
                    throw throwable;
                }
                CommonUtil.close((Closeable)inputStream);
            }
        }
        CommonUtil.close((Closeable)inputStream);
        this.corePoolSize = NumberUtil.convertToInteger((Object)this.load(props, this.name, "core_pool_size", String.valueOf(this.corePoolSize)));
        this.maximumPoolSize = NumberUtil.convertToInteger((Object)this.load(props, this.name, "max_pool_size", String.valueOf(this.maximumPoolSize)));
        this.workQueueSize = NumberUtil.convertToInteger((Object)this.load(props, this.name, "work_queue_size", String.valueOf(this.workQueueSize)));
        this.keepAliveTime = NumberUtil.convertToLong((Object)this.load(props, this.name, "keep_alive_time", String.valueOf(this.keepAliveTime)));
        Runtime runtime = Runtime.getRuntime();
        String fcVersion = LegoBaseConfig.getInstance().getKeyValue(FUSION_CLOUD_VERSION);
        if (runtime.availableProcessors() >= 8 && !VerifyUtil.isEmpty((String)fcVersion) && fcVersion.compareToIgnoreCase(FC_VERSION) >= 0) {
            this.workQueueSize = NumberUtil.convertToInteger((Object)props.getProperty("hcs.pool." + this.name + ".work_queue_size"), (int)1);
            LOGGER.info((Object)"CpuProcessor more than eight and ThreadPoolConfig set  workQueueSize of threadPool to %s", (long)this.workQueueSize);
        }
        return this;
    }

    private String load(Properties props, String poolName, String config, String defaultValue) {
        String key = String.join((CharSequence)".", "pool", poolName, config);
        String value = props.getProperty(key);
        if (VerifyUtil.isEmpty((String)value)) {
            return defaultValue;
        }
        return value;
    }

    public ThreadPoolExecutor getThreadPoolExecutor() {
        return this.reference.updateAndGet(pool -> Optional.ofNullable(pool).orElseGet(this::createThreadPoolExecutor));
    }

    private ThreadPoolExecutor createThreadPoolExecutor() {
        return new ThreadPoolExecutor(this.corePoolSize, this.maximumPoolSize, this.keepAliveTime, TimeUnit.SECONDS, (BlockingQueue)new TaskQueue(this.workQueueSize));
    }

    public ThreadPoolConfig corePoolSize(int size) {
        this.corePoolSize = size;
        return this;
    }

    public ThreadPoolConfig maximumPoolSize(int size) {
        this.maximumPoolSize = size;
        return this;
    }

    public ThreadPoolConfig workQueueSize(int size) {
        this.workQueueSize = size;
        return this;
    }

    public static ThreadPoolConfig getThreadPoolConfig() {
        return ThreadPoolConfig.getThreadPoolConfig("default");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ThreadPoolConfig getThreadPoolConfig(String poolName) {
        Map<String, ThreadPoolConfig> map = CONFIGS;
        synchronized (map) {
            if (CONFIGS.containsKey(poolName)) {
                return CONFIGS.get(poolName);
            }
            ThreadPoolConfig config = new ThreadPoolConfig(poolName);
            CONFIGS.put(poolName, config);
            return config;
        }
    }

    public int getCorePoolSize() {
        return this.corePoolSize;
    }

    public int getMaximumPoolSize() {
        return this.maximumPoolSize;
    }

    public int getWorkQueueSize() {
        return this.workQueueSize;
    }

    public long getKeepAliveTime() {
        return this.keepAliveTime;
    }
}

