/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.base.util;

import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.LegoBaseConfig;
import com.huawei.lego.core.sdk.util.VerifyUtil;

public class SysScenarioServiceConfig {
    private static final Log logger = LogFactory.getInstance(SysScenarioServiceConfig.class);

    private SysScenarioServiceConfig() {
    }

    public static boolean isSupportService(String serviceConfig) {
        String fcVersion = LegoBaseConfig.getInstance().getKeyValue("fusioncloud.version");
        if (!VerifyUtil.isEmpty((String)fcVersion) && !LegoBaseConfig.getInstance().getBoolean(serviceConfig, Boolean.valueOf(false)).booleanValue()) {
            logger.info((Object)"%s, openstack is not supported.", new Object[]{serviceConfig});
            return false;
        }
        return true;
    }

    public static enum ServiceConfigEnum {
        MAIL_SEND_SEVICE("mail.send.thread.support"),
        SMS_SEND_SERVICE("sms.send.thread.support"),
        NOTIFY_SEND_RECEIVER_SERVICE("notity.trap.thread.support");

        String value;

        private ServiceConfigEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

