/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.mediation;

import com.huawei.lego.core.base.thread.ExecutionService;
import com.huawei.lego.core.base.thread.ThreadPoolManager;
import com.huawei.lego.core.mediation.IFilter;
import com.huawei.lego.core.mediation.IPlugin;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class Controler
implements InitializingBean,
DisposableBean {
    private static final Log LOGGER = LogFactory.getInstance(Controler.class);
    private List<IPlugin> plugins;

    public void afterPropertiesSet() {
        ThreadPoolManager threadPoolMgr = new ThreadPoolManager();
        threadPoolMgr.setThreadName("Mediation ThreadPool MgrThread");
        ExecutionService.submitTask(threadPoolMgr);
        this.plugins = new ArrayList<IPlugin>();
        LOGGER.debug((Object)"Controler init ok.", 1L);
    }

    public void destroy() {
        for (IPlugin plugin : this.plugins) {
            plugin.destroy();
        }
        LOGGER.debug((Object)"Controler destroy ok.", 1L);
    }

    public void onBindPlugin(IPlugin plugin, Map<String, String> properties) {
        plugin.init();
        this.plugins.add(plugin);
    }

    public void onUnbindPlugin(IPlugin plugin, Map<String, String> properties) {
        plugin.destroy();
        this.plugins.remove(plugin);
    }

    public void onBindFilter(IFilter filter, Map<String, String> properties) {
    }

    public void onUnbindFilter(IFilter filter, Map<String, String> properties) {
    }
}

