/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.mediation.nepoll;

import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.cbb.resource.sdk.model.TopoObject;
import com.huawei.lego.core.mediation.nepoll.PingPoll;
import com.huawei.lego.core.mediation.nepoll.PollPlugin;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.Collection;
import java.util.Map;

public class NeAddSubscriber {
    private static final Log LOGGER = LogFactory.getInstance(NeAddSubscriber.class);

    public void onMessage(Map<Long, ManagedObject> msgObj) {
        if (msgObj == null) {
            LOGGER.error((Object)"Recv a null message object, message type: COMMAND_RES_ADD.");
            return;
        }
        try {
            LOGGER.info((Object)"Recv a COMMAND_RES_ADD message, moIds: %s.", new Object[]{msgObj.keySet()});
            Collection<ManagedObject> moList = msgObj.values();
            this.constructMessage(moList);
        }
        catch (Exception e) {
            LOGGER.error((Object)ExceptionUtil.getErrorMessage((Throwable)e), 1L);
        }
    }

    private void constructMessage(Collection<ManagedObject> moList) {
        for (ManagedObject mo : moList) {
            if (!(mo instanceof TopoObject)) continue;
            TopoObject topoMo = (TopoObject)mo;
            String moIP = topoMo.getIpAddress();
            if (moIP == null) {
                LOGGER.error((Object)"MoIP is null, can not add a poll task.");
                continue;
            }
            LOGGER.info((Object)"TopoObject contained in COMMAND_RES_ADD message which moId: %s, moIP: %s.", new Object[]{topoMo.getMoId(), moIP});
            String descr = topoMo.getDescription();
            if (descr != null && "manual".equals(descr)) {
                LOGGER.info((Object)"Recv a manual add device in NeAddSubscriber, no need to add a poll task, ip: %s", new Object[]{moIP});
                continue;
            }
            this.constructPollTask(moIP, topoMo);
        }
    }

    private void constructPollTask(String moIp, TopoObject topoMo) {
        long moId = topoMo.getMoId();
        String moName = topoMo.getName();
        if (!topoMo.getSupportPing().booleanValue()) {
            LOGGER.error((Object)"NNo support ping,ip:%s,moId:%s,moName:%s", new Object[]{moIp, moId, moName});
            return;
        }
        PollPlugin.getInstance().addPingPoll(new PingPoll(moId, moIp, moName));
    }
}

