/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.mediation.synchronize;

import com.huawei.lego.cbb.backtask.sdk.model.BackTask;
import com.huawei.lego.cbb.backtask.sdk.service.IBackTaskService;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.cbb.resource.sdk.model.Node;
import com.huawei.lego.cbb.resource.sdk.service.ICommonService;
import com.huawei.lego.cbb.resource.sdk.service.IDeviceTypeMgr;
import com.huawei.lego.cbb.resource.sdk.service.IResourceService;
import com.huawei.lego.com.south.sdk.model.Protocol;
import com.huawei.lego.com.south.sdk.model.TelnetPara;
import com.huawei.lego.core.domain.impl.CacheServiceProvider;
import com.huawei.lego.core.mediation.IPlugin;
import com.huawei.lego.core.mediation.model.SynchronizeMOResult;
import com.huawei.lego.core.mediation.synchronize.SynchronizeManager;
import com.huawei.lego.core.mediation.synchronize.SynchronizeWorker;
import com.huawei.lego.core.sdk.base.ICacheService;
import com.huawei.lego.core.sdk.base.ServiceContext;
import com.huawei.lego.core.sdk.base.event.ServiceStatusChangedListener;
import com.huawei.lego.core.sdk.base.event.StatusChangedEvent;
import com.huawei.lego.core.sdk.base.model.Status;
import com.huawei.lego.core.sdk.common.ServiceProvider;
import com.huawei.lego.core.sdk.domain.IDomainContainer;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.exception.LegoUncheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.mediation.synchronize.model.XmlSynchronizeContext;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.nem.discover.sdk.model.DiscoveryPolicy;
import com.huawei.lego.nem.discover.sdk.model.DiscoveryResult;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class SynchronizePlugin
implements IPlugin,
ServiceStatusChangedListener {
    private static final int MAX_RETRY = 50;
    private static final int SLEEP_TIME = 500;
    private static final int VALUE_3000 = 3000;
    private static final String DOMAIN_NAME = "DomainApplicaton/DomainContainer";
    private static final Log LOGGER = LogFactory.getInstance(SynchronizePlugin.class);
    private static IResourceService sResourceService = null;
    private IDomainContainer domainContainer;
    private SynchronizeManager manager;
    private IDeviceTypeMgr deviceTypeManager;

    private static synchronized void increaseDiscoveryCount(DiscoveryPolicy policy) {
        if (sResourceService == null) {
            sResourceService = (IResourceService)ServiceContext.getInstance().lookup("ResourceApplication/ResourceServiceImpl");
        }
        if (sResourceService == null) {
            LOGGER.error((Object)"Can not get resource service, service name is : ResourceApplication/ResourceServiceImpl", 1L);
        } else {
            Object[] param = new Object[]{policy.getUuidForPerDiscovery()};
            String sql = "update T_discoverypolicy set discovered_device_count = discovered_device_count + 1  where uuid_for_per_discovery = ?";
            sResourceService.updateBySql(sql, param);
        }
    }

    private static synchronized void increaseDiscoveryCount(DiscoveryPolicy policy, int increment) {
        if (sResourceService == null) {
            sResourceService = (IResourceService)ServiceContext.getInstance().lookup("ResourceApplication/ResourceServiceImpl");
        }
        if (sResourceService == null) {
            LOGGER.error((Object)"Can not get resource service, service name is : ResourceApplication/ResourceServiceImpl");
        } else {
            Object[] param = new Object[]{policy.getUuidForPerDiscovery()};
            String sql = "update T_discoverypolicy set discovered_device_count = discovered_device_count + " + increment + " where uuid_for_per_discovery = ?";
            sResourceService.updateBySql(sql, param);
        }
    }

    public IDeviceTypeMgr getDeviceTypeManager() {
        return this.deviceTypeManager;
    }

    public void setDeviceTypeManager(IDeviceTypeMgr deviceTypeManager) {
        this.deviceTypeManager = deviceTypeManager;
    }

    public void setManager(SynchronizeManager manager) {
        this.manager = manager;
    }

    public void onStatusChangedEvent(StatusChangedEvent event) {
        if (event.getStatus() != Status.STATUS_STARTED) {
            return;
        }
        if (event.getEventTarget() instanceof IDomainContainer) {
            this.initDomainModel();
        }
        if (event.getEventTarget() instanceof ICommonService) {
            LOGGER.info((Object)"Will setStatusOfExceptionTerminatedDiscoveryPolicy.");
            this.setStatusOfExceptionTerminatedDiscoveryPolicy();
        }
    }

    private void setStatusOfExceptionTerminatedDiscoveryPolicy() {
        String sql = "update T_discoverypolicy set exception_terminated = true, finished = true where finished = false";
        ServiceContext context = ServiceContext.getInstance();
        try {
            CommonUtil.sleep((long)3000L);
            ICommonService commonService = (ICommonService)context.lookup("ResourceApplication/CommonServiceImpl");
            commonService.updateBySql(sql);
        }
        catch (Throwable e) {
            LOGGER.error((Object)"Rmi service ResourceApplication/CommonServiceImpl is not available currently %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
        }
    }

    @Override
    public void init() {
        LOGGER.debug((Object)"init");
    }

    private void initDomainModel() {
        boolean success = false;
        for (int i = 0; i < 50; ++i) {
            CommonUtil.sleep((long)500L);
            try {
                this.domainContainer = (IDomainContainer)ServiceContext.getInstance().lookup(DOMAIN_NAME);
                if (this.domainContainer == null) {
                    LOGGER.info((Object)"Get domain container not succeed, will retry, i = %s", (long)i);
                    continue;
                }
                success = true;
                break;
            }
            catch (Exception e) {
                LOGGER.error((Object)"Get domain container not succeed, trying times :%s,%s ", new Object[]{i, ExceptionUtil.getErrorMessage((Throwable)e)});
            }
        }
        if (!success) {
            LOGGER.error((Object)"Get Domain/DomainContainer service error! Can't start ne sync manager.");
            return;
        }
        LOGGER.info((Object)"Successed to init domain model");
        LOGGER.info((Object)"Content of container is :%s", new Object[]{this.domainContainer.getProductMappings()});
        this.initManager();
    }

    private void initManager() {
        if (this.manager.initializer(this.domainContainer)) {
            LOGGER.info((Object)"NE Sync Plugin init ok!");
        } else {
            LOGGER.error((Object)"NE Sync Plugin init error! Can't start ne sync.");
        }
    }

    @Override
    public void destroy() {
        LOGGER.info((Object)"NE Sync Plugin destroy ok!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void onMessage(Map<String, Object> messageBody) {
        block13: {
            SynchronizeMOResult synchronizeMoResult;
            DiscoveryResult discoveryResult;
            block12: {
                discoveryResult = new DiscoveryResult();
                synchronizeMoResult = new SynchronizeMOResult();
                LOGGER.info((Object)"message is received", 1L);
                Node discoveredNode = (Node)messageBody.get("snmpDiscoveredNode");
                if (discoveredNode == null) {
                    discoveredNode = (Node)messageBody.get("icmpDiscoveredNode");
                }
                if (discoveredNode != null) {
                    LOGGER.debug((Object)"Manager.getMappings() is :%s.", new Object[]{this.manager.getMappings()});
                    LOGGER.debug((Object)"DiscoveredNode.getSysOid() is : %s.", new Object[]{discoveredNode.getSysOid()});
                    XmlSynchronizeContext xmlSynchronizeContext = this.manager.getMappings().get(discoveredNode.getSysOid());
                    LOGGER.debug((Object)"XmlSynchronizeContext is : %s.", new Object[]{xmlSynchronizeContext});
                    this.dealContect(xmlSynchronizeContext, messageBody, discoveryResult, discoveredNode, synchronizeMoResult);
                    break block12;
                }
                LOGGER.error((Object)"DiscoveredNode is null!");
            }
            try {
                this.completeDiscoverTask(messageBody, discoveryResult, synchronizeMoResult);
            }
            catch (Exception e) {
                LOGGER.error((Object)"Error complete task, exception:%s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            }
            break block13;
            catch (Throwable e) {
                try {
                    LOGGER.error((Object)"Exception when in SynchronizePlugin,%s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
                    DiscoveryPolicy policy = (DiscoveryPolicy)messageBody.get("discoveryPolicy");
                    this.extractComplexity(messageBody, discoveryResult, e, policy);
                }
                catch (Throwable throwable) {
                    try {
                        this.completeDiscoverTask(messageBody, discoveryResult, synchronizeMoResult);
                    }
                    catch (Exception e2) {
                        LOGGER.error((Object)"Error complete task, exception:%s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e2)});
                    }
                    throw throwable;
                }
                try {
                    this.completeDiscoverTask(messageBody, discoveryResult, synchronizeMoResult);
                }
                catch (Exception e3) {
                    LOGGER.error((Object)"Error complete task, exception:%s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e3)});
                }
            }
        }
    }

    private void completeDiscoverTask(Map<String, Object> messageBody, DiscoveryResult discoveryResult, SynchronizeMOResult synchronizeMoResult) {
        DiscoveryPolicy policy = (DiscoveryPolicy)messageBody.get("discoveryPolicy");
        LOGGER.info((Object)"A task is complete.");
        if (policy != null) {
            String uuidForPerDiscovery = policy.getUuidForPerDiscovery();
            if (uuidForPerDiscovery == null && !discoveryResult.getSuccess().booleanValue()) {
                ServiceProvider.getDiscoveryService().updateDiscoveryResultAndPolicy(discoveryResult, true);
            } else {
                ICommonService commonService = ServiceProvider.getCommonService();
                String sql = "select dp.discovery_policy_id from T_discoverypolicy dp where dp.uuid_for_per_discovery = ?";
                List list = commonService.findBySql(sql, new Object[]{uuidForPerDiscovery});
                this.extractNullcheck(discoveryResult, list);
            }
            LOGGER.info((Object)"DiscoveryResult.getSuccess() is: %s;synchronizeMOResult.getCount()= %s.", new Object[]{discoveryResult.getSuccess(), synchronizeMoResult.getCount()});
            this.increaseCount(discoveryResult, synchronizeMoResult, policy);
            this.updateBackTaskProgress(policy);
        } else {
            LOGGER.warn((Object)"Policy is null.");
        }
    }

    private void updateBackTaskProgress(DiscoveryPolicy policy) {
        Object object = policy.getExtendAttributeMap().get("discoveryTask");
        BackTask backTask = (BackTask)object;
        if (backTask == null) {
            LOGGER.error((Object)"Back task is null.");
            return;
        }
        IBackTaskService backTaskService = this.getBackTaskService();
        backTaskService.updateTask(backTask.getTaskId().longValue(), 99);
    }

    private IBackTaskService getBackTaskService() {
        ServiceContext context = ServiceContext.getInstance();
        IBackTaskService backTaskService = (IBackTaskService)context.lookup("task/backTask");
        LOGGER.debug((Object)"Get BackTaskService.");
        return backTaskService;
    }

    private void increaseCount(DiscoveryResult discoveryResult, SynchronizeMOResult synchronizeMoResult, DiscoveryPolicy policy) {
        if (discoveryResult.getSuccess().booleanValue()) {
            LOGGER.debug((Object)"IncreaseCount:DiscoveryResult is %s.", new Object[]{discoveryResult.getSuccess()});
            if (synchronizeMoResult.getCount() > 0) {
                SynchronizePlugin.increaseDiscoveryCount(policy, synchronizeMoResult.getCount());
            } else {
                SynchronizePlugin.increaseDiscoveryCount(policy);
            }
        } else if (synchronizeMoResult.getCount() > 0) {
            SynchronizePlugin.increaseDiscoveryCount(policy, synchronizeMoResult.getCount());
        } else {
            LOGGER.error((Object)"Not support.");
        }
    }

    private void extractNullcheck(DiscoveryResult discoveryResult, List<?> list) {
        if (list != null && !list.isEmpty()) {
            LOGGER.debug((Object)"Extract Null check:list is not null.");
            ServiceProvider.getDiscoveryService().updateDiscoveryResultAndPolicy(discoveryResult, true);
        }
    }

    private void extractComplexity(Map<String, Object> messageBody, DiscoveryResult discoveryResult, Throwable e, DiscoveryPolicy policy) {
        if (policy != null) {
            discoveryResult.setDiscoveryPolicy(policy);
            if (e instanceof LegoCheckedException) {
                LegoCheckedException legoException = (LegoCheckedException)e;
                discoveryResult.setErrorCode(Long.valueOf(legoException.getErrorCode()));
                if (legoException.getParameters() != null && legoException.getParameters().length != 0) {
                    String[] errorparam = legoException.getParameters();
                    discoveryResult.setErrorParam(this.dealErrorParam(errorparam));
                }
            } else if (e instanceof LegoUncheckedException) {
                discoveryResult.setErrorCode(Long.valueOf(((LegoUncheckedException)e).getErrorCode()));
            } else {
                discoveryResult.setErrorCode(Long.valueOf(1053L));
            }
            discoveryResult.setFinishTime(new Timestamp(System.currentTimeMillis()));
            Node discoveredNode = (Node)messageBody.get("snmpDiscoveredNode");
            if (discoveredNode == null) {
                discoveredNode = (Node)messageBody.get("icmpDiscoveredNode");
            }
            if (discoveredNode == null) {
                LOGGER.error((Object)"DiscoveredNode is null!");
            }
            if (discoveredNode != null) {
                discoveryResult.setIpAddress(discoveredNode.getIpAddress());
            }
            discoveryResult.setSuccess(Boolean.valueOf(false));
        }
    }

    private void dealContect(XmlSynchronizeContext xmlSynchronizeContext, Map<String, Object> messageBody, DiscoveryResult discoveryResult, Node discoveredNode, SynchronizeMOResult synchronizeMoResult) {
        if (xmlSynchronizeContext == null) {
            this.xmlSynchronizeContextNull(messageBody, discoveryResult, discoveredNode);
        } else {
            String key;
            ICacheService<String, Object> cacheService;
            Long finishedIpCount;
            DiscoveryPolicy policy = (DiscoveryPolicy)messageBody.get("discoveryPolicy");
            if (policy != null && (finishedIpCount = (Long)(cacheService = CacheServiceProvider.getInstance().getCacheService()).get((Object)(key = "discoveryPolicyId_" + policy.getDiscoveryPolicyId()))) == null) {
                LOGGER.info((Object)"Discovery policy stopped and will not synchronize data, policy is : %s", new Object[]{policy});
                return;
            }
            String refreshOperationUuid = (String)messageBody.get("refreshOperationUuid");
            LOGGER.info((Object)"RefreshOperationUuid is : %s", new Object[]{refreshOperationUuid});
            SynchronizeWorker worker = new SynchronizeWorker(xmlSynchronizeContext, discoveredNode, this.domainContainer, policy, refreshOperationUuid);
            LOGGER.info((Object)"A task is added.");
            if (policy != null && policy.getManualStopped().booleanValue()) {
                LOGGER.info((Object)"The policy has been stopped! node ip is : %s, policy is : %s.", new Object[]{discoveredNode.getIpAddress(), policy});
                throw new LegoUncheckedException(1058L);
            }
            worker.doSynchronizeWork(synchronizeMoResult);
            LOGGER.debug((Object)"A task is finished, task is :\u3000%s.", new Object[]{worker});
            this.extractMethod(discoveryResult, discoveredNode, xmlSynchronizeContext, policy);
        }
    }

    private String dealErrorParam(String[] errorparam) {
        StringBuffer sbf = new StringBuffer();
        for (int i = 0; i < errorparam.length - 1; ++i) {
            sbf.append(errorparam[i]);
            sbf.append(",");
        }
        sbf.append(errorparam[errorparam.length - 1]);
        LOGGER.debug((Object)"DealErrorParam");
        return sbf.toString();
    }

    private void extractMethod(DiscoveryResult discoveryResult, Node discoveredNode, XmlSynchronizeContext xmlSynchronizeContext, DiscoveryPolicy policy) {
        discoveryResult.setDiscoveryPolicy(policy);
        discoveryResult.setFinishTime(new Timestamp(System.currentTimeMillis()));
        discoveryResult.setIpAddress(discoveredNode.getIpAddress());
        if (policy != null && policy.getExtendProductAttributeMap() != null && policy.getExtendProductAttributeMap().containsKey("vendar")) {
            discoveryResult.setDeviceMainTypeI18n(policy.getDeviceType());
            discoveryResult.setDeviceSubTypeI18n(policy.getDeviceSubType());
        } else {
            discoveryResult.setDeviceMainTypeI18n(xmlSynchronizeContext.getType());
            discoveryResult.setDeviceSubTypeI18n(xmlSynchronizeContext.getSubType());
        }
        discoveryResult.setSuccess(Boolean.valueOf(true));
    }

    private void xmlSynchronizeContextNull(Map<String, Object> messageBody, DiscoveryResult discoveryResult, Node discoveredNode) {
        LOGGER.warn((Object)"XmlSynchronizeContext is : null, sys oid is : %s.", new Object[]{discoveredNode.getSysOid()});
        DiscoveryPolicy policy = (DiscoveryPolicy)messageBody.get("discoveryPolicy");
        if (policy != null) {
            Node node = new Node();
            node.setSysOid(discoveredNode.getIpAddress());
            node.setUuid(discoveredNode.getIpAddress());
            node.setName(discoveredNode.getIpAddress());
            node.setDiscoveredTime(new Timestamp(System.currentTimeMillis()));
            node.setIpAddress(discoveredNode.getIpAddress());
            node.setMainType(policy.getDeviceType());
            String subType = policy.getDeviceSubType();
            if (subType == null || "".equals(subType)) {
                node.setSubType(policy.getDeviceType());
            } else {
                node.setSubType(subType);
            }
            node.setLocation(policy.getLocation());
            node.setIsTopMo(Boolean.valueOf(true));
            TelnetPara telnetPara = policy.getTelnetPara();
            if (telnetPara != null) {
                telnetPara.setTemplateName(UUID.randomUUID().toString());
                telnetPara.setDiscoveryPolicy(null);
                telnetPara.setId(null);
                telnetPara.setIsTemplate(Boolean.valueOf(false));
                telnetPara.setIsManagementProtocol(Boolean.valueOf(true));
                telnetPara.setNode(node);
                node.addManagementProtocol(TelnetPara.class.getName(), (Protocol)telnetPara);
            }
            this.handleSnmp(discoveryResult, discoveredNode, policy, node);
        }
    }

    private void handleSnmp(DiscoveryResult discoveryResult, Node discoveredNode, DiscoveryPolicy policy, Node node) {
        if (policy.getDiscoveryNonSnmpDevice().booleanValue()) {
            String className = "lego.dic.discoverypolicy.thirdPartyDevice";
            node.setMainType(className);
            node.setSubType(className);
            node.setTopoElementId(policy.getTopoElementId());
            ServiceProvider.getResourceService().addMoAndSubMo((ManagedObject)node);
            discoveryResult.setDiscoveryPolicy(policy);
            discoveryResult.setFinishTime(new Timestamp(System.currentTimeMillis()));
            discoveryResult.setIpAddress(discoveredNode.getIpAddress());
            discoveryResult.setSuccess(Boolean.valueOf(true));
            discoveryResult.setDeviceMainTypeI18n(className);
            discoveryResult.setDeviceSubTypeI18n(className);
        } else {
            discoveryResult.setDiscoveryPolicy(policy);
            discoveryResult.setFinishTime(new Timestamp(System.currentTimeMillis()));
            discoveryResult.setIpAddress(discoveredNode.getIpAddress());
            discoveryResult.setSuccess(Boolean.valueOf(false));
            discoveryResult.setErrorCode(Long.valueOf(1057L));
        }
    }
}

