/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.nem.discover.service;

import com.huawei.lego.cbb.resource.dao.IResourceDao;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.cbb.resource.sdk.service.ILocalResourceService;
import com.huawei.lego.cbb.resource.sdk.service.IResourceService;
import com.huawei.lego.core.sdk.base.ICacheService;
import com.huawei.lego.core.sdk.base.ServiceContext;
import com.huawei.lego.core.sdk.comm.BatchOperation;
import com.huawei.lego.core.sdk.comm.BatchOperationResult;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.exception.LegoUncheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.nem.discover.sdk.model.DiscParamVilidateResult;
import com.huawei.lego.nem.discover.sdk.model.DiscoveryPolicy;
import com.huawei.lego.nem.discover.sdk.service.IDisParamValidator;
import com.huawei.lego.nem.discover.service.AutoDiscParamValidateHelper;
import com.huawei.lego.nem.discover.util.DaoFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

class DiscoveryServiceImplUtil {
    private static final Log LOGGER = LogFactory.getInstance(DiscoveryServiceImplUtil.class);
    private IResourceService resourceService = null;
    private ILocalResourceService localResourceService = null;

    DiscoveryServiceImplUtil() {
    }

    public boolean validateDiscParam(DiscoveryPolicy policy) {
        String validatorKey = policy.getDeviceType() + policy.getDeviceSubType();
        IDisParamValidator validator = AutoDiscParamValidateHelper.getInstance().getPerfServiceMap().get(validatorKey);
        if (validator == null) {
            LOGGER.error((Object)"Validate Disc Param error, the validator is null.", 1L);
            throw new LegoCheckedException(102L);
        }
        DiscParamVilidateResult result = validator.validate(policy);
        if (result == null) {
            LOGGER.error((Object)"Validate Disc Param error, the result is null.", 1L);
            throw new LegoCheckedException(102L);
        }
        if (result.isResult()) {
            return true;
        }
        Optional exceptionOpt = validator.convertValidateResult2Exception(result);
        if (exceptionOpt.isPresent()) {
            throw (LegoCheckedException)((Object)exceptionOpt.get());
        }
        if (result.getErrorCode() == -1L) {
            throw new LegoCheckedException(102L);
        }
        throw new LegoCheckedException(result.getErrorCode());
    }

    public synchronized void checkIfHasDiscovered(ICacheService<String, Object> cacheService, DiscoveryPolicy discoveryPolicy, String deviceUuid) {
        LOGGER.info((Object)("will checkIfHasDiscovered, deviceUuid is : " + deviceUuid), 1L);
        String discUniqueUuidKey = "disc_unique_" + discoveryPolicy.getUuidForPerDiscovery();
        ArrayList<String> uuidList = (ArrayList<String>)cacheService.get((Object)discUniqueUuidKey);
        if (uuidList == null) {
            uuidList = new ArrayList<String>();
            uuidList.add(deviceUuid);
            cacheService.put((Object)discUniqueUuidKey, uuidList);
        } else if (!uuidList.contains(deviceUuid)) {
            uuidList.add(deviceUuid);
        } else {
            LOGGER.warn((Object)("the device has already discovered this time, device uuid is : " + deviceUuid + ", discoveryPolicy is : " + discoveryPolicy), 1L);
            throw new LegoUncheckedException(1059L);
        }
    }

    public synchronized BatchOperationResult deleteDeviceNewWithoutMsg(ICacheService<String, Object> cacheService, List<Long> moIdList) {
        LOGGER.info((Object)("will deleteDeviceNewWithoutMsg, moIdList is : " + moIdList), 1L);
        IResourceDao resourceDao = DaoFactory.getInstance().getResourceDao();
        BatchOperationResult batchOpResult = new BatchOperationResult();
        ArrayList<BatchOperation> resultList = new ArrayList<BatchOperation>();
        int failCount = 0;
        int operCount = moIdList.size();
        IResourceService resourceServiceTemp = this.getResourceService();
        for (Long moId : moIdList) {
            LOGGER.info((Object)("willllllll delete device moid is : " + moId), 1L);
            try {
                ManagedObject lmo = resourceDao.getMoByIdAndType(ManagedObject.class, moId, null);
                LOGGER.info((Object)("llllllllllllllmo is : " + lmo), 1L);
                HashMap<String, String> map = new HashMap<String, String>();
                failCount = this.checkFail(lmo, failCount, moId, resultList, map, cacheService);
                if ("true".equals(map.get("flag"))) continue;
                resourceServiceTemp.deleteMoWithoutMsg(moId);
            }
            catch (Exception e) {
                LOGGER.error((Object)("delete device faileddddddd, moId is : " + moId + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
                ++failCount;
                BatchOperation operation = new BatchOperation();
                operation.setErrorCode(1028L);
                ManagedObject lmo = resourceDao.getMoByIdAndType(ManagedObject.class, moId, null);
                if (lmo != null) {
                    operation.setTargetName(lmo.getName());
                } else {
                    operation.setTargetName(String.valueOf(moId));
                }
                resultList.add(operation);
            }
        }
        batchOpResult.setResult(resultList);
        batchOpResult.setFailCount(failCount);
        batchOpResult.setTotalCount(operCount);
        batchOpResult.setSucceedCount(operCount - failCount);
        return batchOpResult;
    }

    private int checkFail(ManagedObject lmo, int failCount, Long moId, List<BatchOperation> resultList, Map<String, String> map, ICacheService<String, Object> cacheService) {
        if (lmo == null) {
            LOGGER.warn((Object)("tttttthe device has been already deleted, moId is : " + moId), 1L);
            ++failCount;
            BatchOperation operation = new BatchOperation();
            operation.setErrorCode(1028L);
            operation.setTargetId(moId.longValue());
            resultList.add(operation);
            map.put("flag", "true");
        } else {
            String key = "mo_uuid_" + lmo.getUuid();
            if (cacheService.containsKey((Object)key)) {
                LOGGER.warn((Object)("the device is synchronizing data, moId is : " + moId), 1L);
                ++failCount;
                BatchOperation operation = new BatchOperation();
                operation.setErrorCode(1028L);
                operation.setTargetId(moId.longValue());
                resultList.add(operation);
                map.put("flag", "true");
            }
        }
        return failCount;
    }

    public IResourceService getResourceService() {
        if (this.resourceService == null) {
            this.resourceService = (IResourceService)ServiceContext.getInstance().lookup("ResourceApplication/ResourceServiceImpl");
        }
        if (this.resourceService == null) {
            LOGGER.error((Object)"can not get resource service", 1L);
        }
        return this.resourceService;
    }

    public ILocalResourceService getLocalResourceService() {
        if (this.localResourceService == null) {
            this.localResourceService = (ILocalResourceService)ServiceContext.getInstance().lookup("ResourceApplication/LocalResourceServiceImpl");
        }
        if (this.localResourceService == null) {
            LOGGER.error((Object)"can not get resource service", 1L);
        }
        return this.localResourceService;
    }
}

