/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.nem.fault.define;

import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.NumberUtil;
import com.huawei.lego.nem.fault.sdk.model.FaultConf;
import com.huawei.lego.nem.fault.sdk.model.FaultDefine;
import com.huawei.lego.nem.fault.util.XmlParser;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public final class FaultFileParser {
    private static final Log LOGGER = LogFactory.getInstance(FaultFileParser.class);

    private FaultFileParser() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized List<FaultConf> parseFaultFile(URL url) {
        ArrayList<FaultConf> faultConfiList = new ArrayList<FaultConf>();
        InputStream inStream = null;
        try {
            inStream = url.openStream();
            XmlParser parser = XmlParser.getXmlDomParser(inStream);
            if (null == parser) {
                ArrayList<FaultConf> arrayList = faultConfiList;
                return arrayList;
            }
            Element parent = parser.treeWalkOfOneElementNode("trapcfg");
            String productName = "SystemReporter";
            Collection<Object> elementList = new ArrayList();
            if (null != parent) {
                elementList = parser.getChildren(parent, "traps");
                for (Element element : elementList) {
                    faultConfiList.addAll(FaultFileParser.parseFaultsNode(parser, parent, element, productName, url.getPath()));
                }
            }
            if (elementList.isEmpty() && null != parent) {
                faultConfiList.addAll(FaultFileParser.parseCfgTrap(parent, productName, url.getPath()));
            }
        }
        catch (SAXException e) {
            LOGGER.error((Object)"SAXException in parseFaultFile.", 1L);
        }
        catch (IOException e) {
            LOGGER.error((Object)"IOException in parseFaultFile.", 1L);
        }
        finally {
            try {
                if (null != inStream) {
                    inStream.close();
                }
            }
            catch (IOException e) {
                LOGGER.error((Object)"IOException in parseFaultFile.", 1L);
            }
        }
        return faultConfiList;
    }

    private static List<FaultConf> parseFaultsNode(XmlParser parser, Element parent, Element element, String productName, String faultFileName) {
        if (parent == null) {
            LOGGER.error((Object)"Parent is null!");
            return new ArrayList<FaultConf>();
        }
        String moMainType = parent.getAttribute("moMainType");
        String moSubType = parent.getAttribute("moSubType");
        String trapclass = parent.getAttribute("trapclass");
        String synchronizeclass = parent.getAttribute("synchronizeclass");
        String trapoid = element.getAttribute("trapoid");
        String basetrap = element.getAttribute("includetrap");
        String isBaseCfg = parent.getAttribute("basecfg");
        String includeOffLineAlarm = parent.getAttribute("includeOffLineAlarm");
        String matchAlarmtTraps = element.getAttribute("matchAlarm");
        String extendTrapsProperty = element.getAttribute("extend-property");
        if ("".equals(trapclass) && "".equals(synchronizeclass)) {
            productName = "";
        }
        String[] moSubTypes = new String[]{""};
        if (null != moSubType && !"".equals(moSubType)) {
            moSubTypes = moSubType.split(",");
        }
        ArrayList<FaultConf> faultConfList = new ArrayList<FaultConf>();
        Collection<Element> elements = parser.getChildren(element, "trap");
        for (String subType : moSubTypes) {
            FaultConf faultConf = new FaultConf(productName, trapoid, trapclass, synchronizeclass);
            faultConf.addFileNames(faultFileName);
            faultConf.setMoMainType(moMainType);
            faultConf.setMoSubType(subType);
            if (basetrap != null && !"".equals(basetrap)) {
                faultConf.setIncludeAlarmFile(basetrap.split(","));
            }
            String[] deviceArr = new String[]{productName, moMainType, subType, trapoid, matchAlarmtTraps};
            FaultFileParser.parseElement(parser, deviceArr, extendTrapsProperty, elements, faultConf);
            FaultFileParser.faultConf(isBaseCfg, includeOffLineAlarm, faultConf);
            faultConfList.add(faultConf);
        }
        return faultConfList;
    }

    private static void faultConf(String isBaseCfg, String includeOffLineAlarm, FaultConf faultConf) {
        if ("true".equalsIgnoreCase(isBaseCfg)) {
            faultConf.setBaseCfg(true);
        }
        if ("false".equalsIgnoreCase(includeOffLineAlarm)) {
            faultConf.setIncludeOffLineAlarm(false);
        }
    }

    private static void parseElement(XmlParser parser, String[] deviceArr, String extendTrapsProperty, Collection<Element> elements, FaultConf faultConf) {
        String productName = deviceArr[0];
        String moMainType = deviceArr[1];
        String subType = deviceArr[2];
        String trapoid = deviceArr[3];
        String matchAlarmtTraps = deviceArr[4];
        for (Element ele : elements) {
            String extendTrapProperty = ele.getAttribute("extend-property");
            FaultDefine faultDefine = FaultFileParser.getEntityByNode(parser, ele);
            if (faultDefine == null) continue;
            faultDefine.setTrapsExtendProperty(extendTrapsProperty);
            faultDefine.setTrapExtendProperty(extendTrapProperty);
            faultDefine.setProductName(productName);
            faultDefine.setMoMainType(moMainType);
            faultDefine.setMoSubType(subType);
            faultDefine.setTrapoid(trapoid);
            String matchAlarmtTrap = ele.getAttribute("matchAlarm");
            if (matchAlarmtTrap != null && !"".equals(matchAlarmtTrap)) {
                faultDefine.setMatchAlarm(matchAlarmtTrap);
            } else if (matchAlarmtTraps != null && !"".equals(matchAlarmtTraps)) {
                faultDefine.setMatchAlarm(matchAlarmtTraps);
            }
            faultConf.addFaultDefine(faultDefine);
        }
    }

    private static List<FaultConf> parseCfgTrap(Element parent, String productName, String faultFileName) {
        String moMainType = parent.getAttribute("moMainType");
        String moSubType = parent.getAttribute("moSubType");
        String trapclass = parent.getAttribute("trapclass");
        String synchronizeclass = parent.getAttribute("synchronizeclass");
        String isBaseCfg = parent.getAttribute("basecfg");
        String includeOffLineAlarm = parent.getAttribute("includeOffLineAlarm");
        if ("".equals(trapclass) && "".equals(synchronizeclass)) {
            productName = "";
        }
        String[] moSubTypes = new String[]{""};
        if (moSubType != null && !"".equals(moSubType)) {
            moSubTypes = moSubType.split(",");
        }
        ArrayList<FaultConf> faultConfList = new ArrayList<FaultConf>();
        for (String subType : moSubTypes) {
            FaultConf faultConf = new FaultConf(productName, "", trapclass, synchronizeclass);
            faultConf.addFileNames(faultFileName);
            faultConf.setMoMainType(moMainType);
            faultConf.setMoSubType(subType);
            FaultFileParser.faultConf(isBaseCfg, includeOffLineAlarm, faultConf);
            faultConfList.add(faultConf);
        }
        return faultConfList;
    }

    private static FaultDefine getEntityByNode(XmlParser parser, Element node) {
        try {
            FaultDefine faultDefine = new FaultDefine();
            String faultId = node.getAttribute("ID");
            if (FaultFileParser.isNull(faultId)) {
                LOGGER.info((Object)"faultId is null.");
                return null;
            }
            faultDefine.setFaultId(faultId);
            String rid = node.getAttribute("RID");
            if (!FaultFileParser.isNull(rid)) {
                faultDefine.setRelateId(rid);
            }
            if (!node.hasAttribute("KeyIndexs")) {
                faultDefine.setKeyIndexs("AllKeyIndexs");
            } else {
                faultDefine.setKeyIndexs(node.getAttribute("KeyIndexs"));
            }
            String trapType = node.getAttribute("TrapType");
            if (!FaultFileParser.isNull(trapType)) {
                faultDefine.setTrapType(NumberUtil.convertToInteger((Object)trapType).intValue());
            }
            FaultFileParser.setBasicProp(faultDefine, parser, node);
            return faultDefine;
        }
        catch (Exception e) {
            LOGGER.error((Object)("parse trapitems failed: " + node.getAttribute("ID") + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
            return null;
        }
    }

    private static void setBasicProp(FaultDefine faultDefine, XmlParser parser, Element node) {
        String name;
        String secerity;
        String type;
        String sid;
        HashMap<String, String> trapProp = new HashMap<String, String>();
        Collection<Element> elements = parser.getChildren(node, "item");
        for (Element element : elements) {
            trapProp.put(element.getAttribute("name"), element.getAttribute("value"));
        }
        String gid = (String)trapProp.get("GID");
        if (!FaultFileParser.isNull(gid)) {
            faultDefine.setGenericType(NumberUtil.convertToInteger((Object)gid).intValue());
        }
        if (!FaultFileParser.isNull(sid = (String)trapProp.get("SID"))) {
            faultDefine.setSpecificType(NumberUtil.convertToInteger((Object)sid).intValue());
        }
        if (!FaultFileParser.isNull(type = (String)trapProp.get("Type"))) {
            faultDefine.setFaultType(NumberUtil.convertToInteger((Object)type).intValue());
        }
        if (!FaultFileParser.isNull(secerity = (String)trapProp.get("Severity"))) {
            faultDefine.setFaultLevel(NumberUtil.convertToInteger((Object)secerity).intValue());
        }
        if (FaultFileParser.isNull(name = (String)trapProp.get("Name"))) {
            name = FaultFileParser.getString(faultDefine.getFaultId(), ".alarm.name");
        }
        faultDefine.setFaultName(name);
        String desc = (String)trapProp.get("Desc");
        if (FaultFileParser.isNull(desc)) {
            desc = FaultFileParser.getString(faultDefine.getFaultId(), ".alarm.desc");
        }
        faultDefine.setFaultDesc(desc);
        String effect = (String)trapProp.get("Effect");
        if (FaultFileParser.isNull(effect)) {
            effect = FaultFileParser.getString(faultDefine.getFaultId(), ".alarm.effect");
        }
        faultDefine.setSysEffect(effect);
        String advice = (String)trapProp.get("Advice");
        FaultFileParser.processAdvice(faultDefine, advice);
        String location = (String)trapProp.get("Location");
        FaultFileParser.processLocation(faultDefine, location);
    }

    private static void processAdvice(FaultDefine faultDefine, String advice) {
        if (FaultFileParser.isNull(advice)) {
            advice = FaultFileParser.getString(faultDefine.getFaultId(), ".alarm.advice");
        }
        faultDefine.setAdvice(advice);
    }

    private static void processLocation(FaultDefine faultDefine, String location) {
        if (FaultFileParser.isNull(location)) {
            location = FaultFileParser.getString(faultDefine.getFaultId(), ".alarm.location");
        }
        faultDefine.setLocation(location);
    }

    private static boolean isNull(String str) {
        return str == null || "".equals(str);
    }

    private static String getString(String faultId, String faultPostfix) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(faultId);
        buffer.append(faultPostfix);
        return buffer.toString();
    }
}

