/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.nem.fault.launcher.impl;

import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.nem.fault.define.FaultDefineCacher;
import com.huawei.lego.nem.fault.launcher.IFaultLauncher;
import com.huawei.lego.nem.fault.launcher.impl.TrapServiceBean;
import com.huawei.lego.nem.fault.sdk.model.FaultDefine;
import com.huawei.lego.nem.fault.sdk.model.LegoEvent;
import com.huawei.lego.nem.fault.sdk.service.ITrapService;
import com.huawei.lego.nem.fault.trap.recv.TrapMsgLauncher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class TrapReceiverLauncher
implements IFaultLauncher {
    private static List<TrapServiceBean> trapServiceList = Collections.synchronizedList(new ArrayList());
    private static Set<String> validTrapoids = new HashSet<String>();
    private static Log logger = LogFactory.getInstance(TrapReceiverLauncher.class);
    private TrapMsgLauncher snmpReceiver = new TrapMsgLauncher();

    @Override
    public void start() {
        logger.info((Object)"[FaultLauncher] begin to start TrapReceiverLauncher.", 1L);
        this.snmpReceiver.start();
    }

    @Override
    public void stop() {
        this.snmpReceiver.stop();
        trapServiceList.clear();
        validTrapoids.clear();
    }

    public static boolean isFaultTrap(String trapoid) {
        return validTrapoids.contains(trapoid);
    }

    public static void addTrapService(ITrapService service, String productName, String trapoid) {
        validTrapoids.add(trapoid);
        TrapServiceBean serviceBean = new TrapServiceBean(productName, trapoid, service);
        if (!trapServiceList.contains(serviceBean)) {
            logger.debug((Object)new StringBuilder().append("add an TrapService: ").append(service.getClass().getName()).append(", productName: ").append(productName).append(", trapoid: ").append(trapoid), 1L);
            trapServiceList.add(serviceBean);
            return;
        }
        logger.debug((Object)("ITrapService has been initialized and existed in trapServiceList: " + service.getClass().getName() + ", trapoid: " + trapoid), 1L);
    }

    public static ITrapService getTrapService(String agentIP, String trapoid) {
        for (TrapServiceBean bean : trapServiceList) {
            if (!bean.getTrapoid().equals(trapoid)) continue;
            ITrapService service = bean.getService();
            if (null == service) {
                logger.error((Object)("service is null while getTrapService, trapoid: " + trapoid + ", agentIP: " + agentIP), 1L);
                continue;
            }
            boolean isMyMo = service.isMyMOIP(agentIP);
            if (!isMyMo) {
                logger.error((Object)("isMyMOIP return false while getTrapService, service: " + service.getClass().getName() + "trapoid: " + trapoid + ", agentIP: " + agentIP), 1L);
                continue;
            }
            return service;
        }
        return null;
    }

    public static FaultDefine getFaultDefine(ITrapService service, LegoEvent legoEvent) {
        return TrapReceiverLauncher.getFaultDefine(service, legoEvent.getEventId(), legoEvent.getMoMainType(), legoEvent.getMoSubType());
    }

    private static FaultDefine getFaultDefine(ITrapService service, String faultId, String moMainType, String moSubType) {
        for (TrapServiceBean bean : trapServiceList) {
            if (null == service || service != bean.getService()) continue;
            FaultDefine faultDefine = FaultDefineCacher.getFaultDefine(bean.getProductName(), bean.getTrapoid(), faultId, moMainType, moSubType);
            if (null != faultDefine) {
                return faultDefine;
            }
            logger.debug((Object)("getFaultDefine from service return null: " + service.getClass().getName() + ", productName: " + bean.getProductName() + ", trapoid: " + bean.getTrapoid() + ", faultId: " + faultId), 1L);
        }
        return null;
    }

    public static List<FaultDefine> getFaultDefineListByOid(String trapOid, String moMainType, String moSubType) {
        for (TrapServiceBean bean : trapServiceList) {
            if (null == trapOid || !trapOid.equals(bean.getTrapoid())) continue;
            List<FaultDefine> faultDefinedList = FaultDefineCacher.getFaultDefines(trapOid, moMainType, moSubType);
            if (null != faultDefinedList) {
                return faultDefinedList;
            }
            logger.debug((Object)("getFaultDefineList from service return null: , productName: " + bean.getProductName() + ", trapoid: " + bean.getTrapoid()), 1L);
        }
        return null;
    }
}

