/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.nem.fault.msg.listener;

import com.huawei.lego.comm.internal.jms.MessageTopic;
import com.huawei.lego.comm.internal.jms.MessageUnit;
import com.huawei.lego.core.base.thread.CommonThread;
import com.huawei.lego.core.base.thread.ExecutionService;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.NumberUtil;
import com.huawei.lego.nem.fault.dao.IFaultUserDao;
import com.huawei.lego.nem.fault.launcher.impl.MsgSubscribeLauncher;
import com.huawei.lego.nem.fault.sdk.model.AlarmCount;
import com.huawei.lego.nem.fault.sdk.model.AlarmStatistic;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AlarmStatisticListener {
    private static final Object SLOCK = new Object();
    private static Map<Long, AlarmStatistic> statisticMap = new HashMap<Long, AlarmStatistic>();
    private static Map<String, AlarmCount> alarmCountMap = new HashMap<String, AlarmCount>();
    private static final long SLEEP_TIME = 15000L;
    private static final Log LOGGER = LogFactory.getInstance(AlarmStatisticListener.class);
    private IFaultUserDao faultUserDao = null;
    private boolean isContinueRunning = true;

    public void start() {
        final AlarmStatisticListener listener = this;
        CommonThread thread = new CommonThread(){

            @Override
            protected void execute() {
                listener.execute();
            }
        };
        thread.setThreadName("alarm statistic thread");
        ExecutionService.submitTask(thread);
    }

    public void stop() {
        this.isContinueRunning = false;
    }

    public void execute() {
        while (this.isContinueRunning) {
            try {
                CommonUtil.sleep((long)15000L);
                this.updateStatistic();
            }
            catch (Exception e) {
                LOGGER.error((Object)("Throwable was caught when in Thread[alarm statistic thread]." + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
                try {
                    this.updateStatistic();
                }
                catch (Exception ex) {
                    LOGGER.error((Object)("Exception was caught in alarm statistic thread while retry." + ExceptionUtil.getErrorMessage((Throwable)ex)), 1L);
                }
            }
        }
    }

    private void updateStatistic() {
        HashMap<Long, AlarmStatistic> tmpStatistic = new HashMap<Long, AlarmStatistic>();
        HashMap<String, AlarmCount> tmpCount = new HashMap<String, AlarmCount>();
        List<?> allCount = this.faultUserDao.queryAllMoIds();
        if (null == allCount) {
            return;
        }
        for (Object info : allCount) {
            long moId = NumberUtil.convertToLong((Object)info[0].toString());
            if (moId == 0L) continue;
            String moName = info[1].toString();
            AlarmStatistic statistic = new AlarmStatistic(moId, moName);
            tmpStatistic.put(moId, statistic);
            AlarmCount alarmCount = new AlarmCount(moId, moName);
            tmpCount.put(moId + "_" + moName, alarmCount);
        }
        List<?> unClearedCount = this.faultUserDao.queryAllAlarmCount("clearStatus", 0);
        if (null == unClearedCount) {
            return;
        }
        for (Object[] info : unClearedCount) {
            long moId = NumberUtil.convertToLong((Object)info[0].toString());
            String moName = info[1].toString();
            FaultEnum.AlarmSeverity severity = FaultEnum.AlarmSeverity.getSeverity((int)NumberUtil.convertToInteger((Object)info[2].toString()));
            int count = NumberUtil.convertToInteger((Object)info[3].toString());
            AlarmStatistic statistic = (AlarmStatistic)tmpStatistic.get(moId);
            if (null == statistic) {
                statistic = new AlarmStatistic(moId, moName);
            }
            statistic.updateUnClearedCount(severity, count);
            tmpStatistic.put(moId, statistic);
            AlarmCount alarmCount = (AlarmCount)tmpCount.get(moId + "_" + moName);
            alarmCount = this.extracted(moId, moName, alarmCount);
            alarmCount.updateCount(severity, count);
            tmpCount.put(moId + "_" + moName, alarmCount);
        }
        List<Object[]> unConfirmedCount = this.faultUserDao.queryAllAlarmCount("confirmStatus", 0);
        if (null == unConfirmedCount) {
            return;
        }
        this.updateStatistic(tmpStatistic, tmpCount, unConfirmedCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateStatistic(Map<Long, AlarmStatistic> tmpStatistic, Map<String, AlarmCount> tmpCount, List<Object[]> unConfirmedCount) {
        for (Object[] info : unConfirmedCount) {
            if (info.length < 4) continue;
            long moId = NumberUtil.convertToLong((Object)info[0].toString());
            String moName = info[1].toString();
            FaultEnum.AlarmSeverity severity = FaultEnum.AlarmSeverity.getSeverity((int)NumberUtil.convertToInteger((Object)info[2].toString()));
            int count = NumberUtil.convertToInteger((Object)info[3].toString());
            AlarmStatistic statistic = tmpStatistic.get(moId);
            if (null == statistic) {
                statistic = new AlarmStatistic(moId, moName);
            }
            statistic.updateUnConfirmedCount(severity, count);
            tmpStatistic.put(moId, statistic);
        }
        HashMap<Long, AlarmStatistic> statisticChange = new HashMap<Long, AlarmStatistic>();
        Set<Map.Entry<Long, AlarmStatistic>> entrys = tmpStatistic.entrySet();
        for (Map.Entry<Long, AlarmStatistic> entry : entrys) {
            Long moId = entry.getKey();
            AlarmStatistic newAlarm = entry.getValue();
            Object object = SLOCK;
            synchronized (object) {
                AlarmStatistic oldAlarm = statisticMap.get(moId);
                if (!newAlarm.equals((Object)oldAlarm)) {
                    statisticChange.put(newAlarm.getMoId(), newAlarm);
                }
            }
        }
        Map<String, AlarmCount> moId = SLOCK;
        synchronized (moId) {
            statisticMap.clear();
            statisticMap.putAll(tmpStatistic);
        }
        moId = alarmCountMap;
        synchronized (moId) {
            alarmCountMap.clear();
            alarmCountMap.putAll(tmpCount);
        }
        if (!statisticChange.isEmpty()) {
            MessageUnit mu = new MessageUnit();
            mu.setCmdcode(5002L);
            mu.setObj(statisticChange);
            mu.setMt(MessageTopic.DATA);
            mu.setSourceAppName("AlarmStatisticListener");
            MsgSubscribeLauncher.getMc().sendMessage(mu);
        }
    }

    private AlarmCount extracted(long moId, String moName, AlarmCount alarmCount) {
        if (null == alarmCount) {
            alarmCount = new AlarmCount(moId, moName);
        }
        return alarmCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<AlarmStatistic> getAllStatistic(Set<Long> moIdList) {
        Object object = SLOCK;
        synchronized (object) {
            ArrayList<AlarmStatistic> statisticList = new ArrayList<AlarmStatistic>();
            if (null == moIdList) {
                statisticList.addAll(statisticMap.values());
                return statisticList;
            }
            for (AlarmStatistic statistic : statisticMap.values()) {
                if (statistic.getMoId() < 0L) {
                    statisticList.add(statistic);
                }
                if (!moIdList.contains(statistic.getMoId())) continue;
                statisticList.add(statistic);
            }
            return statisticList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<Long, AlarmStatistic> getAllStatistic() {
        Object object = SLOCK;
        synchronized (object) {
            return statisticMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<AlarmCount> getAlarmCount(Set<Long> moIdList) {
        Map<String, AlarmCount> map = alarmCountMap;
        synchronized (map) {
            ArrayList<AlarmCount> countList = new ArrayList<AlarmCount>();
            for (AlarmCount alarmCount : alarmCountMap.values()) {
                if (null == moIdList) {
                    countList.add(alarmCount);
                    continue;
                }
                long moId = alarmCount.getMoId();
                if (moId < 0L) {
                    countList.add(alarmCount);
                }
                if (!moIdList.contains(moId)) continue;
                countList.add(alarmCount);
            }
            return countList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AlarmStatistic getStatistic(long moId) {
        Object object = SLOCK;
        synchronized (object) {
            return statisticMap.get(moId);
        }
    }

    public void setFaultUserDao(IFaultUserDao faultUserDao) {
        this.faultUserDao = faultUserDao;
    }
}

