/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.nem.fault.product;

import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.nem.fault.sdk.model.Alarm;
import com.huawei.lego.nem.fault.sdk.model.Annotation;
import com.huawei.lego.nem.fault.sdk.service.IProductDelAlarmService;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class DelAlarmServiceContainer {
    private static final Log logger = LogFactory.getInstance(DelAlarmServiceContainer.class);
    private static List<IProductDelAlarmService> delAlarmSrvList = new ArrayList<IProductDelAlarmService>();

    public static void delAlarmSendMessage(List<Alarm> alarmList, List<Annotation> annotationList) {
        if (null == delAlarmSrvList || delAlarmSrvList.isEmpty()) {
            return;
        }
        try {
            for (IProductDelAlarmService service : delAlarmSrvList) {
                service.sendDelMessage(alarmList, annotationList);
            }
        }
        catch (Exception t) {
            logger.error((Object)("DelAlarmServiceContainer exception." + ExceptionUtil.getErrorMessage((Throwable)t)), 1L);
        }
    }

    public void onBind(IProductDelAlarmService service, Map<String, String> properties) {
        if (null != service) {
            delAlarmSrvList.add(service);
            logger.info((Object)String.format(Locale.ENGLISH, "OnBind:%s.", service), 1L);
        } else {
            logger.info((Object)"onBind,service is null.", 1L);
        }
    }

    public void onUnbind(IProductDelAlarmService service, Map<String, String> properties) {
        if (null != service) {
            delAlarmSrvList.remove(service);
            logger.info((Object)String.format(Locale.ENGLISH, "OnUnbind:%s.", service), 1L);
        } else {
            logger.info((Object)"onUnbind,service is null.", 1L);
        }
    }

    public static List<IProductDelAlarmService> getDelAlarmSrvList() {
        return delAlarmSrvList;
    }

    public static void setDelAlarmSrvList(List<IProductDelAlarmService> delAlarmSrvList) {
        DelAlarmServiceContainer.delAlarmSrvList = delAlarmSrvList;
    }
}

