/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.nem.fault.service;

import com.google.common.collect.ImmutableSet;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.cbb.resource.sdk.model.TopoObject;
import com.huawei.lego.cbb.task.sysjob.StorageFactory;
import com.huawei.lego.com.south.sdk.model.SnmpV3Param;
import com.huawei.lego.core.base.thread.ExecutionService;
import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.base.ServiceContext;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.comm.BatchOperation;
import com.huawei.lego.core.sdk.comm.BatchOperationResult;
import com.huawei.lego.core.sdk.comm.Paging;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.exception.LegoUncheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.nem.fault.FaultApplication;
import com.huawei.lego.nem.fault.dao.IAlarmDAO;
import com.huawei.lego.nem.fault.dao.IFaultDao;
import com.huawei.lego.nem.fault.dao.IFaultUserDao;
import com.huawei.lego.nem.fault.launcher.FaultLauncher;
import com.huawei.lego.nem.fault.msg.FaultMsgCenter;
import com.huawei.lego.nem.fault.msg.FaultMsgType;
import com.huawei.lego.nem.fault.product.AffirmAlarmProcess;
import com.huawei.lego.nem.fault.product.LinkResServiceContainer;
import com.huawei.lego.nem.fault.sdk.model.Alarm;
import com.huawei.lego.nem.fault.sdk.model.AlarmDetail;
import com.huawei.lego.nem.fault.sdk.model.Annotation;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import com.huawei.lego.nem.fault.sdk.model.LegoAlarm;
import com.huawei.lego.nem.fault.sdk.service.FaultQueryInfo;
import com.huawei.lego.nem.fault.sdk.service.IAlarmService;
import com.huawei.lego.nem.fault.sdk.service.IFaultGenerateService;
import com.huawei.lego.nem.fault.sdk.service.ISnmpV3Service;
import com.huawei.lego.nem.fault.util.FaultUtil;
import com.huawei.lego.nem.fault.util.snmp.Snmpv3Util;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

@Service(name="alarmService", desc="", interfaceClass=IAlarmService.class)
public class AlarmServiceImpl
extends BaseService
implements IAlarmService {
    private static final Log logger = LogFactory.getInstance(AlarmServiceImpl.class);
    private static final Set<String> CURRENT_ALARM_DUMP_IDS = ImmutableSet.of((Object)"0x0", (Object)"0x1");
    private IAlarmDAO alarmDAO = null;
    private IFaultDao faultDao = null;
    private IFaultUserDao faultUserDao = null;

    public List<LegoAlarm> getAlarmList(long moId) {
        logger.debug((Object)"getAlarmList");
        return this.getAlarmList(moId, -1, -1);
    }

    public List<Alarm> getAlarmList(int firstRowIndex, int totalRow) {
        HashMap<String, String> condition = new HashMap<String, String>();
        condition.put("clearStatus", "0");
        FaultQueryInfo queryInfo = new FaultQueryInfo();
        queryInfo.setFirstRowIndex(firstRowIndex);
        queryInfo.setTotalRow(totalRow);
        queryInfo.setOrderByField("alarmId");
        queryInfo.setOrderByAscend(false);
        List<Alarm> alarmList = this.faultDao.queryFaults(Alarm.class, condition, false, queryInfo);
        logger.debug((Object)"getAlarmList:completed");
        return alarmList;
    }

    public List<LegoAlarm> getAlarmList(long moId, int firstRowIndex, int totalRow) {
        ArrayList<LegoAlarm> existedAlarm = new ArrayList<LegoAlarm>();
        HashMap<String, String> condition = new HashMap<String, String>();
        condition.put("source", String.valueOf(moId));
        FaultQueryInfo queryInfo = new FaultQueryInfo();
        queryInfo.setFirstRowIndex(firstRowIndex);
        queryInfo.setTotalRow(totalRow);
        queryInfo.setOrderByField("alarmId");
        queryInfo.setOrderByAscend(false);
        List<?> alarmList = this.faultDao.queryFaults(Alarm.class, condition, false, queryInfo);
        if (alarmList == null) {
            return existedAlarm;
        }
        for (Alarm alarm : alarmList) {
            condition.clear();
            condition.put("entity", alarm.getEntity());
            FaultQueryInfo queryInfo1 = new FaultQueryInfo();
            queryInfo1.setFirstRowIndex(0);
            queryInfo1.setTotalRow(Integer.MAX_VALUE);
            queryInfo1.setOrderByField("id");
            queryInfo1.setOrderByAscend(false);
            List<?> detailList = this.faultDao.queryFaults(Annotation.class, condition, false, queryInfo1);
            ArrayList<AlarmDetail> alarmDetailList = new ArrayList<AlarmDetail>();
            for (Annotation annotation : detailList) {
                alarmDetailList.add(FaultUtil.annotationToAlarmDetail(annotation));
            }
            LegoAlarm legoAlarm = FaultUtil.alarmToLegoAlarm(alarm);
            if (legoAlarm != null) {
                legoAlarm.setDetailList(alarmDetailList);
            }
            existedAlarm.add(legoAlarm);
        }
        logger.debug((Object)"getAlarmList:completed");
        return existedAlarm;
    }

    public List<LegoAlarm> getAlarmList(FaultEnum.ClearState clearState, String alarmName, FaultQueryInfo queryInfo, long userId) {
        int firstRowIndex = queryInfo.getFirstRowIndex();
        int totalRow = queryInfo.getTotalRow();
        String orderByField = queryInfo.getOrderByField();
        boolean orderByAscend = queryInfo.isOrderByAscend();
        if (alarmName == null || "".equals(alarmName.trim())) {
            return this.getAlarms(clearState, firstRowIndex, totalRow, orderByField, orderByAscend, userId);
        }
        HashMap<String, String> condition = new HashMap<String, String>();
        condition.put("alarmName", alarmName.trim());
        condition.put("clearStatus", String.valueOf(clearState.getValue()));
        List<?> alarmList = null;
        alarmList = userId >= 0L ? this.faultUserDao.queryFaults(Alarm.class, condition, true, queryInfo, userId) : this.faultDao.queryFaults(Alarm.class, condition, true, queryInfo);
        ArrayList<LegoAlarm> resultList = new ArrayList<LegoAlarm>();
        if (alarmList != null) {
            for (Alarm alarm : alarmList) {
                LegoAlarm legoAlarmy = FaultUtil.alarmToLegoAlarm(alarm);
                resultList.add(legoAlarmy);
            }
        }
        logger.debug((Object)"getAlarmList:completed");
        return resultList;
    }

    public List<LegoAlarm> getAlarmList(FaultEnum.ClearState clearState, Map<String, String> condition, FaultQueryInfo queryInfo, long userId) {
        if (clearState != null) {
            condition.put("clearStatus", String.valueOf(clearState.getValue()));
        }
        List<?> alarmList = null;
        alarmList = userId >= 0L ? this.faultUserDao.queryFaults(Alarm.class, condition, false, queryInfo, userId) : this.faultDao.queryFaults(Alarm.class, condition, false, queryInfo);
        ArrayList<LegoAlarm> resultList = new ArrayList<LegoAlarm>();
        if (alarmList != null) {
            logger.debug((Object)"getAlarmList:alarmList is not null");
            for (Alarm alarm : alarmList) {
                LegoAlarm legoAlarm = FaultUtil.alarmToLegoAlarm(alarm);
                resultList.add(legoAlarm);
            }
        }
        return resultList;
    }

    public Paging getAlarmsAndCount(FaultEnum.ClearState clearState, int firstRowIndex, int totalRow, String orderByField, boolean orderByAscend, long userId) {
        logger.debug((Object)String.format(Locale.ENGLISH, "GetAlarmsAndCount:userId is %s.", userId));
        List<LegoAlarm> legoAlarmList = this.getAlarms(clearState, firstRowIndex, totalRow, orderByField, orderByAscend, userId);
        Paging roPaging = new Paging();
        roPaging.setiCount(this.geAlarmCount(clearState, userId).intValue());
        roPaging.setData(legoAlarmList);
        return roPaging;
    }

    public Paging getAlarmsAndCount(FaultEnum.ClearState clearState, String alarmName, FaultQueryInfo queryInfo, long userId) {
        logger.debug((Object)String.format(Locale.ENGLISH, "GetAlarmsAndCount:userId is %s.", userId));
        List<LegoAlarm> legoAlarmList = this.getAlarmList(clearState, alarmName, queryInfo, userId);
        Paging roPaging = new Paging();
        roPaging.setiCount(this.getAlarmCount(clearState, alarmName, userId).intValue());
        roPaging.setData(legoAlarmList);
        return roPaging;
    }

    public Paging getAlarmsAndCount(FaultEnum.ClearState clearState, Map<String, String> condition, FaultQueryInfo queryInfo, long userId) {
        logger.debug((Object)String.format(Locale.ENGLISH, "GetAlarmsAndCount:userId is %s.", userId));
        List<LegoAlarm> legoAlarmList = this.getAlarmList(clearState, condition, queryInfo, userId);
        Paging roPaging = new Paging();
        roPaging.setiCount(this.getAlarmCount(clearState, condition, userId).intValue());
        roPaging.setData(legoAlarmList);
        return roPaging;
    }

    public Paging getFilterAlarmsAndCount(FaultEnum.ClearState clearState, int firstRowIndex, int totalRow, String orderByField, boolean orderByAscend, long userId) {
        List<LegoAlarm> legoAlarmList = this.getFilterAlarms(clearState, firstRowIndex, totalRow, orderByField, orderByAscend, userId);
        Paging roPaging = new Paging();
        roPaging.setiCount(this.getFilterAlarmCount(clearState, userId).intValue());
        roPaging.setData(legoAlarmList);
        logger.debug((Object)"getFilterAlarmsAndCount:completed");
        return roPaging;
    }

    private List<LegoAlarm> getFilterAlarms(FaultEnum.ClearState clearState, int firstRowIndex, int totalRow, String orderByField, boolean orderByAscend, long userId) {
        HashMap<String, String> condition = new HashMap<String, String>();
        condition.put("clearStatus", String.valueOf(clearState.getValue()));
        condition.put("isFilterForThirdDevice", String.valueOf(1));
        List<?> alarmLists = null;
        FaultQueryInfo queryInfo = new FaultQueryInfo();
        queryInfo.setFirstRowIndex(firstRowIndex);
        queryInfo.setTotalRow(totalRow);
        queryInfo.setOrderByField(orderByField);
        queryInfo.setOrderByAscend(orderByAscend);
        alarmLists = userId >= 0L ? this.faultUserDao.queryFaults(Alarm.class, condition, false, queryInfo, userId) : this.faultDao.queryFaults(Alarm.class, condition, false, queryInfo);
        ArrayList<LegoAlarm> resultListes = new ArrayList<LegoAlarm>();
        if (alarmLists != null) {
            logger.debug((Object)"getFilterAlarms:alarmLists is not null");
            for (Alarm alarmList : alarmLists) {
                LegoAlarm legoAlarm = FaultUtil.alarmToLegoAlarm(alarmList);
                resultListes.add(legoAlarm);
            }
        }
        return resultListes;
    }

    private List<LegoAlarm> getAlarms(FaultEnum.ClearState clearState, int firstRowIndexs, int totalRow, String orderByField, boolean orderByAscend, long userId) {
        HashMap<String, String> conditions = new HashMap<String, String>();
        conditions.put("clearStatus", String.valueOf(clearState.getValue()));
        List<?> alarmListsxx = null;
        FaultQueryInfo queryInfo = new FaultQueryInfo();
        queryInfo.setFirstRowIndex(firstRowIndexs);
        queryInfo.setTotalRow(totalRow);
        queryInfo.setOrderByField(orderByField);
        queryInfo.setOrderByAscend(orderByAscend);
        alarmListsxx = userId >= 0L ? this.faultUserDao.queryFaults(Alarm.class, conditions, false, queryInfo, userId) : this.faultDao.queryFaults(Alarm.class, conditions, false, queryInfo);
        ArrayList<LegoAlarm> resultListex = new ArrayList<LegoAlarm>();
        if (null != alarmListsxx) {
            logger.debug((Object)"getAlarms:alarmListsxx is not null");
            for (int ii = 0; ii < alarmListsxx.size(); ++ii) {
                LegoAlarm legoAlarms = FaultUtil.alarmToLegoAlarm((Alarm)alarmListsxx.get(ii));
                resultListex.add(legoAlarms);
            }
        }
        return resultListex;
    }

    public Integer getAlarmCount(FaultEnum.ClearState clearState, String alarmName, long userId) {
        logger.debug((Object)"getAlarmCount");
        if (null == alarmName || "".equals(alarmName.trim())) {
            return this.geAlarmCount(clearState, userId);
        }
        HashMap<String, String> condition = new HashMap<String, String>();
        condition.put("alarmName", alarmName.trim());
        condition.put("clearStatus", String.valueOf(clearState.getValue()));
        if (userId >= 0L) {
            return this.faultUserDao.getFaultCount(Alarm.class, condition, true, userId);
        }
        return this.faultDao.getFaultCount(Alarm.class, condition, true);
    }

    public Integer getAlarmCount(FaultEnum.ClearState clearState, Map<String, String> condition, long userId) {
        logger.debug((Object)"getAlarmCount");
        condition.put("clearStatus", String.valueOf(clearState.getValue()));
        if (userId >= 0L) {
            return this.faultUserDao.getFaultCount(Alarm.class, condition, false, userId);
        }
        return this.faultDao.getFaultCount(Alarm.class, condition, false);
    }

    public int getAlarmCount() {
        logger.debug((Object)"getAlarmCount");
        return this.alarmDAO.getAlarmCount();
    }

    private Integer geAlarmCount(FaultEnum.ClearState clearState, long userId) {
        logger.debug((Object)"getAlarmCount");
        HashMap<String, String> condition = new HashMap<String, String>();
        condition.put("clearStatus", String.valueOf(clearState.getValue()));
        if (userId >= 0L) {
            return this.faultUserDao.getFaultCount(Alarm.class, condition, false, userId);
        }
        return this.faultDao.getFaultCount(Alarm.class, condition, false);
    }

    private Integer getFilterAlarmCount(FaultEnum.ClearState clearState, long userId) {
        logger.debug((Object)"getFilterAlarmCount");
        HashMap<String, String> condition = new HashMap<String, String>();
        condition.put("clearStatus", String.valueOf(clearState.getValue()));
        condition.put("isFilterForThirdDevice", String.valueOf(1));
        if (userId >= 0L) {
            return this.faultUserDao.getFaultCount(Alarm.class, condition, false, userId);
        }
        return this.faultDao.getFaultCount(Alarm.class, condition, false);
    }

    public BatchOperationResult affirmAlarms(List<BatchOperation> batchOps, String user, boolean isAffirm) {
        BatchOperationResult result = new BatchOperationResult();
        ArrayList<BatchOperation> resultList = new ArrayList<BatchOperation>();
        final ArrayList<LegoAlarm> alarmList = new ArrayList<LegoAlarm>();
        int fail = 0;
        int operCount = 0;
        if (batchOps != null) {
            logger.debug((Object)"affirmAlarms:batchOps is not null");
            operCount = batchOps.size();
            for (BatchOperation batchOperation : batchOps) {
                fail = this.affirmSingleAlarm(user, isAffirm, fail, batchOperation, alarmList);
                resultList.add(batchOperation);
            }
        }
        result.setResult(resultList);
        result.setFailCount(fail);
        result.setTotalCount(operCount);
        result.setSucceedCount(operCount - fail);
        FaultLauncher.getInstance().getFaultApi().flush();
        ExecutionService.submitTask(new Runnable(){

            @Override
            public void run() {
                if (!alarmList.isEmpty()) {
                    AffirmAlarmProcess.affirmAlarm(alarmList);
                }
            }
        });
        return result;
    }

    private int affirmSingleAlarm(String user, boolean isAffirm, int fail, BatchOperation batchOperation, List<LegoAlarm> alarmList) {
        try {
            Alarm alarm = this.alarmDAO.affirmAlarm((String)batchOperation.getExtTargetId(), isAffirm, System.currentTimeMillis(), user);
            LegoAlarm legoAlarm = FaultUtil.alarmToLegoAlarm(alarm);
            alarmList.add(legoAlarm);
            if (alarm != null) {
                logger.debug((Object)"affirmSingleAlarm:alarm is not null");
                if (alarm.getConfirmStatus() == 1) {
                    FaultMsgCenter.sendMessage(FaultMsgType.CONFIRM_ALARM, legoAlarm);
                } else {
                    FaultMsgCenter.sendMessage(FaultMsgType.UNCONFIRM_ALARM, legoAlarm);
                }
            }
        }
        catch (LegoCheckedException e) {
            ++fail;
            batchOperation.setErrorCode(e.getErrorCode());
        }
        catch (LegoUncheckedException e) {
            ++fail;
            batchOperation.setErrorCode(e.getErrorCode());
        }
        return fail;
    }

    public void affirmNorthAlarm(String alarmEntity, String user, long affirmTime, boolean isAffirm) {
        Alarm alarm = this.alarmDAO.affirmAlarm(alarmEntity, isAffirm, affirmTime, user);
        if (alarm != null) {
            logger.debug((Object)"affirmNorthAlarm:alarm is not null");
            LegoAlarm legoAlarm = FaultUtil.alarmToLegoAlarm(alarm);
            if (alarm.getConfirmStatus() == 1) {
                FaultMsgCenter.sendMessage(FaultMsgType.CONFIRM_ALARM, legoAlarm);
            } else {
                FaultMsgCenter.sendMessage(FaultMsgType.UNCONFIRM_ALARM, legoAlarm);
            }
        }
    }

    public BatchOperationResult manualClearAlarms(List<BatchOperation> batchOps, String user) {
        BatchOperationResult result = new BatchOperationResult();
        if (null == batchOps) {
            return result;
        }
        ArrayList<BatchOperation> resultList = new ArrayList<BatchOperation>();
        int fail = 0;
        for (BatchOperation batchOperation : batchOps) {
            try {
                Alarm alarm = this.alarmDAO.manualClearAlarm((String)batchOperation.getExtTargetId(), user, System.currentTimeMillis());
                if (alarm != null) {
                    logger.debug((Object)"manualClearAlarms:alarm is not null");
                    LegoAlarm legoAlarm = FaultUtil.alarmToLegoAlarm(alarm);
                    FaultMsgCenter.sendMessage(FaultMsgType.MANUCLEAR_ALARM, legoAlarm);
                }
            }
            catch (LegoCheckedException e) {
                ++fail;
                batchOperation.setErrorCode(e.getErrorCode());
            }
            catch (LegoUncheckedException e) {
                ++fail;
                batchOperation.setErrorCode(e.getErrorCode());
            }
            resultList.add(batchOperation);
        }
        result.setResult(resultList);
        result.setFailCount(fail);
        result.setTotalCount(batchOps.size());
        result.setSucceedCount(batchOps.size() - fail);
        FaultLauncher.getInstance().getFaultApi().flush();
        return result;
    }

    public void manualClearAlarms(String alarmEntity, String user) {
        Alarm alarm = this.alarmDAO.manualClearAlarm(alarmEntity, user, System.currentTimeMillis());
        if (alarm != null) {
            logger.debug((Object)"manualClearAlarms:alarm is not null");
            LegoAlarm legoAlarm = FaultUtil.alarmToLegoAlarm(alarm);
            FaultMsgCenter.sendMessage(FaultMsgType.MANUCLEAR_ALARM, legoAlarm);
        }
    }

    public void clearAlarms(String alarmEntity, String user, boolean isClearSysAlarm) {
        Alarm alarm = this.alarmDAO.clearOneAlarm(alarmEntity, user, System.currentTimeMillis(), isClearSysAlarm);
        if (alarm != null) {
            logger.debug((Object)"ClearAlarms:alarm is not null");
            LegoAlarm legoAlarm = FaultUtil.alarmToLegoAlarm(alarm);
            FaultMsgCenter.sendMessage(FaultMsgType.MANUCLEAR_ALARM, legoAlarm);
        }
    }

    public LegoAlarm getAlarm(String id) {
        Alarm alarm = this.alarmDAO.getAlarm(id);
        if (alarm == null) {
            logger.error((Object)"getAlarm:alarm is null");
            throw new LegoCheckedException(1540L);
        }
        return FaultUtil.alarmToLegoAlarm(alarm);
    }

    public LegoAlarm getUnclearedAlarm(String alarmId, Long moId) {
        LegoAlarm oldAlarm = null;
        List<Alarm> alarmList = null;
        try {
            alarmList = this.alarmDAO.getUnclearedAlarm(alarmId, moId);
        }
        catch (Exception ex) {
            ExceptionUtil.rethrowException((Throwable)ex, null, (long)1540L, null, (Log)logger);
        }
        if (alarmList == null) {
            logger.debug((Object)"getUnclearedAlarm:alarmList is null");
            throw new LegoCheckedException(1540L);
        }
        for (Alarm alarm : alarmList) {
            LegoAlarm legoAlarm = FaultUtil.alarmToLegoAlarm(alarm);
            if (legoAlarm == null || legoAlarm.getClearStatus() != FaultEnum.ClearState.UNCLEARED) continue;
            oldAlarm = legoAlarm;
            break;
        }
        return oldAlarm;
    }

    public List<LegoAlarm> getAlarmsByIds(List<String> ids, String orderField, boolean orderByAscend) {
        List<?> list = this.faultDao.getFaultsByIds(Alarm.class, ids, orderField, orderByAscend);
        ArrayList<LegoAlarm> resultList = new ArrayList<LegoAlarm>();
        if (list != null) {
            logger.debug((Object)"getAlarmsByIds:list is not null");
            for (int i = 0; i < list.size(); ++i) {
                LegoAlarm legoAlarm = FaultUtil.alarmToLegoAlarm((Alarm)list.get(i));
                resultList.add(legoAlarm);
            }
        }
        return resultList;
    }

    public Paging getAlarmDetails(String entity, String orderField, boolean orderByAscend, int startIndex, int pageSize, long userId) {
        logger.debug((Object)"getAlarmDetails");
        HashMap<String, String> condition = new HashMap<String, String>();
        condition.put("entity", entity);
        if ("".equals(orderField)) {
            orderField = "id";
            orderByAscend = false;
        }
        int count = 0;
        List<?> detailList = null;
        FaultQueryInfo queryInfo = new FaultQueryInfo();
        queryInfo.setFirstRowIndex(startIndex);
        queryInfo.setTotalRow(pageSize);
        queryInfo.setOrderByField(orderField);
        queryInfo.setOrderByAscend(orderByAscend);
        if (userId >= 0L) {
            detailList = this.faultUserDao.queryFaults(Annotation.class, condition, false, queryInfo, userId);
            count = this.faultUserDao.getFaultCount(Annotation.class, condition, false, userId);
        } else {
            detailList = this.faultDao.queryFaults(Annotation.class, condition, false, queryInfo);
            count = this.faultDao.getFaultCount(Annotation.class, condition, false);
        }
        Paging roPaging = new Paging();
        roPaging.setiCount(count);
        ArrayList<AlarmDetail> alarmDetailList = new ArrayList<AlarmDetail>();
        Alarm alarm = this.alarmDAO.getAlarm(entity);
        for (int i = 0; null != detailList && i < detailList.size(); ++i) {
            AlarmDetail alarmDetail = FaultUtil.annotationToAlarmDetail((Annotation)detailList.get(i));
            alarmDetail.setGmt(alarm.getGmt());
            alarmDetailList.add(alarmDetail);
        }
        roPaging.setData(alarmDetailList);
        return roPaging;
    }

    public int getAlarmDetailsCount(String entity) {
        return this.alarmDAO.getAnnotationByEntity(entity);
    }

    public boolean hasUnclearedAlarm(String entity) {
        return this.alarmDAO.hasUnclearedAlarm(entity);
    }

    public boolean deleteAlarmAndEventByMoID(List<Long> moIdList) {
        logger.debug((Object)"deleteAlarmAndEventByMoID");
        return this.faultDao.deleteAlarmAndEventByMoID(moIdList);
    }

    public boolean deleteAlarmAndEventBySorceId(List<String> sourceIdList) {
        logger.debug((Object)"deleteAlarmAndEventByUuid");
        return this.faultDao.deleteAlarmAndEventBySourceId(sourceIdList);
    }

    public boolean delMoRelationInfo(List<Long> moIdList) {
        logger.debug((Object)"delMoRelationInfo");
        return this.alarmDAO.delMoRelationInfo(moIdList);
    }

    public boolean deleteRedundanceInfo(List<Long> moIdList) {
        logger.debug((Object)"deleteRedundanceInfo");
        boolean result = this.alarmDAO.deleteRedundanceInfo(moIdList);
        this.faultDao.deleteRedundanceInfo(moIdList);
        return result;
    }

    public TopoObject getTopoObjectById(long moId) {
        logger.debug((Object)"getTopoObjectById");
        return this.alarmDAO.getTopoObjectById(moId);
    }

    public void setAlarmDAO(IAlarmDAO alarmDAO) {
        this.alarmDAO = alarmDAO;
    }

    public void setFaultDao(IFaultDao faultDao) {
        this.faultDao = faultDao;
    }

    public void setFaultUserDao(IFaultUserDao faultUserDao) {
        this.faultUserDao = faultUserDao;
    }

    public int manuClearAlarm(long aaid, String user, long clearTime) {
        try {
            Annotation annotation = this.alarmDAO.getAnnotation(aaid);
            if (annotation == null) {
                return 4;
            }
            Alarm alarm = this.alarmDAO.getAlarm(annotation.getEntity());
            if (alarm == null) {
                return 4;
            }
            if (annotation.getClearStatus() == 1) {
                return 3;
            }
            alarm.setClearStatus(1);
            alarm.setClearTime(clearTime);
            alarm.setClearUser(user);
            if ("0x000803220001".equalsIgnoreCase(alarm.getAlarmId()) || "0x000803220002".equalsIgnoreCase(alarm.getAlarmId()) || "0x000803220003".equalsIgnoreCase(alarm.getAlarmId()) || "0x000803220004".equalsIgnoreCase(alarm.getAlarmId()) || "0x000803220005".equalsIgnoreCase(alarm.getAlarmId())) {
                return 2;
            }
            if (FaultLauncher.getInstance().getFaultApi().clearAlertAndHistory(alarm, aaid)) {
                alarm.setSequence(aaid);
                LegoAlarm extendAlert = FaultUtil.alarmToLegoAlarm(alarm);
                FaultMsgCenter.sendMessage(FaultMsgType.MANUCLEAR_ALARM, extendAlert);
            }
        }
        catch (Exception e) {
            logger.error((Object)"manuClearAlarm error for UHM,error is %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            return 1;
        }
        return 0;
    }

    public List<Long> queryMaxAndMinSyncNo() {
        logger.debug((Object)"queryMaxAndMinSyncNo");
        ArrayList<Long> syncNoInfo = new ArrayList<Long>();
        syncNoInfo.add(this.faultDao.queryMaxOrMinSyncNo(true));
        syncNoInfo.add(this.faultDao.queryMaxOrMinSyncNo(false));
        return syncNoInfo;
    }

    public List<LegoAlarm> syncAlarmByAaid(long minSynNo, long maxSyncNo) {
        logger.debug((Object)"syncAlarmByAaid");
        List<Annotation> detailList = this.faultDao.syncAlarmByAaid(minSynNo, maxSyncNo);
        ArrayList<LegoAlarm> alarmList = new ArrayList<LegoAlarm>();
        if (null != detailList && !detailList.isEmpty()) {
            Map<String, Alarm> alertList = this.faultDao.queryAlarms(detailList);
            for (Annotation detail : detailList) {
                LegoAlarm alarm = FaultUtil.alarmToLegoAlarm(alertList.get(detail.getEntity()));
                alarm.setNmsSequence(detail.getId());
                alarmList.add(alarm);
            }
        }
        return alarmList;
    }

    public boolean updateFault(TopoObject topo) {
        logger.debug((Object)"updateFault");
        return this.faultDao.updateFaultMoName(String.valueOf(topo.getMoId()), topo.getName());
    }

    public boolean updateChildFault(String oldName, String newName, String moId) {
        logger.debug((Object)"updateChildFault");
        return this.faultDao.updateChildFault(oldName, newName, moId);
    }

    public int getTrapPort() {
        logger.debug((Object)"getTrapPort");
        return FaultUtil.getTrapPort();
    }

    public boolean isLinkAlarmRes() {
        logger.debug((Object)"isLinkAlarmRes");
        return LinkResServiceContainer.isShowLinkRes();
    }

    public Map<String, Integer> getAlarmCountGroupByMO(List<String> moUuidList) {
        HashMap<String, Integer> moAlarmCountMap = new HashMap<String, Integer>();
        if (moUuidList != null && !moUuidList.isEmpty()) {
            for (String uuid : moUuidList) {
                if (uuid != null && !uuid.isEmpty()) {
                    int alarmCount = this.alarmDAO.getAlarmCountByMoUuid(uuid);
                    moAlarmCountMap.put(uuid, alarmCount);
                    continue;
                }
                logger.warn((Object)"uuid is null or empty.", 653110170222592L);
            }
        } else {
            logger.warn((Object)"moList is null or empty.", 653110170222592L);
        }
        return moAlarmCountMap;
    }

    public String getMostSeriousAlarmAndCount(long moId) {
        logger.debug((Object)"getMostSeriousAlarmAndCount");
        return this.alarmDAO.getMostSeriousAlarmAndCount(moId);
    }

    public LegoAlarm getAlarmFromCache(String entity) {
        Alarm alarm = null;
        try {
            alarm = FaultLauncher.getInstance().getFaultApi().getAlarmFromCache(entity);
        }
        catch (Exception e) {
            logger.error((Object)"Get alarm failure:error: %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
        }
        if (alarm == null) {
            return null;
        }
        LegoAlarm legoAlarm = FaultUtil.alarmToLegoAlarm(alarm);
        return legoAlarm;
    }

    public boolean checkAlarmAndUser(String type, long userid, String[] alarmEntity) {
        if (userid == -1L) {
            return true;
        }
        return this.faultUserDao.queryAlarmMO(type, userid, alarmEntity);
    }

    private boolean stringisNull(String str) {
        logger.debug((Object)"stringisNull");
        return str == null || str.trim().length() <= 0;
    }

    public void dealWithThirdAlarm(LegoAlarm legoAlarm, int alarmType) {
        logger.debug((Object)String.format(Locale.ENGLISH, "Start dealWithThirdAlarm, alarmId: %s, alarmType: %s.", legoAlarm.getAlarmId(), alarmType));
        try {
            ManagedObject legoMo;
            FaultApplication faultApp;
            String alarmId = legoAlarm.getAlarmId();
            if (CURRENT_ALARM_DUMP_IDS.contains(alarmId)) {
                StorageFactory storageFactory = new StorageFactory();
                if (!"0x0".equals(alarmId)) {
                    storageFactory.setLangValue("0");
                }
                storageFactory.dateStorage("current_alarm_bk");
                return;
            }
            IFaultGenerateService alarmService1 = (IFaultGenerateService)ServiceContext.getInstance().lookup("fault/faultGenerateService");
            if (legoAlarm.getMoId() == -1L) {
                faultApp = (FaultApplication)super.getContainer();
                legoMo = faultApp.getLegoSystem();
                legoAlarm.setMoId(legoMo.getMoId().longValue());
            }
            if (VerifyUtil.isEmpty((String)legoAlarm.getMoUuid())) {
                faultApp = (FaultApplication)super.getContainer();
                legoMo = faultApp.getLegoSystem();
                legoAlarm.setMoUuid(legoMo.getUuid());
            }
            if (alarmType == 1) {
                alarmService1.generateAlarm(legoAlarm);
            } else if (alarmType == 2) {
                Date currentTime = new Date();
                legoAlarm.setClearTime(currentTime.getTime());
                alarmService1.generateRestoreAlarm(legoAlarm);
            } else {
                logger.error((Object)"not supported alarm type: %s.", (long)alarmType);
            }
        }
        catch (Exception e) {
            logger.error((Object)"dealWithThirdAlarm failed: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException("dealWithThirdAlarm failed: " + ExceptionUtil.getErrorMessage((Throwable)e));
        }
    }

    public void updateSnmpV3Param(SnmpV3Param snmpV3Param) {
        String oldUserName = "";
        if (snmpV3Param != null) {
            String newUserName = snmpV3Param.getUserName();
            String hql = "from SnmpV3Param param where param.discoveredDeviceUuid = ?";
            List<?> list = this.alarmDAO.findByHql(hql, new Object[]{snmpV3Param.getDiscoveredDeviceUuid()});
            SnmpV3Param param = null;
            if (list != null && !list.isEmpty()) {
                param = (SnmpV3Param)list.get(0);
                snmpV3Param.setSnmpV3ParamId(param.getSnmpV3ParamId());
                if (!this.stringisNull(param.getEngineId())) {
                    snmpV3Param.setEngineId(param.getEngineId());
                } else if (this.stringisNull(snmpV3Param.getEngineId())) {
                    String enginedId = Snmpv3Util.discoveryEngineId(snmpV3Param);
                    snmpV3Param.setEngineId(enginedId);
                }
                oldUserName = param.getUserName();
                this.alarmDAO.update(snmpV3Param);
                logger.warn((Object)("there is no related v3 data in DB, the new v3 data is : " + snmpV3Param), 653110170222592L);
            } else {
                logger.info((Object)("will insert V3 data, v3 data is : " + snmpV3Param), 653110170222592L);
                this.alarmDAO.save(snmpV3Param);
            }
            try {
                ServiceContext context = ServiceContext.getInstance();
                ISnmpV3Service snmpV3Service = (ISnmpV3Service)context.lookup("fault/snmpV3Service");
                this.processSnmpParam(snmpV3Service, snmpV3Param, oldUserName, newUserName);
            }
            catch (Exception e) {
                logger.error((Object)("get remote fault snmpv3service failure" + ExceptionUtil.getErrorMessage((Throwable)e)), 653110170222592L);
            }
        }
    }

    private void processSnmpParam(ISnmpV3Service snmpV3Service, SnmpV3Param snmpV3Param, String oldUserName, String newUserName) {
        if (null == snmpV3Service) {
            logger.error((Object)"get remote fault snmpv3service failue", 653110170222592L);
        } else {
            if (!this.stringisNull(oldUserName)) {
                snmpV3Param.setUserName(oldUserName);
            }
            snmpV3Service.removeSnmpV3Param(snmpV3Param);
            snmpV3Param.setUserName(newUserName);
            snmpV3Service.notifySnmpV3Param(snmpV3Param);
        }
    }

    public void removeSnmpV3Param(SnmpV3Param snmpV3Param) {
        if (snmpV3Param != null) {
            String hql = "from SnmpV3Param param where param.discoveredDeviceUuid = ?";
            List<?> list = this.alarmDAO.findByHql(hql, new Object[]{snmpV3Param.getDiscoveredDeviceUuid()});
            if (list != null && !list.isEmpty()) {
                SnmpV3Param param = (SnmpV3Param)list.get(0);
                snmpV3Param.setSnmpV3ParamId(param.getSnmpV3ParamId());
                if (!this.stringisNull(param.getEngineId())) {
                    snmpV3Param.setEngineId(param.getEngineId());
                } else if (this.stringisNull(snmpV3Param.getEngineId())) {
                    String enginedId = Snmpv3Util.discoveryEngineId(snmpV3Param);
                    snmpV3Param.setEngineId(enginedId);
                }
                this.alarmDAO.remove(snmpV3Param);
                logger.warn((Object)("there is no related v3 data in DB, the new v3 data is : " + snmpV3Param), 653110170222592L);
            }
            try {
                ServiceContext context = ServiceContext.getInstance();
                ISnmpV3Service snmpV3Service = (ISnmpV3Service)context.lookup("fault/snmpV3Service");
                if (null == snmpV3Service) {
                    logger.error((Object)"get remote fault snmpv3service failue", 653110170222592L);
                } else {
                    snmpV3Service.removeSnmpV3Param(snmpV3Param);
                }
            }
            catch (Exception e) {
                logger.error((Object)("get remote fault snmpv3service failure" + ExceptionUtil.getErrorMessage((Throwable)e)), 653110170222592L);
            }
        }
    }

    public List<SnmpV3Param> getSnmpV3ParamList() {
        return this.alarmDAO.getSnmpV3ParamList();
    }

    public List<LegoAlarm> getUnclearedAlarms(String alarmId, long moId) {
        List<Alarm> unclearedAlarms = this.alarmDAO.getUnclearedAlarm(alarmId, moId);
        return unclearedAlarms.stream().map(FaultUtil::alarmToLegoAlarm).filter(legoAlarm -> legoAlarm.getClearStatus() == FaultEnum.ClearState.UNCLEARED).collect(Collectors.toList());
    }
}

