/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.oracle.hostagent.action;

import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.drm.host.agent.action.AgentRestAction;
import com.huawei.ism.drm.oracle.hostagent.action.OracleActionApi;
import com.huawei.ism.drm.oracle.hostagent.action.OracleParam;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.util.HashMap;

public class AgentOracleActionApi
extends AgentRestAction
implements OracleActionApi {
    public AgentOracleActionApi(NeMgrProtocolExtend extend, String devSn) {
        super(extend, devSn);
    }

    @Override
    public String queryDatabases() {
        return this.get("/agent/oracle/databases", null);
    }

    @Override
    public String queryLunList(OracleParam oracleParam) {
        this.buildHeaders(oracleParam.getExtendParam());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("instName", oracleParam.getInstanceName());
        params.put("dbName", oracleParam.getDatabaseName());
        params.put("asmInstName", oracleParam.getAsmInstName());
        params.put("isArchive", oracleParam.getIsArchieve());
        params.put("oracleHome", oracleParam.getOracleHome());
        return this.get("/agent/oracle/databases/action/getLuns?instName={instName}&dbName={dbName}&asmInstName={asmInstName}&isArchive={isArchive}&oracleHome={oracleHome}", params);
    }

    @Override
    public void startDatabase(OracleParam oracleParam) {
        this.buildHeaders(oracleParam.getExtendParam());
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("instName", oracleParam.getInstanceName());
        params.put("dbName", oracleParam.getDatabaseName());
        params.put("version", oracleParam.getVersion());
        params.put("isASM", NumberUtil.convertToInteger((Object)oracleParam.getIsASM()));
        params.put("asmInstName", oracleParam.getAsmInstName());
        params.put("asmDiskGroups", oracleParam.getAsmDiskGroups());
        params.put("oracleHome", oracleParam.getOracleHome());
        params.put("isIncludeArchLog", NumberUtil.convertToInteger((Object)oracleParam.getIsIncludeArchLog()));
        this.put("/agent/oracle/databases/action/start", JSONObject.fromObject(params).toString(), null);
    }

    @Override
    public void stopDatabase(OracleParam oracleParam) {
        this.buildHeaders(oracleParam.getExtendParam());
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("instName", oracleParam.getInstanceName());
        params.put("dbName", oracleParam.getDatabaseName());
        params.put("version", oracleParam.getVersion());
        params.put("isASM", NumberUtil.convertToInteger((Object)oracleParam.getIsASM()));
        params.put("asmInstName", oracleParam.getAsmInstName());
        params.put("asmDiskGroups", oracleParam.getAsmDiskGroups());
        params.put("oracleHome", oracleParam.getOracleHome());
        this.put("/agent/oracle/databases/action/stop", JSONObject.fromObject(params).toString(), null);
    }

    @Override
    public void testConnection(OracleParam oracleParam) {
        this.buildHeaders(oracleParam.getExtendParam());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("instName", oracleParam.getInstanceName());
        params.put("dbName", oracleParam.getDatabaseName());
        params.put("oracleHome", oracleParam.getOracleHome());
        this.put("/agent/oracle/databases/action/testConnection", JSONObject.fromObject(params).toString(), null);
    }

    @Override
    public String queryDatabaseAuth(OracleParam oracleParam) {
        this.buildHeaders(oracleParam.getExtendParam());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("instName", oracleParam.getInstanceName());
        params.put("oracleHome", oracleParam.getOracleHome());
        return this.get("/agent/oracle/databases?instName={instName}&oracleHome={oracleHome}", params);
    }

    @Override
    public String queryPlugDatabase(OracleParam oracleParam) {
        this.buildHeaders(oracleParam.getExtendParam());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("pdbName", oracleParam.getPdbName());
        params.put("instName", oracleParam.getInstanceName());
        params.put("oracleHome", oracleParam.getOracleHome());
        return this.get("/agent/oracle/pdbs?instName={instName}&oracleHome={oracleHome}&pdbName={pdbName}", params);
    }

    @Override
    public String queryAdgStandby(OracleParam oracleParam) {
        return "";
    }

    @Override
    public void freeze(OracleParam oracleParam) {
        this.buildHeaders(oracleParam.getExtendParam());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("instName", oracleParam.getInstanceName());
        params.put("dbName", oracleParam.getDatabaseName());
        params.put("oracleHome", oracleParam.getOracleHome());
        this.put("/agent/oracle/databases/action/freeze", JSONObject.fromObject(params).toString(), null);
    }

    @Override
    public void thaw(OracleParam oracleParam) {
        this.buildHeaders(oracleParam.getExtendParam());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("instName", oracleParam.getInstanceName());
        params.put("dbName", oracleParam.getDatabaseName());
        params.put("oracleHome", oracleParam.getOracleHome());
        this.put("/agent/oracle/databases/action/unfreeze", JSONObject.fromObject(params).toString(), null);
    }

    @Override
    public void forcedArchive(OracleParam oracleParam) {
        this.buildHeaders(oracleParam.getExtendParam());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("instName", oracleParam.getInstanceName());
        params.put("dbName", oracleParam.getDatabaseName());
        params.put("oracleHome", oracleParam.getOracleHome());
        this.put("/agent/oracle/databases/action/archivelog", JSONObject.fromObject(params).toString(), null);
    }

    @Override
    public void checkThreshold(OracleParam oracleParam) {
        this.buildHeaders(oracleParam.getExtendParam());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("instName", oracleParam.getInstanceName());
        params.put("asmInstName", oracleParam.getAsmInstName());
        params.put("threshold", oracleParam.getCapThreshold());
        params.put("oracleHome", oracleParam.getOracleHome());
        this.put("/agent/oracle/databases/action/checkThreshold", JSONObject.fromObject(params).toString(), null);
    }

    @Override
    public String inspectAdgStatus(OracleParam oracleParam) {
        return "";
    }

    @Override
    public void startAsmInstance(OracleParam oracleParam) {
        this.buildHeaders(oracleParam.getExtendParam());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("instName", oracleParam.getInstanceName());
        params.put("asmDiskGroups", oracleParam.getAsmDiskGroups());
        this.put("/agent/oracle/action/startAsmInstance", JSONObject.fromObject(params).toString(), null);
    }

    @Override
    public void stopAsmInstance(OracleParam oracleParam) {
        this.buildHeaders(oracleParam.getExtendParam());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("instName", oracleParam.getInstanceName());
        this.put("/agent/oracle/action/stopAsmInstance", JSONObject.fromObject(params).toString(), null);
    }

    @Override
    public void startPDB(OracleParam oracleParam) {
        this.buildHeaders(oracleParam.getExtendParam());
        HashMap<String, String> uriVariMap = new HashMap<String, String>();
        uriVariMap.put("instName", oracleParam.getInstanceName());
        uriVariMap.put("oracleHome", oracleParam.getOracleHome());
        uriVariMap.put("pdbName", oracleParam.getPdbName());
        this.put("/agent/oracle/pdbs/action/start", JSONObject.fromObject(uriVariMap).toString(), null);
    }

    @Override
    public void switchoverDatabase(OracleParam oracleParam) {
        throw new LegoCheckedException("Not support.");
    }

    @Override
    public void replaceUdevRule(OracleParam oracleParam) {
        throw new LegoCheckedException("Not support.");
    }

    @Override
    public void adgRecovery(OracleParam oracleParam) {
        throw new LegoCheckedException("Not support.");
    }
}

