/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.oracle.msg;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.AlarmReporter;
import com.huawei.ism.drm.common.sdk.model.DRMObject;
import com.huawei.ism.drm.common.sdk.model.MessageEvent;
import com.huawei.ism.drm.common.sdk.service.IObjectObserver;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.Collection;
import java.util.List;

public class DeletePgMsgObserverImpl
implements IObjectObserver {
    private static final Log LOGGER = LogFactory.getInstance(DeletePgMsgObserverImpl.class);

    public void before(MessageEvent event) {
    }

    public void after(MessageEvent event) {
        List objList = event.getObjectList();
        if (VerifyUtil.isEmpty((Collection)objList)) {
            return;
        }
        if (2 != event.getMessageType()) {
            return;
        }
        for (DRMObject obj : objList) {
            if (!(obj instanceof ProtectGroup)) continue;
            this.restoreForcedArchiveAlarm((ProtectGroup)obj);
        }
    }

    public String getObserverType() {
        return ProtectGroup.class.getName();
    }

    private void restoreForcedArchiveAlarm(ProtectGroup protectGroup) {
        String uuid = protectGroup.getUuid();
        if (VerifyUtil.isEmpty((Collection)protectGroup.getPolist())) {
            LOGGER.error((Object)("restore forced archive alarm fail,polist is null. pgid:" + uuid + ",pgName:" + protectGroup.getName()), 90160758786989L);
            return;
        }
        for (ProtectObject po : protectGroup.getPolist()) {
            try {
                AlarmReporter.restoreAlarm((long)52625437L, (String[])new String[]{uuid + "_" + po.getMoUuid()});
                LOGGER.info((Object)("delete protect group and clear forced archive alarm. pgid:" + uuid + ",pgName:" + protectGroup.getName() + ",poMoUuid:" + po.getMoUuid() + ",poName:" + po.getName()), 90160758786988L);
            }
            catch (Exception e) {
                LOGGER.error((Object)("delete pg and clear forced archive alarm exception. pgid:" + uuid + ",pgName:" + protectGroup.getName() + ",poMoUuid:" + po.getMoUuid() + ",poName:" + po.getName() + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
            }
        }
    }
}

