/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.oracle.msg;

import com.huawei.ism.cbb.base.sdk.constant.CommonConstant;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.AlarmReporter;
import com.huawei.ism.drm.common.sdk.model.DRMObject;
import com.huawei.ism.drm.common.sdk.model.MessageEvent;
import com.huawei.ism.drm.common.sdk.service.IObjectObserver;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.lego.cbb.backtask.sdk.model.TaskResultItem;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RemovePoMsgObserverImpl
implements IObjectObserver {
    private static final Log LOGGER = LogFactory.getInstance(RemovePoMsgObserverImpl.class);
    private final Map<String, Set<ProtectObject>> poMap = new HashMap<String, Set<ProtectObject>>();

    public void before(MessageEvent event) {
        List objectList = event.getObjectList();
        if (VerifyUtil.isEmpty((Collection)objectList)) {
            return;
        }
        if (4 != event.getMessageType()) {
            return;
        }
        for (DRMObject object : objectList) {
            if (!(object instanceof ProtectGroup)) continue;
            try {
                this.poMap.remove(object.getUuid());
                IProtectGroupService protectGroupService = (IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class);
                ProtectGroup pg = protectGroupService.getProtectGroupBasicInfo(object.getUuid(), true);
                this.poMap.put(object.getUuid(), pg.getPolist());
            }
            catch (Exception e) {
                LOGGER.error((Object)("remove po before exception. pgid:" + object.getUuid() + ",pgName:" + object.getName() + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
            }
        }
    }

    public void after(MessageEvent event) {
        List tempList = event.getObjectList();
        if (VerifyUtil.isEmpty((Collection)tempList)) {
            return;
        }
        if (4 != event.getMessageType()) {
            return;
        }
        Map<String, TaskResultItem> resultItemMap = this.getResultItemMap(event);
        for (DRMObject object : tempList) {
            if (!(object instanceof ProtectGroup)) continue;
            this.restoreForcedArchiveAlarm((ProtectGroup)object, resultItemMap);
        }
    }

    private Map<String, TaskResultItem> getResultItemMap(MessageEvent event) {
        if (VerifyUtil.isEmpty((Map)event.getMessageMap())) {
            return new HashMap<String, TaskResultItem>();
        }
        Set resultItemSet = (Set)event.getMessageMap().get("TASK_RESULT_ITEM_LIST_KEY");
        if (VerifyUtil.isEmpty((Collection)resultItemSet)) {
            return new HashMap<String, TaskResultItem>();
        }
        HashMap<String, TaskResultItem> resultItemMap = new HashMap<String, TaskResultItem>();
        for (TaskResultItem item : resultItemSet) {
            if (VerifyUtil.isEmpty((String)item.getResId())) continue;
            resultItemMap.put(item.getResId(), item);
        }
        return resultItemMap;
    }

    public String getObserverType() {
        return ProtectGroup.class.getName();
    }

    private void restoreForcedArchiveAlarm(ProtectGroup protectGroup, Map<String, TaskResultItem> resultItemMap) {
        Set<ProtectObject> pos;
        String uuid = protectGroup.getUuid();
        try {
            pos = this.getremovePos(protectGroup);
        }
        catch (Exception e) {
            LOGGER.error((Object)("remove po and clear forced archive alarm exception. pgid:" + uuid + ",pgName:" + protectGroup.getName() + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
            return;
        }
        if (VerifyUtil.isEmpty(pos)) {
            LOGGER.info((Object)("remove po and restore forced archive alarm fail,pos is null. pgid:" + uuid + ",pgName:" + protectGroup.getName()), 90160758786989L);
            return;
        }
        for (ProtectObject po : pos) {
            try {
                TaskResultItem item = resultItemMap.get(po.getUuid());
                if (VerifyUtil.isEmpty((Object)item) || CommonConstant.BACKTASK_RESULT_FAIL == item.getResult()) {
                    LOGGER.error((Object)("the remove po task execute failed:poName=" + po.getName()));
                    continue;
                }
                AlarmReporter.restoreAlarm((long)52625437L, (String[])new String[]{uuid + "_" + po.getMoUuid()});
                LOGGER.info((Object)("remove po and clear forced archive alarm. pgid:" + uuid + ",pgName:" + protectGroup.getName() + ",poMoUuid:" + po.getMoUuid() + ",poName:" + po.getName()), 90160758786988L);
            }
            catch (Exception e) {
                LOGGER.error((Object)("remove po and clear forced archive alarm exception. pgid:" + uuid + ",pgName:" + protectGroup.getName() + ",poMoUuid:" + po.getMoUuid() + ",poName:" + po.getName() + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
            }
        }
    }

    private Set<ProtectObject> getremovePos(ProtectGroup protectGroup) {
        Set<ProtectObject> allPos = this.poMap.remove(protectGroup.getUuid());
        if (VerifyUtil.isEmpty(allPos)) {
            return new HashSet<ProtectObject>();
        }
        HashSet<ProtectObject> existPos = new HashSet<ProtectObject>();
        for (ProtectObject protectObject : allPos) {
            for (ProtectObject po : protectGroup.getPolist()) {
                if (!protectObject.getUuid().equals(po.getUuid())) continue;
                existPos.add(protectObject);
            }
        }
        allPos.removeAll(existPos);
        return allPos;
    }
}

