/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.oracle.poller;

import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.cbb.discover.sdk.service.INeMgrProtocolExtendService;
import com.huawei.ism.drm.base.util.AlarmReporter;
import com.huawei.ism.drm.host.util.DrHostUtil;
import com.huawei.ism.drm.oracle.hostagent.action.OracleAction;
import com.huawei.ism.drm.oracle.recovery.util.OracleAppUtil;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.Callable;

public class GetAndSaveRpoTask
implements Callable<Integer> {
    private static final Log LOGGER = LogFactory.getInstance(GetAndSaveRpoTask.class);
    private static final long ALARM_ID_DECIMAL = 52625553L;
    private final ProtectGroup protectGroup;
    private final Schedule schedule;
    private final INeMgrProtocolExtendService neMgr;

    public GetAndSaveRpoTask(ProtectGroup protectGroup, Schedule schedule, INeMgrProtocolExtendService neMgr) {
        this.protectGroup = protectGroup;
        this.schedule = schedule;
        this.neMgr = neMgr;
    }

    @Override
    public Integer call() {
        ProtectGroup pg = ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).getProtectGroupByID(this.protectGroup.getUuid(), false);
        JSONArray rpoJsonArray = new JSONArray();
        for (ProtectObject po : pg.getPolist()) {
            this.getAdgRpoByPo(po, this.schedule, rpoJsonArray);
        }
        HashMap<String, String> rpoResults = new HashMap<String, String>();
        rpoResults.put("RPO_ITEM_KEY", rpoJsonArray.toString());
        ProtectGroupUtil.saveRPOAndRTOResult((ProtectGroup)pg, rpoResults);
        return 0;
    }

    private void getAdgRpoByPo(ProtectObject po, Schedule schedule, JSONArray rpoJsonArray) {
        ArrayList<ProtectObject> tmpPoList = new ArrayList<ProtectObject>();
        OracleAppUtil.getDisasterHostTmpPoList(tmpPoList, po);
        long rpo = -1L;
        for (ProtectObject tmpPo : tmpPoList) {
            String sn = (String)tmpPo.getProps().get("hostSn");
            NeMgrProtocolExtend neExtend = DrHostUtil.getNeMgrProtocolExtend((INeMgrProtocolExtendService)this.neMgr, (String)sn);
            OracleAction action = new OracleAction(neExtend, (String)neExtend.getExtendParams().get("mac_address"));
            try {
                rpo = action.queryAdgRpo(tmpPo.getProps());
                break;
            }
            catch (LegoCheckedException e) {
                LOGGER.error((Object)"Query rpo failed, hostSn:%s, errmsg:%s", new Object[]{sn, ExceptionUtil.getErrorMessage((Throwable)e)});
            }
        }
        this.calculateRpoAndSendAlarm(po, schedule, rpo, rpoJsonArray);
    }

    private void calculateRpoAndSendAlarm(ProtectObject po, Schedule schedule, long rpo, JSONArray rpoJsonArray) {
        long expectedRPO = schedule.getExpectedRPO() == null ? -1L : schedule.getExpectedRPO().getExpectedRPOValue();
        this.updateRpoJsonArray(po, expectedRPO, rpo, rpoJsonArray, schedule.getProtectedType());
        String[] params = new String[]{po.getUuid(), po.getUuid(), po.getProtectGroup().getName(), po.getName()};
        if (rpo > expectedRPO || rpo == -1L) {
            LOGGER.debug((Object)"Oracle ADG RPO Requirement Is Not Met.");
            AlarmReporter.sendAlarmForNoRepeat((long)52625553L, (String)(po.getProtectGroup().getUuid() + "_" + po.getUuid()), (String)FaultEnum.AlarmResourceType.DRMOBJECT.getValue(), (FaultEnum.AlarmSeverity)FaultEnum.AlarmSeverity.MAJOR, (String[])params);
        } else {
            AlarmReporter.restoreAlarm((String)"0x3230091", (String[])new String[]{po.getUuid()});
        }
    }

    private void updateRpoJsonArray(ProtectObject po, long expectedRPOValue, long rpo, JSONArray rpoJsonArray, int protectedType) {
        JSONObject rpoJsonObject = new JSONObject();
        rpoJsonObject.put((Object)"configuredRPO", (Object)expectedRPOValue);
        rpoJsonObject.put((Object)"actualRPO", (Object)rpo);
        rpoJsonObject.put((Object)"poName", (Object)po.getName());
        rpoJsonObject.put((Object)"siteId", (Object)po.getProtectGroup().getProductSiteId());
        rpoJsonObject.put((Object)"protectedType", (Object)protectedType);
        rpoJsonArray.add((Object)rpoJsonObject);
    }
}

