/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.oracle.poller;

import com.google.common.collect.ImmutableList;
import com.huawei.ism.cbb.base.poll.IPoller;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.oracle.recovery.util.OracleAppUtil;
import com.huawei.ism.drm.protection.framework.service.group.refinement.QueryProtectGroupRefineService;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Collection;
import java.util.List;

public class OracleAllFlashAdgCheckPoller
implements IPoller {
    private static final Log LOGGER = LogFactory.getInstance(OracleAllFlashAdgCheckPoller.class);
    private static final Long ADMIN_USER_ID = 1L;
    private static final List<Integer> NORMAL_STATUS_LIST = ImmutableList.of((Object)DrmEnumDefine.ProtectGroupStatus.NORMAL.getStatus(), (Object)DrmEnumDefine.ProtectGroupStatus.INVALID.getStatus());
    private final String uuid;
    private final String pollerType;

    public OracleAllFlashAdgCheckPoller(String uuid, String pollerType) {
        this.uuid = uuid;
        this.pollerType = pollerType;
    }

    public String getPollerID() {
        return this.uuid;
    }

    public String getPollerType() {
        return this.pollerType;
    }

    public void run() {
        LOGGER.info((Object)"Start check adg status.");
        List protectGroups = QueryProtectGroupRefineService.getInstance().queryProtectGroups(ADMIN_USER_ID);
        if (VerifyUtil.isEmpty((Collection)protectGroups)) {
            return;
        }
        protectGroups.removeIf(protectGroup -> protectGroup.getTemplate().getType() != 47);
        if (VerifyUtil.isEmpty((Collection)protectGroups)) {
            LOGGER.debug((Object)"ProtectGroups are empty.");
            return;
        }
        for (ProtectGroup protectGroup2 : protectGroups) {
            if (!NORMAL_STATUS_LIST.contains(protectGroup2.getStatus())) {
                return;
            }
            OracleAppUtil.checkAdgStatus(protectGroup2);
        }
    }
}

