/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.oracle.protect.action;

import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.operation.sdk.model.OperationResult;
import com.huawei.ism.drm.protection.action.model.ActionContext;
import com.huawei.ism.drm.protection.framework.engine.action.CreateSanSnapshotAction;
import com.huawei.ism.drm.protection.framework.engine.bean.SnapShotAssociateProtectObject;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.RemoteStorageReplica;
import com.huawei.ism.drm.storage.manager.proxy.StorageSnapshotManagerProxy;
import com.huawei.ism.drm.storage.sdk.service.IStorageService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.NumberUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class OracleCreateSanSnapshotAction
extends CreateSanSnapshotAction {
    private static final Log LOGGER = LogFactory.getInstance(OracleCreateSanSnapshotAction.class);

    protected boolean activeSnapshot(ActionContext context) {
        Object obj = context.getObject("PO_GROUP_MAP");
        SnapShotAssociateProtectObject apo = (SnapShotAssociateProtectObject)obj;
        ProtectGroup protectGroup = (ProtectGroup)context.getObject("PG_ENTITY");
        boolean flag = false;
        try {
            OperationResult optResult;
            List<String> archieveLogLunIds = this.getArchieveLogLunId(context, apo, protectGroup.getPolist());
            List<String> snapshotIds = this.getSnapshotIds(apo, archieveLogLunIds);
            if (VerifyUtil.isEmpty(snapshotIds)) {
                LOGGER.error((Object)("snap shot id is null,archieveLogLunId=" + archieveLogLunIds), 90160758786989L);
            }
            if (null == (optResult = StorageSnapshotManagerProxy.getInstance().getStorageSnapshotMgrByDevId(apo.getTgtStorageProviderSN()).activeSnapshot(apo.getTgtStorageProviderSN(), snapshotIds)) || !optResult.isSuccess()) {
                String errorCode = null != optResult ? optResult.getErrorCode() : String.valueOf(1073948689L);
                this.updatePgReplicaUnactive(context);
                LOGGER.error((Object)("Active Snapshot(" + snapshotIds + ") failed.the error code is " + errorCode), 90160758786989L);
                this.setDetail("lego.err.1073948689");
                return flag;
            }
            LOGGER.debug((Object)"OracleCreateSanSnapshotAction end to execute!", 90160758786988L);
            flag = true;
            return flag;
        }
        catch (LegoCheckedException e) {
            this.setDetail(e.getErrorMessageKey());
            this.setDetailParams(this.constructParams(e.getParameters()));
            LOGGER.error((Object)"Execute Snapshot failed! ", (Throwable)e);
            return flag;
        }
        catch (Exception e) {
            this.setDetail("lego.err.1073948689");
            LOGGER.error((Object)("Execute Snapshot failed! " + ExceptionUtil.getErrorMessage((Throwable)e)), 1073948689L);
            return flag;
        }
    }

    protected abstract boolean isActiveSnapshot(List<String> var1, String var2);

    private List<String> getArchieveLogLunId(ActionContext context, SnapShotAssociateProtectObject apo, Set<ProtectObject> poList) {
        if (VerifyUtil.isEmpty(poList)) {
            LOGGER.info((Object)("poList is null,devSn=" + apo.getSrcStorageProviderSN()), 90160758786989L);
            return new ArrayList<String>();
        }
        HashSet<String> archieveLogLunWwn = new HashSet<String>();
        for (ProtectObject po : poList) {
            Set storageInfoSet = po.getUsedStorageResourceSet();
            for (ProtectObjectStorageInfo storageInfo : storageInfoSet) {
                if (null == storageInfo.getArchiveLog() || storageInfo.getArchiveLog() != 1) continue;
                archieveLogLunWwn.add(storageInfo.getLunWWN());
            }
        }
        return this.getArchieveLogLunId(context, apo.getSrcStorageProviderSN(), archieveLogLunWwn);
    }

    private List<String> getArchieveLogLunId(ActionContext context, String deviceSn, Set<String> archieveLogLunWwn) {
        ArrayList<String> archieveLogLunId = new ArrayList<String>();
        if (archieveLogLunWwn.isEmpty()) {
            LOGGER.debug((Object)"archieveLogLunWwn is null.", 90160758786989L);
            return archieveLogLunId;
        }
        Set<String> lunIds = this.getLunIdByWwnFromReplica(context, archieveLogLunWwn);
        List resources = lunIds.isEmpty() ? ((IStorageService)ServiceLocator.getInstance().getService(IStorageService.class)).getStorageResourceByWwn(archieveLogLunWwn.toArray(new String[archieveLogLunWwn.size()])) : ((IStorageService)ServiceLocator.getInstance().getService(IStorageService.class)).getStorageResources(deviceSn, new ArrayList<String>(lunIds), DrmEnumDefine.ResourceTypeE.LUN);
        if (VerifyUtil.isEmpty((Collection)resources)) {
            LOGGER.info((Object)("resources is null,archieveLogLunWwn=" + archieveLogLunWwn), 90160758786989L);
            return archieveLogLunId;
        }
        for (StorageResource storageResource : resources) {
            String devSn = storageResource.getDevSn();
            if (!devSn.equals(deviceSn)) {
                LOGGER.debug((Object)("getArchieveLogLunId is null,lunId=" + storageResource.getResourceId() + ",devSn=" + deviceSn + ",storageResource.getDevSn()=" + storageResource.getDevSn()), 90160758786989L);
                continue;
            }
            archieveLogLunId.add(storageResource.getResourceId());
        }
        return archieveLogLunId;
    }

    private Set<String> getLunIdByWwnFromReplica(ActionContext context, Set<String> archieveLogLunWwn) {
        HashSet<String> lunIds = new HashSet<String>();
        ProtectGroup protectGroup = (ProtectGroup)context.getObject("PG_ENTITY");
        if (VerifyUtil.isEmpty((Collection)protectGroup.getReplicaList())) {
            return lunIds;
        }
        ProtectGroupReplica remoteReplica = null;
        for (ProtectGroupReplica replica : protectGroup.getReplicaList()) {
            if (ProtectGroupUtil.isLocalStorageReplica((ProtectGroupReplica)replica)) continue;
            remoteReplica = replica;
            break;
        }
        if (null == remoteReplica) {
            return lunIds;
        }
        int protectLocation = NumberUtil.convertToInteger((Object)context.getObject("PG_EXECUTE_LOCATION"));
        for (ProtectObjectReplica protectObjectReplica : remoteReplica.getReplicas()) {
            for (RelicaStorageInfo storageInfo : protectObjectReplica.getStorageInfos()) {
                if (!(storageInfo instanceof RemoteStorageReplica) || !archieveLogLunWwn.contains(storageInfo.getProtectObjectStorageWwn())) continue;
                if (protectLocation == DrmEnumDefine.ProtectLocation.A_A.getValue()) {
                    lunIds.add(storageInfo.getSrcStorageId());
                }
                if (protectLocation != DrmEnumDefine.ProtectLocation.A_B.getValue()) continue;
                lunIds.add(storageInfo.getStorageId());
            }
        }
        return lunIds;
    }

    private List<String> getSnapshotIds(SnapShotAssociateProtectObject apo, List<String> archieveLogLunId) {
        ArrayList<String> snapshotIds = new ArrayList<String>();
        Map snapshotInfo = apo.getSnapshotInfo();
        Set snapshotIdSet = snapshotInfo.entrySet();
        for (Map.Entry entry : snapshotIdSet) {
            String lunId = (String)entry.getKey();
            if (!this.isActiveSnapshot(archieveLogLunId, lunId)) continue;
            snapshotIds.add((String)entry.getValue());
        }
        LOGGER.debug((Object)("archieveLogLunId=" + archieveLogLunId + ",snapshotIds=" + snapshotIds), 90160758786988L);
        return snapshotIds;
    }
}

