/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.oracle.protect.action;

import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.app.constants.DrmAppEnumDefine;
import com.huawei.ism.drm.application.adapter.sdk.service.IApplicationManager;
import com.huawei.ism.drm.application.manager.proxy.ApplicationAdapterProxy;
import com.huawei.ism.drm.db.protect.action.BaseDatabaseFreezeAction;
import com.huawei.ism.drm.host.sdk.model.DrHost;
import com.huawei.ism.drm.host.sdk.model.DrHostGroup;
import com.huawei.ism.drm.host.sdk.service.IHostRetrieveProxy;
import com.huawei.ism.drm.host.util.ProtectObjectAppUtil;
import com.huawei.ism.drm.protection.action.model.ActionContext;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class OracleFreezeAction
extends BaseDatabaseFreezeAction {
    private static final Log LOGGER = LogFactory.getInstance(OracleFreezeAction.class);

    protected boolean freeze(ActionContext context, ProtectGroup protectGroup) {
        Set protectObjects = (Set)context.getObject("PO_ENTITY");
        Set freezePo = this.combineProtectObjectByType(protectObjects, protectGroup);
        String providerSn = protectGroup.getPoProviderSN();
        IResourceService resourceService = (IResourceService)ServiceLocator.getInstance().getService(IResourceService.class);
        DrResource drResource = resourceService.getDrResourceBySn(providerSn);
        try {
            this.queryAndUpdateActvieHostSn(freezePo, drResource);
        }
        catch (LegoCheckedException e) {
            this.setDetail(e.getErrorMessageKey());
            this.setDetailParams(this.constructParams(e.getParameters()));
            LOGGER.error((Object)("queryAndUpdateActvieHostSn failed, pgName:" + protectGroup.getName()), (Throwable)e, 90160758786989L);
            return false;
        }
        if (!this.checkOracleCapThreashold(context, protectGroup, freezePo, drResource)) {
            return false;
        }
        return super.freeze(context, protectGroup);
    }

    private boolean checkOracleCapThreashold(ActionContext context, ProtectGroup protectGroup, Set<ProtectObject> freezePo, DrResource drResource) {
        try {
            String capThreashold = ProtectObjectAppUtil.getPolicyTemplateSettings((ActionContext)context, (String)"ORACLE_CAP_THREASHOLD");
            if (VerifyUtil.isEmpty((String)capThreashold) || NumberUtil.parseInteger((Object)capThreashold) <= 0) {
                LOGGER.info((Object)("The capThreashold is empty or <=0, providerSn=" + drResource.getDeviceSn()), 90160758786988L);
                return true;
            }
            List<DrHost> drHosts = this.getDrHosts(drResource);
            IApplicationManager applicationManager = ApplicationAdapterProxy.getInstance().getAppManager(protectGroup.getPoType());
            for (ProtectObject protectObject : freezePo) {
                int instanceStartFailNum = 0;
                for (DrHost drHost : drHosts) {
                    String activeHostSn = (String)protectObject.getProps().get("ACTIVE_NODE_HOST_SN");
                    if (null != activeHostSn && !activeHostSn.equals(drHost.getDeviceSn())) continue;
                    protectObject.getProps().put("ORACLE_CAP_THREASHOLD", capThreashold);
                    String providerSN = protectObject.getProviderSN();
                    protectObject.setProviderSN(drHost.getDeviceSn());
                    instanceStartFailNum = this.checkEnvFreeze(instanceStartFailNum, applicationManager, protectObject);
                    protectObject.setProviderSN(providerSN);
                }
                if (instanceStartFailNum != drHosts.size()) continue;
                throw new LegoCheckedException(1073948956L);
            }
        }
        catch (LegoCheckedException e) {
            this.setDetail(e.getErrorMessageKey());
            this.setDetailParams(this.constructParams(e.getParameters()));
            LOGGER.error((Object)("BaseFreezeAction executed failed, pgName:" + protectGroup.getName()), (Throwable)e, 90160758786989L);
            return false;
        }
        catch (Exception e) {
            LOGGER.error((Object)("BaseFreezeAction executed failed, pgName:" + protectGroup.getName() + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
            this.setDetail("lego.err.1073948171");
            return false;
        }
        return true;
    }

    private int checkEnvFreeze(int instanceStartFailNum, IApplicationManager applicationManager, ProtectObject protectObject) {
        try {
            applicationManager.checkEnvForFreeze(protectObject);
        }
        catch (LegoCheckedException e) {
            if (1073948956L == e.getErrorCode()) {
                ++instanceStartFailNum;
            }
            throw e;
        }
        return instanceStartFailNum;
    }

    private List<DrHost> getDrHosts(DrResource drResource) {
        ArrayList<DrHost> drHosts = new ArrayList<DrHost>();
        if (null == drResource) {
            LOGGER.error((Object)"drResource is empty", 90160758786989L);
            return drHosts;
        }
        if (drResource instanceof DrHostGroup) {
            for (DrResource childResource : drResource.getChildResources()) {
                drHosts.add((DrHost)childResource);
            }
        } else if (drResource instanceof DrHost) {
            drHosts.add((DrHost)drResource);
        }
        return drHosts;
    }

    private void queryAndUpdateActvieHostSn(Set<ProtectObject> freezePo, DrResource drResource) {
        if (!(drResource instanceof DrHostGroup)) {
            LOGGER.error((Object)("drResource is not DrHostGroup:" + drResource.getDeviceSn()), 90160758786989L);
            return;
        }
        DrHostGroup hostGroup = (DrHostGroup)drResource;
        if (hostGroup.getClusterType() == DrmAppEnumDefine.CLUSTER_TYPE_E.ORACLE_RAC.getValue()) {
            LOGGER.error((Object)("hostGroup is rac cluster:" + hostGroup.getDeviceSn()), 90160758786989L);
            return;
        }
        for (ProtectObject protectObject : freezePo) {
            String resourceGroup = (String)protectObject.getProps().get("RESOURCEGROUP_NAME");
            DrHost drHost = ((IHostRetrieveProxy)ServiceLocator.getInstance().getService(IHostRetrieveProxy.class)).queryActiveNodeInHostGroup(hostGroup, String.valueOf(hostGroup.getClusterType()), resourceGroup);
            if (null == drHost) continue;
            protectObject.getProps().put("ACTIVE_NODE_HOST_SN", drHost.getDeviceSn());
            LOGGER.debug((Object)("Actvie host sn is" + drHost.getDeviceSn()), 90160758786988L);
        }
    }
}

