/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.oracle.recovery.process;

import com.huawei.ism.array.sdk.model.HvsProtectionGroup;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.oracle.recovery.process.AdgRefactorPoReplicationProcessor;
import com.huawei.ism.drm.oracle.recovery.util.OracleAppUtil;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.storage.recovery.process.AddLunSubProcessor;
import com.huawei.ism.drm.storage.recovery.process.CreateProtectionGroupSubProcessor;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class AdgAddPoLunProcessor
extends AdgRefactorPoReplicationProcessor {
    private static final Log LOGGER = LogFactory.getInstance(AdgAddPoLunProcessor.class);

    @Override
    protected boolean execute(RecoveryProcessorContext context) {
        this.updateProcessNameParam(context);
        if (VerifyUtil.isEmpty((Object)context)) {
            LOGGER.error((Object)"Add po lun to group failed because the context is null.");
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        if (VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            Set<RecoveryProcessor> processors = this.createConsistentGroupProcessors(context);
            this.setChildProc(processors);
        } else {
            for (RecoveryProcessor recoveryProcessor : this.getChildProc()) {
                if (!(recoveryProcessor instanceof CreateProtectionGroupSubProcessor)) continue;
                CreateProtectionGroupSubProcessor processor = (CreateProtectionGroupSubProcessor)recoveryProcessor;
                HvsProtectionGroup protectionGroup = (HvsProtectionGroup)context.getAttribute(processor.getProperty(processor.getRecoveryTasksKey()), HvsProtectionGroup.class);
                processor.setProtectionGroup(protectionGroup);
            }
        }
        return this.executeSubProcessor(context);
    }

    @Override
    protected Set<RecoveryProcessor> createConsistentGroupProcessors(RecoveryProcessorContext context) {
        ProtectGroupReplica replica = context.getProtectGroupReplica();
        HashSet<RecoveryProcessor> subProcessors = new HashSet<RecoveryProcessor>();
        subProcessors.add(this.createSubProcessor(context, "-aToBSrcGroup", "aToBPairSrcLunIds", OracleAppUtil.generateGroupKey(this.getPoId(), true, true, "DELETED_PG_OBJECTS"), replica.getProductArray()));
        String aToBTgtGroup = this.isLunGroup(context) ? "-bToASrcGroup" : "-aToBTgtGroup";
        subProcessors.add(this.createSubProcessor(context, aToBTgtGroup, "bToAPairSrcLunIds", OracleAppUtil.generateGroupKey(this.getPoId(), true, false, "DELETED_PG_OBJECTS"), replica.getRecoveryArray()));
        String bToASrcGroup = this.isLunGroup(context) ? "-aToBTgtGroup" : "-bToASrcGroup";
        subProcessors.add(this.createSubProcessor(context, bToASrcGroup, "aToBPairTgtLunIds", OracleAppUtil.generateGroupKey(this.getPoId(), false, true, "DELETED_PG_OBJECTS"), replica.getRecoveryArray()));
        subProcessors.add(this.createSubProcessor(context, "-bToATgtGroup", "bToAPairTgtLunIds", OracleAppUtil.generateGroupKey(this.getPoId(), false, false, "DELETED_PG_OBJECTS"), replica.getProductArray()));
        LOGGER.info((Object)"Create add po lun to group processors success.");
        context.setAttribute(this.getPoId() + "_pgProcessors", subProcessors);
        return subProcessors;
    }

    private RecoveryProcessor createSubProcessor(RecoveryProcessorContext context, String groupIdKey, String lunIdKey, String groupObjKey, String devSn) {
        RecoveryProcessor subProcessor;
        RecoveryPlan recoveryPlan = this.getCurrentRecoveryPlan(context.getRecoveryPlan());
        String groupId = (String)recoveryPlan.getGlobalSettings().get(this.getPoId() + groupIdKey);
        if (this.isLunGroup(context)) {
            HvsProtectionGroup protectionGroup = (HvsProtectionGroup)context.getAttribute(groupObjKey, HvsProtectionGroup.class);
            subProcessor = this.createProtectionGroupSubProcessor(groupId, protectionGroup, groupObjKey);
        } else {
            String lunIds = (String)recoveryPlan.getGlobalSettings().get(this.getPoId() + lunIdKey);
            subProcessor = this.createAddLunSubProcessor(Arrays.asList(lunIds.split(",")), devSn, groupId);
        }
        return subProcessor;
    }

    private boolean isLunGroup(RecoveryProcessorContext context) {
        RecoveryPlan recoveryPlan = this.getCurrentRecoveryPlan(context.getRecoveryPlan());
        return Boolean.parseBoolean((String)recoveryPlan.getGlobalSettings().get(this.getPoId() + "isLunGroup"));
    }

    private RecoveryProcessor createAddLunSubProcessor(List<String> lunIds, String devSn, String groupId) {
        AddLunSubProcessor processor = new AddLunSubProcessor();
        processor.setLunIds(String.join((CharSequence)",", lunIds));
        processor.setDevSn(devSn);
        processor.setGroupId(groupId);
        processor.setProcName(processor.getName());
        processor.setParentProc((RecoveryProcessor)this);
        processor.setProcessId(this.getProcessId());
        processor.setProcType(this.getProcType());
        processor.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
        return processor;
    }

    private RecoveryProcessor createProtectionGroupSubProcessor(String lunGroupId, HvsProtectionGroup group, String groupObjKey) {
        CreateProtectionGroupSubProcessor processor = new CreateProtectionGroupSubProcessor();
        processor.setProperty(processor.getRecoveryTasksKey(), (Object)groupObjKey);
        group.setLunGroupId(lunGroupId);
        processor.setProtectionGroup(group);
        processor.setProcName(processor.getName());
        processor.setParentProc((RecoveryProcessor)this);
        processor.setProcessId(this.getProcessId());
        processor.setProcType(this.getProcType());
        processor.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
        return processor;
    }
}

