/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.oracle.recovery.process;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.oracle.recovery.process.AdgRefactorPoReplicationProcessor;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.storage.recovery.process.AddReplicationSubProcessor;
import com.huawei.ism.drm.storage.recovery.process.CreateReplicationSubProcessor;
import com.huawei.ism.drm.util.CastUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class AdgAddPoReplicationProcessor
extends AdgRefactorPoReplicationProcessor {
    private static final Log LOGGER = LogFactory.getInstance(AdgAddPoReplicationProcessor.class);

    @Override
    protected boolean execute(RecoveryProcessorContext context) {
        this.updateProcessNameParam(context);
        if (VerifyUtil.isEmpty((Object)context)) {
            LOGGER.error((Object)"Add po pairs to group failed because the context is null.");
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        if (VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            Set<RecoveryProcessor> processors = this.createConsistentGroupProcessors(context);
            this.setChildProc(processors);
        }
        return this.executeSubProcessor(context);
    }

    @Override
    protected Set<RecoveryProcessor> createConsistentGroupProcessors(RecoveryProcessorContext context) {
        Set processors = (Set)CastUtil.castTo((Object)context.getAttribute(this.getPoId() + "_pairProcessor"), Set.class);
        Map<String, List<CreateReplicationSubProcessor>> devSnAndProcessorMap = processors.stream().collect(Collectors.groupingBy(CreateReplicationSubProcessor::getSrcDevSn));
        ProtectGroupReplica replica = context.getProtectGroupReplica();
        HashSet<RecoveryProcessor> subProcessors = new HashSet<RecoveryProcessor>();
        String aToBCgId = this.getReplicationGroupId(context, "aToB");
        List<String> aToBPairIds = devSnAndProcessorMap.get(replica.getProductArray()).stream().map(CreateReplicationSubProcessor::getReplicationId).collect(Collectors.toList());
        this.createSubProcessor(subProcessors, replica.getProductArray(), aToBCgId, aToBPairIds);
        String bToACgId = this.getReplicationGroupId(context, "bToA");
        List<String> bToAPairIds = devSnAndProcessorMap.get(replica.getRecoveryArray()).stream().map(CreateReplicationSubProcessor::getReplicationId).collect(Collectors.toList());
        this.createSubProcessor(subProcessors, replica.getRecoveryArray(), bToACgId, bToAPairIds);
        LOGGER.info((Object)"Create add replication processors success.");
        return subProcessors;
    }

    private String getReplicationGroupId(RecoveryProcessorContext context, String processKey) {
        Set processors = (Set)CastUtil.castTo((Object)context.getAttribute(this.getPoId() + "_cgProcessors"), Set.class);
        return processors.stream().filter(processor -> processor.getProperty(processKey) != null).findFirst().orElseThrow(() -> new LegoCheckedException(2117645L)).getCreatedGroupId();
    }

    private void createSubProcessor(Set<RecoveryProcessor> subProcessors, String devSn, String cgId, List<String> pairIdList) {
        AddReplicationSubProcessor subProcessor = new AddReplicationSubProcessor();
        subProcessor.setDevSn(devSn);
        subProcessor.setGroupId(cgId);
        subProcessor.setPairIds(String.join((CharSequence)",", pairIdList));
        subProcessor.setProcName(subProcessor.getName());
        subProcessor.setParentProc((RecoveryProcessor)this);
        subProcessor.setProcessId(this.getProcessId());
        subProcessor.setProcType(this.getProcType());
        subProcessor.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
        subProcessors.add((RecoveryProcessor)subProcessor);
    }
}

