/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.oracle.recovery.process;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.oracle.recovery.process.AdgRefactorPoReplicationProcessor;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.storage.recovery.process.DeleteReplicationSubProcessor;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class AdgDeletePoReplicationProcessor
extends AdgRefactorPoReplicationProcessor {
    private static final Log LOGGER = LogFactory.getInstance(AdgDeletePoReplicationProcessor.class);

    @Override
    protected Set<RecoveryProcessor> createReplicationPairProcessors(RecoveryProcessorContext context) {
        Map globalSettings = this.getCurrentRecoveryPlan(context.getRecoveryPlan()).getGlobalSettings();
        String aToBPairIds = (String)globalSettings.get(this.getPoId() + "_aToBPairIds");
        List<String> aToBPairIdList = Arrays.asList(aToBPairIds.split(","));
        ProtectGroupReplica replica = context.getProtectGroupReplica();
        Set<RecoveryProcessor> processors = this.getSubProcessors(aToBPairIdList, replica.getProductArray(), replica.getRecoveryArray());
        String bToAPairIds = (String)globalSettings.get(this.getPoId() + "_bToAPairIds");
        List<String> bToAPairIdList = Arrays.asList(bToAPairIds.split(","));
        Set<RecoveryProcessor> processors2 = this.getSubProcessors(bToAPairIdList, replica.getRecoveryArray(), replica.getProductArray());
        processors.addAll(processors2);
        LOGGER.info((Object)"Create delete replication pair sub processor success.");
        return processors;
    }

    private Set<RecoveryProcessor> getSubProcessors(List<String> pairList, String srcDev, String tgtDev) {
        return pairList.stream().map(id -> {
            DeleteReplicationSubProcessor processor = new DeleteReplicationSubProcessor();
            processor.setReplicationId(id);
            processor.setSrcDevSn(srcDev);
            processor.setTargetDevSn(tgtDev);
            this.initSubProcessor((RecoveryProcessor)processor);
            return processor;
        }).collect(Collectors.toSet());
    }

    @Override
    protected Set<RecoveryProcessor> createConsistentGroupProcessors(RecoveryProcessorContext context) {
        return this.createReplicationPairProcessors(context);
    }

    private void initSubProcessor(RecoveryProcessor subProcessor) {
        subProcessor.setProcName(subProcessor.getName());
        subProcessor.setParentProc((RecoveryProcessor)this);
        subProcessor.setProcessId(this.getProcessId());
        subProcessor.setProcType(this.getProcType());
        subProcessor.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
    }
}

