/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.oracle.recovery.process;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryLog;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanService;
import com.huawei.ism.drm.oracle.recovery.util.OracleAppUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.recovery.task.RecoveryTask;
import com.huawei.ism.drm.storage.recovery.process.DeleteReplicationGroupProcessor;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.ism.drm.util.CastUtil;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class AdgDeleteReplicationGroupProcessor
extends BaseRecoveryProcessor {
    private static final Log LOGGER = LogFactory.getInstance(AdgDeleteReplicationGroupProcessor.class);
    private static final String REPLICATION_CG_KEY = "recovery-task-key-";

    protected boolean execute(RecoveryProcessorContext context) {
        VerifyUtil.checkObject((Object)context);
        VerifyUtil.checkObject((Object)context.getProtectGroup());
        ProtectGroup protectGroup = context.getProtectGroup();
        if (VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            Set<RecoveryProcessor> subProcessors = this.generateSubProcessors(protectGroup);
            if (subProcessors.isEmpty()) {
                this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
                return true;
            }
            this.saveSubProcessors(subProcessors);
        }
        return this.executeSubProcessor(context);
    }

    public void endRecoveryProcessor() {
        super.endRecoveryProcessor();
        if (this.getProcStatus() == DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue()) {
            this.saveReplicationGroups();
        }
    }

    private void saveReplicationGroups() {
        RecoveryProcessorContext context = this.getContextRef();
        for (RecoveryProcessor recoveryProcessor : this.getChildProc()) {
            if (!(recoveryProcessor instanceof DeleteReplicationGroupProcessor)) continue;
            DeleteReplicationGroupProcessor delGroupProcessor = (DeleteReplicationGroupProcessor)CastUtil.castTo((Object)recoveryProcessor, DeleteReplicationGroupProcessor.class);
            String poId = (String)delGroupProcessor.getProps().get("PO_ID");
            List deletedReplicationGroups = delGroupProcessor.getDeletedReplicationGroups();
            context.setAttribute("DELETED_REP_CG_OBJECTS_" + poId, (Object)deletedReplicationGroups);
            LOGGER.info((Object)"Deleted replication group saved: poId=%s, groups size=%s", new Object[]{poId, Optional.ofNullable(deletedReplicationGroups).orElse(Collections.emptyList()).size()});
        }
    }

    private Set<RecoveryProcessor> generateSubProcessors(ProtectGroup protectGroup) {
        HashSet<RecoveryProcessor> subProcessors = new HashSet<RecoveryProcessor>();
        Set poSet = Optional.ofNullable(protectGroup.getPolist()).orElseGet(Collections::emptySet);
        for (ProtectObject po : poSet) {
            List<ReplicationPair> pairList = OracleAppUtil.getPairList(protectGroup, po.getUuid(), true);
            ReplicationPair replicationPair = (ReplicationPair)Optional.ofNullable(CommonUtil.getFirstElement(pairList)).orElseThrow(() -> new LegoCheckedException(1073947393L));
            if (!AdgDeleteReplicationGroupProcessor.isPairBelongToConsistentGroup(replicationPair)) {
                LOGGER.info((Object)"%s does not use consistent group (A->B), skip delete replication group.", new Object[]{po.getName()});
                continue;
            }
            RecoveryTask recoveryTaskA2B = this.generateRecoveryTask(replicationPair.getSrcDevSN(), replicationPair.getTgtDevSN(), replicationPair.getConsistentGroupId());
            pairList = OracleAppUtil.getPairList(protectGroup, po.getUuid(), false);
            replicationPair = (ReplicationPair)Optional.ofNullable(CommonUtil.getFirstElement(pairList)).orElseThrow(() -> new LegoCheckedException(1073947393L));
            if (!AdgDeleteReplicationGroupProcessor.isPairBelongToConsistentGroup(replicationPair)) {
                LOGGER.info((Object)"%s does not use consistent group (B->A), skip delete replication group.", new Object[]{po.getName()});
                continue;
            }
            RecoveryTask recoveryTaskB2A = this.generateRecoveryTask(replicationPair.getSrcDevSN(), replicationPair.getTgtDevSN(), replicationPair.getConsistentGroupId());
            String recoveryTasksKey = REPLICATION_CG_KEY + po.getUuid();
            List<RecoveryTask> recoveryTasks = Arrays.asList(recoveryTaskA2B, recoveryTaskB2A);
            DeleteReplicationGroupProcessor processor = this.createSubProcessor(po, recoveryTasksKey);
            processor.getProps().put(recoveryTasksKey, JSONArray.fromObject(recoveryTasks).toString());
            subProcessors.add((RecoveryProcessor)processor);
        }
        return subProcessors;
    }

    private static boolean isPairBelongToConsistentGroup(ReplicationPair replicationPair) {
        String groupId = replicationPair.getConsistentGroupId();
        if (VerifyUtil.isEmpty((String)groupId) || "--".equals(groupId)) {
            LOGGER.info((Object)"Replication pair does not belong to cg: srcDevSn=%s, pairId=%s", new Object[]{replicationPair.getSrcDevSN(), replicationPair.getReplicationId()});
            return false;
        }
        return true;
    }

    private DeleteReplicationGroupProcessor createSubProcessor(ProtectObject po, String recoveryTasksKey) {
        DeleteReplicationGroupProcessor processor = new DeleteReplicationGroupProcessor();
        processor.setProperty("CUSTOM_NAME", (Object)"com.huawei.ism.drm.storage.recovery.process.DeleteReplicationGroupProcessor.ADG");
        processor.setProperty("CUSTOM_NAME_PARAM", (Object)po.getName());
        processor.setProcName(processor.getName());
        processor.setParentProc((RecoveryProcessor)this);
        processor.setProcessId(this.getProcessId());
        processor.setProcType(this.getProcType());
        processor.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
        processor.getProps().put("PO_ID", po.getUuid());
        processor.getProps().put(processor.getRecoveryTasksKey(), recoveryTasksKey);
        return processor;
    }

    private RecoveryTask generateRecoveryTask(String devSn, String tgtDevSn, String groupId) {
        RecoveryTask recoveryTask = new RecoveryTask();
        recoveryTask.setConsistentGroupId(groupId);
        recoveryTask.setSrcDeviceId(devSn);
        recoveryTask.setTgtDevcieId(tgtDevSn);
        return recoveryTask;
    }

    public void resetEnableStatus(ProtectGroup pg, DrmEnumDefine.RecoveryPlanExecuteTypeE execType) {
        IRecoveryPlanService planService = (IRecoveryPlanService)ServiceLocator.getInstance().getService(IRecoveryPlanService.class);
        RecoveryLog log = planService.getLatestSuccessHistoryRecoveryLog(this.getPlanId(), Long.valueOf(new Date().getTime()));
        this.setIsEnabled(VerifyUtil.isEmpty((Object)log) || log.getLogType() != DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.getValue());
        this.setIsEditable(false);
    }
}

