/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.oracle.recovery.process;

import com.huawei.ism.array.sdk.model.HvsProtectionGroup;
import com.huawei.ism.array.sdk.model.XveLunGroup;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.proxy.xve.XveMOType;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.model.RecoverySetting;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.drp.util.RecoveryServiceUtil;
import com.huawei.ism.drm.host.recovery.process.MappingLunProcessor;
import com.huawei.ism.drm.host.util.DrHostUtil;
import com.huawei.ism.drm.oracle.recovery.process.AdgMappingLunSubProcessor;
import com.huawei.ism.drm.oracle.recovery.util.OracleAppUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessConcurrentExecutor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.storage.handler.IStorageLunHandler;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.orm.hibernate5.HibernateTemplate;

public class AdgMappingLunProcessor
extends MappingLunProcessor {
    private static final long serialVersionUID = -5552943857894472905L;
    private static final Log logger = LogFactory.getInstance(AdgMappingLunProcessor.class);

    private static String getDeviceSn(RecoveryPlan recoveryPlan) {
        String deviceSn = (String)recoveryPlan.getGlobalSettings().get("PG_DISASTER_HOST");
        for (RecoverySetting setting : recoveryPlan.getRecoverySettings()) {
            if (!setting.getRecoveryPlan().getPlanId().equals(recoveryPlan.getPlanId()) || !setting.getName().equals("PG_DISASTER_HOST")) continue;
            deviceSn = setting.getValue();
            break;
        }
        return deviceSn;
    }

    public void resetEnableStatus(ProtectGroup pg, DrmEnumDefine.RecoveryPlanExecuteTypeE procType) {
        if (this.getProcType() == DrmEnumDefine.RecoveryPlanExecuteTypeE.REPROTECT.getValue()) {
            this.setIsEnabled(false);
            this.setIsEditable(false);
        } else {
            this.setIsEnabled(true);
            this.setIsEditable(false);
        }
    }

    public boolean execute(RecoveryProcessorContext context) {
        String currentHostOrGroupId = DrHostUtil.getCurrentDisasterHost((RecoveryPlan)context.getRecoveryPlan(), (int)this.getProcType());
        if (currentHostOrGroupId == null) {
            throw new LegoCheckedException(1073947393L);
        }
        Set mappingLunSubProcessors = this.getChildProc();
        if (VerifyUtil.isEmpty((Collection)mappingLunSubProcessors)) {
            this.createSubProcessors(context);
        }
        List processors = RecoveryServiceUtil.sortAndUpdateProcessorRation((Set)this.getChildProc());
        RecoveryProcessConcurrentExecutor concurrentExecutor = RecoveryProcessConcurrentExecutor.createExecutor((List)processors);
        concurrentExecutor.process(context);
        boolean isSuccess = this.calcProcessResultBySubProc();
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.PART_SUCCESS.getValue() == this.getProcStatus()) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            isSuccess = false;
        }
        return isSuccess;
    }

    private void createSubProcessors(RecoveryProcessorContext context) {
        ProtectGroup pg = context.getProtectGroup();
        Set polist = pg.getPolist();
        ProtectGroupReplica replica = context.getProtectGroupReplica();
        HashSet<RecoveryProcessor> mappingLunSubProcessors = new HashSet<RecoveryProcessor>();
        RecoveryPlan recoveryPlan = OracleAppUtil.getCurrentRecoveryPlan(context.getRecoveryPlan());
        for (ProtectObject po : polist) {
            List<String> aToBTgtLunIdList = OracleAppUtil.getAdgBackupLunIdList(po);
            List<String> bToASrcLunIdList = OracleAppUtil.getRemoteLunIdList(po);
            String bToASrcLunGroup = this.getLunGroupId(replica.getRecoveryArray(), bToASrcLunIdList.get(0));
            this.createMappingLunSubProcessors(aToBTgtLunIdList, bToASrcLunGroup, mappingLunSubProcessors, replica);
            recoveryPlan.getGlobalSettings().put(po.getUuid() + "-bToASrcLunGroupId", bToASrcLunGroup);
            HvsProtectionGroup protectionGroup = OracleAppUtil.getHvsProtectionGroup(replica.getRecoveryArray(), bToASrcLunIdList.get(0));
            if (VerifyUtil.isEmpty((String)protectionGroup.getLunGroupId()) || "-1".equals(protectionGroup.getLunGroupId())) continue;
            String aToBTgtLunGroup = this.getLunGroupId(replica.getRecoveryArray(), aToBTgtLunIdList.get(0));
            this.createMappingLunSubProcessors(bToASrcLunIdList, aToBTgtLunGroup, mappingLunSubProcessors, replica);
            recoveryPlan.getGlobalSettings().put(po.getUuid() + "-aToBTgtLunGroupId", aToBTgtLunGroup);
        }
        HibernateTemplate hibernateTemplate = CommonDAOLocator.getBaseDao().getHibernateTemplate();
        hibernateTemplate.saveOrUpdate((Object)recoveryPlan);
        if (!VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            this.updateSubProcessors(mappingLunSubProcessors);
        } else {
            this.setChildProc(mappingLunSubProcessors);
        }
        ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
        logger.info((Object)"Create adg add lun mapping processors success, size:%s", new Object[]{String.valueOf(mappingLunSubProcessors.size())});
    }

    private void createMappingLunSubProcessors(List<String> lunIdList, String lunGroupId, Set<RecoveryProcessor> processors, ProtectGroupReplica replica) {
        for (String lunId : lunIdList) {
            AdgMappingLunSubProcessor processor = new AdgMappingLunSubProcessor();
            processor.setLunId(lunId);
            processor.setLunGroupId(lunGroupId);
            processor.setSrcDeviceId(replica.getProductArray());
            processor.setDeviceId(replica.getRecoveryArray());
            processor.setProcName(processor.getName());
            processor.setProcType(this.getProcType());
            processor.setPlanId(this.getPlanId());
            processor.setProcessId(this.getProcessId());
            processor.setParentProc((RecoveryProcessor)this);
            processor.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
            processor.setIsCheckReplication(false);
            processors.add((RecoveryProcessor)processor);
        }
    }

    private String getLunGroupId(String deviceSn, String lunId) {
        IStorageLunHandler lunHandler = (IStorageLunHandler)ServiceLocator.getInstance().getService(IStorageLunHandler.class);
        List lunGroups = lunHandler.queryLunGroups(deviceSn, XveMOType.LUN, lunId);
        if (VerifyUtil.isEmpty((Collection)lunGroups) || VerifyUtil.isEmpty((String)((XveLunGroup)lunGroups.get(0)).getLunGroupId())) {
            logger.error((Object)"Get lun group id failed.");
            throw new LegoCheckedException(1694720771L);
        }
        return ((XveLunGroup)lunGroups.get(0)).getLunGroupId();
    }
}

