/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.oracle.recovery.process;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryResourceService;
import com.huawei.ism.drm.host.recovery.process.MappingLunSubProcessor;
import com.huawei.ism.drm.operation.sdk.model.OperationResult;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.storage.manager.proxy.StorageLunManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageLunBaseManager;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;

public class AdgMappingLunSubProcessor
extends MappingLunSubProcessor {
    private static final Log logger = LogFactory.getInstance(AdgMappingLunSubProcessor.class);

    public boolean execute(RecoveryProcessorContext context) {
        boolean execute = super.execute(context);
        if (execute && "ism.drm.recovery.lun.already.mapped".equals(this.getProcDetail())) {
            this.updateProcessNameParams(new String[]{this.getLunName(), this.getLunGroupId()});
        }
        return execute;
    }

    protected OperationResult mappingLun(RecoveryProcessorContext context) {
        IRecoveryResourceService recoveryService = (IRecoveryResourceService)ServiceLocator.getInstance().getService(IRecoveryResourceService.class);
        Lun lun = recoveryService.getTargetLunById(this.getDeviceId(), this.getLunId());
        DrResource drResource = recoveryService.getDrResourceByID(this.getHostOrGroupId());
        if (VerifyUtil.isAnyEmpty((Object[])new Object[]{lun, drResource})) {
            this.updateProcessName("ism.drm.recovery.lun.mapping.failed");
            OperationResult operationResult = this.checkOperationObject(this.getDeviceId(), lun, drResource);
            return operationResult;
        }
        this.updateProcessNameParams(new String[]{lun.getName(), this.getLunGroupId()});
        this.setLunName(lun.getName());
        this.setLunWWN(lun.getWwn());
        this.setHostOrGroupName(drResource.getName());
        StorageLunManagerProxy storageManagerProxy = StorageLunManagerProxy.getInstance();
        String deviceType = recoveryService.getStorageType(this.getDeviceId());
        IStorageLunBaseManager proxy = storageManagerProxy.getStorageLunMgrByDevType(deviceType);
        return proxy.addLunToLunGroup(this.getDeviceId(), this.getLunId(), this.getLunGroupId());
    }
}

