/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.oracle.recovery.process;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanService;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;

public class AdgRefactorPoReplicationProcessor
extends BaseRecoveryProcessor {
    private static final Log LOGGER = LogFactory.getInstance(AdgRefactorPoReplicationProcessor.class);
    private String poId;
    private String poName;

    protected boolean execute(RecoveryProcessorContext context) {
        this.updateProcessNameParam(context);
        if (VerifyUtil.isEmpty((Object)context)) {
            LOGGER.error((Object)"Refactor protect object replication failed because the context is null.");
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        if (VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            Set<RecoveryProcessor> subProcessors = this.createReplicationPairProcessors(context);
            this.setChildProc(subProcessors);
        }
        return this.executeSubProcessor(context);
    }

    protected Set<RecoveryProcessor> createReplicationPairProcessors(RecoveryProcessorContext context) {
        return Collections.emptySet();
    }

    protected Set<RecoveryProcessor> createConsistentGroupProcessors(RecoveryProcessorContext context) {
        return Collections.emptySet();
    }

    protected void updateProcessNameParam(RecoveryProcessorContext context) {
        this.updateProcessNameParams(new String[]{this.poName});
    }

    protected RecoveryPlan getCurrentRecoveryPlan(RecoveryPlan recoveryPlan) {
        IRecoveryPlanService planService = (IRecoveryPlanService)ServiceLocator.getInstance().getService(IRecoveryPlanService.class);
        return planService.getRecoveryPlan(recoveryPlan.getPlanId(), false, false);
    }

    public String getPoId() {
        return this.poId;
    }

    public String getPoName() {
        return this.poName;
    }

    public void setPoId(String poId) {
        this.poId = poId;
    }

    public void setPoName(String poName) {
        this.poName = poName;
    }
}

