/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.oracle.recovery.process;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.host.recovery.process.RefreshHostProcessor;
import com.huawei.ism.drm.host.sdk.model.DrHostGroup;
import com.huawei.ism.drm.oracle.recovery.process.AdgRefreshHostSubProcessor;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.HashSet;
import java.util.Set;

public class AdgRefreshHostProcessor
extends RefreshHostProcessor {
    private static final Log LOGGER = LogFactory.getInstance(AdgRefreshHostProcessor.class);

    protected boolean createSubProcessors(RecoveryProcessorContext context) {
        HashSet<RecoveryProcessor> subProcessors = new HashSet<RecoveryProcessor>();
        this.generateDisasterSubProcessors(context, subProcessors);
        this.generateProductSubProcessors(context, subProcessors);
        this.setChildProc(subProcessors);
        LOGGER.info((Object)"Generate refresh host sub processors success.");
        return ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
    }

    private void generateDisasterSubProcessors(RecoveryProcessorContext context, Set<RecoveryProcessor> subProcessors) {
        ProtectGroup protectGroup = context.getProtectGroup();
        String hostSns = (String)protectGroup.getProps().get("STAND_BY_HOSTSNS");
        for (String hostSn : hostSns.split(",")) {
            DrResource dr = ((IResourceService)ServiceLocator.getInstance().getService(IResourceService.class)).getDrResourceBySn(hostSn);
            subProcessors.add((RecoveryProcessor)this.generateSubProcessor(dr));
        }
    }

    private void generateProductSubProcessors(RecoveryProcessorContext context, Set<RecoveryProcessor> subProcessors) {
        String poProviderSN = context.getProtectGroup().getPoProviderSN();
        DrResource dr = ((IResourceService)ServiceLocator.getInstance().getService(IResourceService.class)).getDrResourceBySn(poProviderSN);
        if (dr instanceof DrHostGroup) {
            for (DrResource drHost : dr.getChildResources()) {
                subProcessors.add((RecoveryProcessor)this.generateSubProcessor(drHost));
            }
        } else {
            subProcessors.add((RecoveryProcessor)this.generateSubProcessor(dr));
        }
    }

    private AdgRefreshHostSubProcessor generateSubProcessor(DrResource host) {
        AdgRefreshHostSubProcessor subProcessor = new AdgRefreshHostSubProcessor();
        subProcessor.setParentProc((RecoveryProcessor)this);
        subProcessor.setProcType(this.getProcType());
        subProcessor.setPlanId(this.getPlanId());
        subProcessor.setProcessId(this.getProcessId());
        subProcessor.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
        subProcessor.setProcName(subProcessor.getName());
        subProcessor.setHostDeviceName(host.getName());
        subProcessor.setHostSN(host.getDeviceSn());
        return subProcessor;
    }
}

