/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.oracle.recovery.process;

import com.huawei.ism.array.sdk.model.HvsProtectionGroup;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.oracle.recovery.process.AdgRefactorPoReplicationProcessor;
import com.huawei.ism.drm.oracle.recovery.util.OracleAppUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.storage.recovery.process.DeleteProtectionGroupSubProcessor;
import com.huawei.ism.drm.storage.recovery.process.RemoveLunSubProcessor;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.ism.drm.util.CastUtil;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.orm.hibernate5.HibernateTemplate;

public class AdgRemovePoLunProcessor
extends AdgRefactorPoReplicationProcessor {
    private static final Log LOGGER = LogFactory.getInstance(AdgRemovePoLunProcessor.class);

    @Override
    protected boolean execute(RecoveryProcessorContext context) {
        this.updateProcessNameParam(context);
        if (VerifyUtil.isEmpty((Object)context)) {
            LOGGER.error((Object)"Remove po lun from group failed because the context is null.");
            return this.failure();
        }
        if (VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            Set<RecoveryProcessor> processors = this.createConsistentGroupProcessors(context);
            this.setChildProc(processors);
        }
        return this.executeSubProcessor(context);
    }

    public void endRecoveryProcessor() {
        super.endRecoveryProcessor();
        if (this.getProcStatus() != DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue()) {
            return;
        }
        for (RecoveryProcessor recoveryProcessor : this.getChildProc()) {
            if (!(recoveryProcessor instanceof DeleteProtectionGroupSubProcessor)) continue;
            DeleteProtectionGroupSubProcessor delPgSubProcessor = (DeleteProtectionGroupSubProcessor)CastUtil.castTo((Object)recoveryProcessor, DeleteProtectionGroupSubProcessor.class);
            Optional deletedProtectionGroup = delPgSubProcessor.getDeletedProtectionGroup();
            String pgKey = (String)delPgSubProcessor.getProps().get("Recovery_ProtectGroup");
            deletedProtectionGroup.ifPresent(pg -> this.getContextRef().setAttribute(pgKey, pg));
        }
    }

    @Override
    protected Set<RecoveryProcessor> createConsistentGroupProcessors(RecoveryProcessorContext context) {
        ProtectGroup protectGroup = context.getProtectGroup();
        List<ReplicationPair> aToBPairs = OracleAppUtil.getPairList(protectGroup, this.getPoId(), true);
        HashSet<RecoveryProcessor> processors = new HashSet<RecoveryProcessor>();
        RecoveryPlan recoveryPlan = this.getCurrentRecoveryPlan(context.getRecoveryPlan());
        this.createSubProcessor(recoveryPlan, aToBPairs, processors, true, true);
        this.createSubProcessor(recoveryPlan, aToBPairs, processors, false, true);
        List<ReplicationPair> bToAPairs = OracleAppUtil.getPairList(protectGroup, this.getPoId(), false);
        this.createSubProcessor(recoveryPlan, bToAPairs, processors, true, false);
        this.createSubProcessor(recoveryPlan, bToAPairs, processors, false, false);
        HibernateTemplate hibernateTemplate = CommonDAOLocator.getBaseDao().getHibernateTemplate();
        hibernateTemplate.saveOrUpdate((Object)recoveryPlan);
        LOGGER.info((Object)"Create remove lun processors success.");
        return processors;
    }

    private void saveGroupAndPairParams(RecoveryPlan recoveryPlan, String id, String idList, boolean isSrcId, boolean isAToB) {
        if (isAToB) {
            if (isSrcId) {
                recoveryPlan.getGlobalSettings().put(this.getPoId() + "-aToBSrcGroup", id);
                recoveryPlan.getGlobalSettings().put(this.getPoId() + "aToBPairSrcLunIds", idList);
            } else {
                recoveryPlan.getGlobalSettings().put(this.getPoId() + "-aToBTgtGroup", id);
                recoveryPlan.getGlobalSettings().put(this.getPoId() + "aToBPairTgtLunIds", idList);
            }
        } else if (isSrcId) {
            recoveryPlan.getGlobalSettings().put(this.getPoId() + "-bToASrcGroup", id);
            recoveryPlan.getGlobalSettings().put(this.getPoId() + "bToAPairSrcLunIds", idList);
        } else {
            recoveryPlan.getGlobalSettings().put(this.getPoId() + "-bToATgtGroup", id);
            recoveryPlan.getGlobalSettings().put(this.getPoId() + "bToAPairTgtLunIds", idList);
        }
    }

    private void createSubProcessor(RecoveryPlan recoveryPlan, List<ReplicationPair> pairs, Set<RecoveryProcessor> processors, boolean isSrcId, boolean isAToB) {
        List lunIds;
        String devSn = isSrcId ? pairs.get(0).getSrcDevSN() : pairs.get(0).getTgtDevSN();
        HvsProtectionGroup group = OracleAppUtil.getHvsProtectionGroup(devSn, (String)(lunIds = pairs.stream().map(isSrcId ? ReplicationPair::getSrcLunId : ReplicationPair::getTgtLunId).collect(Collectors.toList())).get(0));
        if (!VerifyUtil.isEmpty((String)group.getLunGroupId()) && !"-1".equals(group.getLunGroupId())) {
            recoveryPlan.getGlobalSettings().put(this.getPoId() + "isLunGroup", "true");
            this.saveGroupAndPairParams(recoveryPlan, group.getLunGroupId(), String.join((CharSequence)",", lunIds), isSrcId, isAToB);
            DeleteProtectionGroupSubProcessor processor = new DeleteProtectionGroupSubProcessor();
            processor.setProcName(processor.getName());
            processor.setProcType(this.getProcType());
            processor.setPlanId(this.getPlanId());
            processor.setProcessId(this.getProcessId());
            processor.setParentProc((RecoveryProcessor)this);
            processor.setProperty("PG_ID", (Object)group.getProtectGroupId());
            processor.setProperty("DEV_SN", (Object)devSn);
            processor.setProperty("VSTORE_ID", (Object)group.getVstoreId());
            String pgKey = OracleAppUtil.generateGroupKey(this.getPoId(), isSrcId, isAToB, "DELETED_PG_OBJECTS");
            processor.getProps().put("Recovery_ProtectGroup", pgKey);
            processor.setProtectionGroupJson(JSONObject.fromObject((Object)group).toString());
            processors.add((RecoveryProcessor)processor);
            return;
        }
        String lunIdString = String.join((CharSequence)",", lunIds);
        RemoveLunSubProcessor processor = new RemoveLunSubProcessor();
        processor.setLunIds(lunIdString);
        processor.setDevSn(devSn);
        processor.setGroupName(group.getProtectGroupName());
        processor.setGroupId(group.getProtectGroupId());
        processor.setProcName(processor.getName());
        processor.setParentProc((RecoveryProcessor)this);
        processor.setProcessId(this.getProcessId());
        processor.setProcType(this.getProcType());
        processor.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
        processors.add((RecoveryProcessor)processor);
        recoveryPlan.getGlobalSettings().put(this.getPoId() + "isLunGroup", "false");
        this.saveGroupAndPairParams(recoveryPlan, group.getProtectGroupId(), String.join((CharSequence)",", lunIds), isSrcId, isAToB);
    }
}

