/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.oracle.recovery.process;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.oracle.recovery.process.AdgRefactorPoReplicationProcessor;
import com.huawei.ism.drm.oracle.recovery.util.OracleAppUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.storage.recovery.process.RemoveReplicationSubProcessor;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.ism.drm.storage.sdk.model.ReplicationRelation;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.orm.hibernate5.HibernateTemplate;

public class AdgRemovePoReplicationProcessor
extends AdgRefactorPoReplicationProcessor {
    private static final Log LOGGER = LogFactory.getInstance(AdgRemovePoReplicationProcessor.class);

    @Override
    protected boolean execute(RecoveryProcessorContext context) {
        this.updateProcessNameParam(context);
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == this.getProcStatus()) {
            return true;
        }
        if (VerifyUtil.isEmpty((Object)context)) {
            LOGGER.error((Object)"Remove po pairs from group failed because the context is null.");
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        if (VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            Set<RecoveryProcessor> processors = this.createConsistentGroupProcessors(context);
            this.setChildProc(processors);
        }
        return this.executeSubProcessor(context);
    }

    @Override
    protected Set<RecoveryProcessor> createConsistentGroupProcessors(RecoveryProcessorContext context) {
        ProtectGroup protectGroup = context.getProtectGroup();
        List<ReplicationPair> aToBPairList = OracleAppUtil.getPairList(protectGroup, this.getPoId(), true);
        List<ReplicationPair> bToAPairList = OracleAppUtil.getPairList(protectGroup, this.getPoId(), false);
        ProtectGroupReplica replica = context.getProtectGroupReplica();
        HashSet<RecoveryProcessor> processors = new HashSet<RecoveryProcessor>();
        RecoveryPlan recoveryPlan = this.getCurrentRecoveryPlan(context.getRecoveryPlan());
        this.createSubProcessor(aToBPairList, replica.getProductArray(), processors, recoveryPlan);
        this.createSubProcessor(bToAPairList, replica.getRecoveryArray(), processors, recoveryPlan);
        HibernateTemplate hibernateTemplate = CommonDAOLocator.getBaseDao().getHibernateTemplate();
        hibernateTemplate.saveOrUpdate((Object)recoveryPlan);
        LOGGER.info((Object)"Create remove replication processors success.");
        return processors;
    }

    private void createSubProcessor(List<ReplicationPair> pairs, String devSn, Set<RecoveryProcessor> processors, RecoveryPlan recoveryPlan) {
        List pairIdList = pairs.stream().map(ReplicationRelation::getReplicationId).collect(Collectors.toList());
        List cgIdList = pairs.stream().map(ReplicationPair::getConsistentGroupId).distinct().collect(Collectors.toList());
        if (cgIdList.size() != 1) {
            LOGGER.error((Object)"Pair not in same cg.");
            throw new LegoCheckedException(1073947393L);
        }
        RemoveReplicationSubProcessor processor = new RemoveReplicationSubProcessor();
        processor.setDevSn(devSn);
        processor.setPairIds(String.join((CharSequence)",", pairIdList));
        processor.setGroupId((String)cgIdList.get(0));
        processor.setProcName(processor.getName());
        processor.setParentProc((RecoveryProcessor)this);
        processor.setProcessId(this.getProcessId());
        processor.setProcType(this.getProcType());
        processor.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
        processors.add((RecoveryProcessor)processor);
        recoveryPlan.getGlobalSettings().put(this.getPoId() + "_" + devSn, cgIdList.get(0));
    }
}

