/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.oracle.recovery.process;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.oracle.recovery.process.AdgShutdownDrOracleAppSubProcessor;
import com.huawei.ism.drm.oracle.recovery.util.OracleAppUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class AdgShutdownDrOracleAppProcessor
extends BaseRecoveryProcessor {
    private static final Log LOGGER = LogFactory.getInstance(AdgShutdownDrOracleAppProcessor.class);

    public boolean execute(RecoveryProcessorContext context) {
        if (VerifyUtil.isEmpty((Object)context)) {
            LOGGER.error((Object)"Create shutdown processors failed because the context is null.");
            return this.failure();
        }
        if (VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            Set<RecoveryProcessor> subProcessor = this.createShutDownDbSubProcessors(context);
            this.setChildProc(subProcessor);
        } else {
            this.updateSubProcessors(context);
        }
        return this.executeSubProcessor(context);
    }

    public String getName() {
        return AdgShutdownDrOracleAppProcessor.class.getName();
    }

    private Set<RecoveryProcessor> createShutDownDbSubProcessors(RecoveryProcessorContext context) {
        Set currentPos = context.getProtectGroup().getPolist();
        HashSet<RecoveryProcessor> shutdownAdgSubProcessors = new HashSet<RecoveryProcessor>();
        for (ProtectObject po : currentPos) {
            ArrayList<ProtectObject> tmpPoList = new ArrayList<ProtectObject>();
            OracleAppUtil.getDisasterHostTmpPoList(tmpPoList, po);
            if (tmpPoList.isEmpty()) {
                LOGGER.error((Object)"Cannot get dr pos, po:%s", new Object[]{po.getName()});
                throw new LegoCheckedException(1073947795L);
            }
            tmpPoList.forEach(tmpPo -> {
                AdgShutdownDrOracleAppSubProcessor shutDownDbSubProcessor = this.createShutDownDbSubProcessor((ProtectObject)tmpPo);
                shutdownAdgSubProcessors.add((RecoveryProcessor)shutDownDbSubProcessor);
            });
        }
        LOGGER.info((Object)"Create shutdown processors success.");
        return shutdownAdgSubProcessors;
    }

    private void updateSubProcessors(RecoveryProcessorContext context) {
        Set oldProcessors = this.getChildProc();
        List<ProtectObject> allTmpPo = this.getAllTmpPo(context);
        for (RecoveryProcessor oldProcessor : oldProcessors) {
            if (!(oldProcessor instanceof AdgShutdownDrOracleAppSubProcessor)) continue;
            ProtectObject protectObject = allTmpPo.stream().filter(po -> po.getUuid().equals(oldProcessor.getProperty("poId"))).findFirst().orElseThrow(() -> new LegoCheckedException(2117645L));
            ((AdgShutdownDrOracleAppSubProcessor)oldProcessor).setPo(protectObject);
        }
    }

    private List<ProtectObject> getAllTmpPo(RecoveryProcessorContext context) {
        Set pos = context.getProtectGroup().getPolist();
        ArrayList<ProtectObject> tmpPoList = new ArrayList<ProtectObject>();
        pos.forEach(po -> OracleAppUtil.getDisasterHostTmpPoList(tmpPoList, po));
        return tmpPoList;
    }

    private AdgShutdownDrOracleAppSubProcessor createShutDownDbSubProcessor(ProtectObject tmpPo) {
        AdgShutdownDrOracleAppSubProcessor processor = new AdgShutdownDrOracleAppSubProcessor();
        processor.setProcType(this.getProcType());
        processor.setProcName(processor.getName());
        processor.setPlanId(this.getPlanId());
        processor.setProcessId(this.getProcessId());
        processor.setParentProc((RecoveryProcessor)this);
        processor.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
        processor.setDbName(tmpPo.getName());
        processor.setPo(tmpPo);
        processor.setProperty("poId", tmpPo.getUuid());
        return processor;
    }
}

