/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.oracle.recovery.process;

import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.database.oracle.sdk.model.OracleInstance;
import com.huawei.ism.database.sdk.model.Database;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.db.util.DatabaseApplicationUtil;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.oracle.recovery.process.AdgStartupOracleSubProcessor;
import com.huawei.ism.drm.oracle.recovery.process.StartupOracleAppProcessor;
import com.huawei.ism.drm.oracle.recovery.util.OracleAppUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessSerialExecutor;
import com.huawei.ism.drm.recovery.framework.util.RecoveryProcessUtil;
import com.huawei.ism.drm.recovery.process.IProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;

public class AdgStartupOracleProcessor
extends StartupOracleAppProcessor {
    private static final Log LOGGER = LogFactory.getInstance(AdgStartupOracleProcessor.class);
    private static final long serialVersionUID = -187457383035547181L;

    public void resetEnableStatus(ProtectGroup pg, DrmEnumDefine.RecoveryPlanExecuteTypeE execType) {
        if (this.getProcType() == DrmEnumDefine.RecoveryPlanExecuteTypeE.REPROTECT.getValue()) {
            this.setIsEnabled(false);
            this.setIsEditable(false);
        } else {
            this.setIsEnabled(true);
            this.setIsEditable(false);
        }
    }

    public boolean execute(RecoveryProcessorContext context) {
        boolean isSuccess;
        if (VerifyUtil.isEmpty((Collection)this.getChildProc()) && !(isSuccess = this.createSubProcessors(context))) {
            LOGGER.error((Object)"Create AdgStartupOracleProcessor sub processor failed");
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        if (VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            LOGGER.info((Object)"AdgStartupOracleProcessor sub processors is empty.");
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            return true;
        }
        Map<Integer, List<IProcessor>> processorsWithPriority = this.getSubProcessByPriority(context);
        LOGGER.info((Object)"There are %s Priorities.", new Object[]{String.valueOf(processorsWithPriority.entrySet().size())});
        DrmEnumDefine.RecoveryPlanExecuteTypeE type = DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)this.getProcType());
        RecoveryProcessSerialExecutor recoveryTemplate = RecoveryProcessUtil.createSerialExecutorWithSerialSubExecutor(processorsWithPriority, (DrmEnumDefine.RecoveryPlanExecuteTypeE)type, (boolean)true);
        if (recoveryTemplate == null) {
            LOGGER.error((Object)"AdgStartupOracleProcessor recoveryTemplate is empty.");
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            return true;
        }
        recoveryTemplate.process(context);
        DrmEnumDefine.RecoveryPlanExecuteResultE procStatus = this.calcProcStatusBySubProc(this.getChildProc());
        this.setProcStatus(procStatus.getValue());
        return DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue() != procStatus.getValue() && DrmEnumDefine.RecoveryPlanExecuteResultE.PART_SUCCESS.getValue() != procStatus.getValue();
    }

    @Override
    protected boolean createSubProcessors(RecoveryProcessorContext context) {
        HashSet<AdgStartupOracleSubProcessor> startupPDBSubProcessors = new HashSet<AdgStartupOracleSubProcessor>();
        Set recoverySettings = context.getRecoveryPlan().getRecoverySettings();
        for (ProtectObject po : context.getRecoveryProtectObjects()) {
            String hostSnListS;
            Optional<Object> hostSnOption;
            boolean isStartApp = this.getIsStartApp(recoverySettings, po);
            if (!isStartApp) {
                LOGGER.info((Object)"Po(%s) no need startup app.", new Object[]{po.getName()});
                continue;
            }
            if (Arrays.asList(DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING.getValue(), DrmEnumDefine.RecoveryPlanExecuteTypeE.CLEAN_DRILLING.getValue()).contains(this.getProcType())) {
                List<String> ips = OracleAppUtil.getIpsByRecoveryContext(context);
                if (VerifyUtil.isEmpty(ips)) continue;
                hostSnOption = ips.stream().findFirst();
            } else if (DrmEnumDefine.RecoveryPlanExecuteTypeE.REPROTECT.getValue() == this.getProcType()) {
                hostSnListS = String.valueOf(context.getAttribute("standByHostList"));
                hostSnOption = Arrays.stream(hostSnListS.split(",")).findAny();
            } else {
                hostSnListS = po.getProtectGroup().getProperty("STAND_BY_HOSTSNS");
                hostSnOption = Arrays.stream(hostSnListS.split(",")).findAny();
            }
            if (!hostSnOption.isPresent()) continue;
            String hostSn = (String)hostSnOption.get();
            List<Database> databases = this.getDatabaseByProcType(hostSn, po);
            if (CollectionUtils.isEmpty(databases)) {
                LOGGER.error((Object)"Not find databases by hostSn: %s", new Object[]{hostSn});
                continue;
            }
            Database database = databases.get(0);
            ManagedObject managedObject = database.getParentMo();
            if (!(managedObject instanceof OracleInstance)) continue;
            OracleInstance dbInstance = (OracleInstance)managedObject;
            AdgStartupOracleSubProcessor processor = this.getAdgStartupOracleSubProcessor(po, hostSn, database, dbInstance);
            startupPDBSubProcessors.add(processor);
        }
        if (!VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            this.updateSubProcessors(startupPDBSubProcessors);
        } else {
            this.setChildProc(startupPDBSubProcessors);
        }
        return ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
    }

    private List<Database> getDatabaseByProcType(String hostSn, ProtectObject po) {
        List<Object> databases = new ArrayList<Database>();
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING.getValue() == this.getProcType() || DrmEnumDefine.RecoveryPlanExecuteTypeE.CLEAN_DRILLING.getValue() == this.getProcType()) {
            List<String> instanceNames = this.getInstanceNames(po);
            for (String instanceName : instanceNames) {
                HashMap<String, String> paramMap = new HashMap<String, String>();
                paramMap.put("instanceName", instanceName);
                List databaseList = DatabaseApplicationUtil.queryAllDatabaseInstance((String)hostSn, (int)1, paramMap);
                if (VerifyUtil.isEmpty((Collection)databaseList)) continue;
                databases.addAll(databaseList);
                break;
            }
        } else {
            databases = DatabaseApplicationUtil.queryDatabaseByHostSnAndDbId((String)hostSn, (String)((String)po.getProps().get("DB_ID")), (int)1);
        }
        return databases;
    }

    private List<String> getInstanceNames(ProtectObject po) {
        ArrayList<String> nameList = new ArrayList<String>();
        if (DrmEnumDefine.ProviderTypeE.HOSTGROUP.getValue() == NumberUtil.convertToInteger(po.getProps().get("PROVIDER_TYPE")).intValue()) {
            String instanceJson = (String)po.getProps().get("INSTANCENAME");
            JSONArray instanceArray = JSONArray.fromObject((Object)instanceJson);
            for (Object instance : instanceArray) {
                JSONObject instanceObj = JSONObject.fromObject(instance);
                nameList.add(instanceObj.getString("INSTANCENAME"));
            }
        } else {
            nameList.add((String)po.getProps().get("INSTANCENAME"));
        }
        return nameList;
    }

    private AdgStartupOracleSubProcessor getAdgStartupOracleSubProcessor(ProtectObject po, String hostSn, Database database, OracleInstance dbInstance) {
        AdgStartupOracleSubProcessor processor = new AdgStartupOracleSubProcessor();
        processor.setProcName(processor.getName());
        processor.setProcType(this.getProcType());
        processor.setPlanId(this.getPlanId());
        processor.setProcessId(this.getProcessId());
        processor.setParentProc((RecoveryProcessor)this);
        processor.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
        processor.setDbName(database.getName());
        processor.setInstanceName(dbInstance.getInstanceName());
        processor.setPoId(po.getUuid());
        processor.setTgtHostSn(hostSn);
        return processor;
    }

    @Override
    protected Map<Integer, List<IProcessor>> getSubProcessByPriority(RecoveryProcessorContext context) {
        Set recoverySettings = context.getRecoveryPlan().getRecoverySettings();
        Set childProcessor = this.getChildProc();
        HashMap<Integer, List<IProcessor>> processorsWithPriority = new HashMap<Integer, List<IProcessor>>();
        for (RecoveryProcessor process : childProcessor) {
            if (!(process instanceof AdgStartupOracleSubProcessor)) continue;
            AdgStartupOracleSubProcessor subProcess = (AdgStartupOracleSubProcessor)process;
            String poId = subProcess.getPoId();
            int priValue = this.getStartPrimary(recoverySettings, poId);
            if (processorsWithPriority.containsKey(priValue)) {
                ((List)processorsWithPriority.get(priValue)).add(process);
                continue;
            }
            ArrayList<RecoveryProcessor> processList = new ArrayList<RecoveryProcessor>();
            processList.add(process);
            processorsWithPriority.put(priValue, processList);
        }
        return processorsWithPriority;
    }
}

