/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.oracle.recovery.process;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryResourceService;
import com.huawei.ism.drm.operation.sdk.model.OperationResult;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.storage.manager.proxy.StorageLunManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageLunBaseManager;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;

public class DeleteLunMappingFromLunGroupSubProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -4347015590390832343L;
    private static Log logger = LogFactory.getInstance(DeleteLunMappingFromLunGroupSubProcessor.class);
    private static final int REPEAT_TIMES = 3;
    private static final long RETRY_INTERVAL_TIME_UNIT = 2000L;
    private String deviceId;
    private String lunId;
    private String lunWWN;
    private String lunName;
    private String hostOrGroupId;
    private String hostOrGroupName;
    private String lunGroupId;

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public final boolean execute(RecoveryProcessorContext context) {
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == this.getProcStatus()) {
            this.updateProcessNameParams(new String[]{this.getLunName(), this.getLunGroupId()});
            this.updateProcessDetail("ism.drm.recovery.lun.mapping.already.delete", new String[]{this.getLunName()});
            return true;
        }
        OperationResult result = this.deleteMappingLun();
        if (result == null) {
            throw new LegoCheckedException(1073947393L);
        }
        if (!result.isSuccess()) {
            this.updateProcessDetail("lego.err." + result.getErrorCode(), result.getArgs());
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
        } else {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        }
        return true;
    }

    protected OperationResult deleteMappingLun() {
        IRecoveryResourceService recoveryService = (IRecoveryResourceService)ServiceLocator.getInstance().getService(IRecoveryResourceService.class);
        Lun lun = recoveryService.getTargetLunById(this.getDeviceId(), this.getLunId());
        this.updateProcessNameParams(new String[]{lun.getName(), this.getLunGroupId()});
        this.setHostOrGroupName(this.getHostOrGroupName());
        this.setLunName(lun.getName());
        this.setLunWWN(lun.getWwn());
        StorageLunManagerProxy storageManagerProxy = StorageLunManagerProxy.getInstance();
        String deviceType = recoveryService.getStorageType(this.getDeviceId());
        IStorageLunBaseManager proxy = storageManagerProxy.getStorageLunMgrByDevType(deviceType);
        return this.deleteMappingLunFromStorage(proxy, this.lunGroupId);
    }

    private OperationResult deleteMappingLunFromStorage(IStorageLunBaseManager proxy, String lunGroupId) {
        OperationResult result = null;
        for (int i = 3; i > 0 && !(result = proxy.deleteLunFromLunGroup(this.getDeviceId(), this.lunId, lunGroupId)).isSuccess(); --i) {
            logger.info((Object)"DeleteMappingLunFromStorage faild: waiting for %s seconds to retry.", new Object[]{String.valueOf(i)});
            CommUtil.pauseThread((long)((long)i * 2000L));
        }
        return result;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public String getLunId() {
        return this.lunId;
    }

    public String getLunWWN() {
        return this.lunWWN;
    }

    public String getLunName() {
        return this.lunName;
    }

    public String getHostOrGroupId() {
        return this.hostOrGroupId;
    }

    public String getHostOrGroupName() {
        return this.hostOrGroupName;
    }

    public String getLunGroupId() {
        return this.lunGroupId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public void setLunId(String lunId) {
        this.lunId = lunId;
    }

    public void setLunWWN(String lunWWN) {
        this.lunWWN = lunWWN;
    }

    public void setLunName(String lunName) {
        this.lunName = lunName;
    }

    public void setHostOrGroupId(String hostOrGroupId) {
        this.hostOrGroupId = hostOrGroupId;
    }

    public void setHostOrGroupName(String hostOrGroupName) {
        this.hostOrGroupName = hostOrGroupName;
    }

    public void setLunGroupId(String lunGroupId) {
        this.lunGroupId = lunGroupId;
    }
}

