/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.oracle.recovery.process;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.db.recovery.process.StartupDBProcessor;
import com.huawei.ism.drm.db.recovery.process.StartupDBSubProcessor;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.host.util.DBRecoveryTools;
import com.huawei.ism.drm.oracle.recovery.process.StartupPDBProcessor;
import com.huawei.ism.drm.oracle.recovery.util.OracleCDBUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.recovery.process.IProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class StartupOracleAppProcessor
extends StartupDBProcessor {
    private static final long serialVersionUID = 4651926512405559845L;
    private static final Log LOGGER = LogFactory.getInstance(StartupOracleAppProcessor.class);

    protected boolean createSubProcessors(RecoveryProcessorContext context) {
        HashSet<Object> startupDBSubProcessors = new HashSet<Object>();
        List allPOs = DBRecoveryTools.appProtectObjectsFilter((RecoveryProcessorContext)context);
        Set recoverySettings = context.getRecoveryPlan().getRecoverySettings();
        for (ProtectObject po : allPOs) {
            boolean isStartApp = this.getIsStartApp(recoverySettings, po);
            if (!isStartApp) {
                LOGGER.info((Object)(po.getName() + " need not startup app"), -1L);
                continue;
            }
            StartupDBSubProcessor processor = this.createDBSubProccessor();
            processor.setProcName(processor.getName());
            processor.setProcType(this.getProcType());
            processor.setPlanId(this.getPlanId());
            processor.setProcessId(this.getProcessId());
            processor.setParentProc((RecoveryProcessor)this);
            processor.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
            processor.setPoId(po.getUuid());
            String dbName = this.getNewDatabaseName(context.getRecoveryPlan(), po);
            processor.setDbName(dbName);
            if (this.isCdb(po) && OracleCDBUtil.hasStartPDBs(recoverySettings, po)) {
                StartupPDBProcessor pdbProcessor = new StartupPDBProcessor(po.getUuid(), dbName);
                pdbProcessor.setProcName(pdbProcessor.getName());
                pdbProcessor.setProcType(this.getProcType());
                pdbProcessor.setPlanId(this.getPlanId());
                pdbProcessor.setProcessId(this.getProcessId());
                pdbProcessor.setParentProc((RecoveryProcessor)this);
                pdbProcessor.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
                processor.setNextProcessor((RecoveryProcessor)pdbProcessor);
                pdbProcessor.setPreviousProcessor((RecoveryProcessor)processor);
                startupDBSubProcessors.add(processor);
                startupDBSubProcessors.add((Object)pdbProcessor);
                continue;
            }
            startupDBSubProcessors.add(processor);
        }
        if (!VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            this.updateSubProcessors(startupDBSubProcessors);
        } else {
            this.setChildProc(startupDBSubProcessors);
        }
        boolean result = ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
        return result;
    }

    protected Map<Integer, List<IProcessor>> getSubProcessByPriority(RecoveryProcessorContext context) {
        Set recoverySettings = context.getRecoveryPlan().getRecoverySettings();
        Set childProcessor = this.getChildProc();
        HashMap<Integer, List<IProcessor>> processorsWithPriority = new HashMap<Integer, List<IProcessor>>();
        HashMap<String, Integer> dbStartSort = new HashMap<String, Integer>();
        for (RecoveryProcessor process : childProcessor) {
            if (!(process instanceof StartupDBSubProcessor)) continue;
            StartupDBSubProcessor subProcess = (StartupDBSubProcessor)process;
            String poId = subProcess.getPoId();
            int priValue = this.getStartPrimary(recoverySettings, poId);
            dbStartSort.put(subProcess.getDbName(), priValue);
            if (processorsWithPriority.containsKey(priValue)) {
                ((List)processorsWithPriority.get(priValue)).add(process);
                continue;
            }
            ArrayList<RecoveryProcessor> processList = new ArrayList<RecoveryProcessor>();
            processList.add(process);
            processorsWithPriority.put(priValue, processList);
        }
        for (RecoveryProcessor process : childProcessor) {
            if (!(process instanceof StartupPDBProcessor)) continue;
            String dbName = process.getString("startupPDBdbName");
            int priValue = (Integer)dbStartSort.get(dbName);
            List processList = (List)processorsWithPriority.get(priValue);
            processList.add(process);
            processorsWithPriority.put(priValue, processList);
        }
        return processorsWithPriority;
    }

    private boolean isCdb(ProtectObject po) {
        return "1".equals(po.getProps().get("IS_CDB"));
    }
}

