/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.oracle.recovery.process;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.db.recovery.process.TestConnDBProcessor;
import com.huawei.ism.drm.db.recovery.process.TestConnDBSubProcessor;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.host.util.DBRecoveryTools;
import com.huawei.ism.drm.oracle.recovery.process.TestConnOracleRACAppSubProcessor;
import com.huawei.ism.drm.oracle.recovery.process.TestConnPDBProcessor;
import com.huawei.ism.drm.oracle.recovery.process.TestConnPDBSubProcessor;
import com.huawei.ism.drm.oracle.recovery.util.OracleCDBUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.recovery.process.IProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TestConnOracleAppProcessor
extends TestConnDBProcessor {
    private static final long serialVersionUID = 1013712301506646828L;
    private static final Log LOGGER = LogFactory.getInstance(TestConnOracleAppProcessor.class);

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    protected void initInstanceNames(RecoveryProcessorContext context) {
        Set processors = this.getChildProc();
        Set protectObjects = context.getRecoveryProtectObjects();
        block0: for (RecoveryProcessor processor : processors) {
            if (processor instanceof TestConnPDBProcessor) {
                String instances = processor.getString("instances");
                String instanceName = processor.getString("instanceName");
                Set childProc = processor.getChildProc();
                for (RecoveryProcessor rp : childProc) {
                    TestConnPDBSubProcessor subPDB = (TestConnPDBSubProcessor)rp;
                    subPDB.setInstances(instances);
                    subPDB.setInstanceName(instanceName);
                }
                continue;
            }
            TestConnDBSubProcessor proc = (TestConnDBSubProcessor)processor;
            String hashCode = proc.getInstanceName();
            if (hashCode == null) continue;
            for (ProtectObject protectObject : protectObjects) {
                String instanceName = (String)protectObject.getProps().get("INSTANCENAME");
                if (instanceName == null || !hashCode.equals("" + instanceName.hashCode())) continue;
                proc.setInstances(instanceName);
                continue block0;
            }
        }
    }

    public TestConnDBSubProcessor createNewTestConnDBSubProccessor(RecoveryProcessorContext context) {
        return new TestConnOracleRACAppSubProcessor();
    }

    protected boolean calcProcessResultBySubProc() {
        boolean executeResult = super.calcProcessResultBySubProc();
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.PART_SUCCESS.getValue() == this.getProcStatus()) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            executeResult = false;
        }
        return executeResult;
    }

    protected Set<RecoveryProcessor> getStartupDBSubProcessors(RecoveryProcessorContext context) {
        HashSet<RecoveryProcessor> startupDBSubProcessors = new HashSet<RecoveryProcessor>();
        List allPOs = DBRecoveryTools.appProtectObjectsFilter((RecoveryProcessorContext)context);
        Set recoverySettings = context.getRecoveryPlan().getRecoverySettings();
        ProtectGroup protectGroup = context.getProtectGroup();
        PolicyTemplate template = protectGroup.getTemplate();
        for (ProtectObject po : allPOs) {
            String dbName;
            if (!this.needStartApp(recoverySettings, po)) {
                LOGGER.info((Object)"Need not to start check, poId: %s, poName: %s, poType: %s", new Object[]{po.getUuid(), po.getName(), po.getPoType()});
                continue;
            }
            LOGGER.info((Object)"Need to start check, poId: %s, poName: %s, poType: %s", new Object[]{po.getUuid(), po.getName(), po.getPoType()});
            TestConnDBSubProcessor processor = this.createNewTestConnDBSubProccessor(context);
            processor.setProcName(processor.getName());
            processor.setProcType(this.getProcType());
            processor.setPlanId(this.getPlanId());
            processor.setProcessId(this.getProcessId());
            processor.setParentProc((RecoveryProcessor)this);
            processor.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
            String instanceName = (String)po.getProps().get("INSTANCENAME");
            if (instanceName != null) {
                processor.setInstanceName("" + instanceName.hashCode());
                processor.setInstances(instanceName);
            }
            if ((dbName = (String)po.getProps().get("STANDBY_DB_NAME")) != null && (this.getProcType() != DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING.getValue() || template.getType() != 47)) {
                processor.setDbName(dbName);
            } else {
                processor.setDbName(po.getName());
            }
            processor.setPoId(po.getUuid());
            if (this.isCdb(po) && OracleCDBUtil.hasStartPDBs(recoverySettings, po)) {
                this.initProcess(startupDBSubProcessors, po, processor, instanceName);
                continue;
            }
            startupDBSubProcessors.add((RecoveryProcessor)processor);
        }
        return startupDBSubProcessors;
    }

    private void initProcess(Set<RecoveryProcessor> startupDBSubProcessors, ProtectObject po, TestConnDBSubProcessor processor, String instanceName) {
        String instanceNameParm = null;
        String instances = null;
        if (instanceName != null) {
            instanceNameParm = "" + instanceName.hashCode();
            instances = instanceName;
        }
        TestConnPDBProcessor pdbProcessor = new TestConnPDBProcessor(po.getUuid(), po.getName(), instanceNameParm, instances);
        pdbProcessor.setProcName(pdbProcessor.getName());
        pdbProcessor.setProcType(this.getProcType());
        pdbProcessor.setPlanId(this.getPlanId());
        pdbProcessor.setProcessId(this.getProcessId());
        pdbProcessor.setParentProc((RecoveryProcessor)this);
        pdbProcessor.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
        processor.setNextProcessor((RecoveryProcessor)pdbProcessor);
        pdbProcessor.setPreviousProcessor((RecoveryProcessor)processor);
        startupDBSubProcessors.add((RecoveryProcessor)processor);
        startupDBSubProcessors.add((RecoveryProcessor)pdbProcessor);
    }

    protected Map<Integer, List<IProcessor>> getSubProcessByPriority(RecoveryProcessorContext context) {
        Set recoverySettings = context.getRecoveryPlan().getRecoverySettings();
        Set childProcessor = this.getChildProc();
        HashMap<Integer, List<IProcessor>> processorsWithPriority = new HashMap<Integer, List<IProcessor>>();
        HashMap<String, Integer> dbStartSort = new HashMap<String, Integer>();
        for (RecoveryProcessor process : childProcessor) {
            if (!(process instanceof TestConnDBSubProcessor)) continue;
            TestConnDBSubProcessor subProcess = (TestConnDBSubProcessor)process;
            String poId = subProcess.getPoId();
            int priValue = this.getStartPrimary(recoverySettings, poId);
            dbStartSort.put(subProcess.getDbName(), priValue);
            if (processorsWithPriority.containsKey(priValue)) {
                ((List)processorsWithPriority.get(priValue)).add(process);
                continue;
            }
            ArrayList<RecoveryProcessor> processList = new ArrayList<RecoveryProcessor>();
            processList.add(process);
            processorsWithPriority.put(priValue, processList);
        }
        for (RecoveryProcessor process : childProcessor) {
            if (!(process instanceof TestConnPDBProcessor)) continue;
            String dbName = process.getString("testPDBdbName");
            LOGGER.info((Object)("TestConnPDBProcessor dbName:" + dbName));
            int priValue = (Integer)dbStartSort.get(dbName);
            List processList = (List)processorsWithPriority.get(priValue);
            processList.add(process);
            processorsWithPriority.put(priValue, processList);
        }
        return processorsWithPriority;
    }

    private boolean isCdb(ProtectObject po) {
        if (null == po) {
            LOGGER.info((Object)"po is null.");
            return false;
        }
        return "1".equals(po.getProps().get("IS_CDB"));
    }
}

