/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.oracle.recovery.util;

import com.huawei.ism.array.sdk.model.HvsProtectionGroup;
import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.cbb.base.dao.IMoDao;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.discover.sdk.service.INeMgrProtocolExtendService;
import com.huawei.ism.cbb.util.CommonComparator;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.database.oracle.sdk.model.OracleDatabase;
import com.huawei.ism.database.oracle.sdk.model.OracleInstance;
import com.huawei.ism.database.sdk.model.Database;
import com.huawei.ism.database.sdk.model.DatabaseInstance;
import com.huawei.ism.drm.app.util.JsonUtil;
import com.huawei.ism.drm.application.adapter.sdk.service.IApplicationManager;
import com.huawei.ism.drm.application.manager.proxy.ApplicationAdapterProxy;
import com.huawei.ism.drm.application.model.AppStorageInfo;
import com.huawei.ism.drm.base.util.AlarmReporter;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.db.util.DatabaseApplicationUtil;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.model.RecoverySetting;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanService;
import com.huawei.ism.drm.host.sdk.model.DrHost;
import com.huawei.ism.drm.host.sdk.model.DrHostGroup;
import com.huawei.ism.drm.host.sdk.service.IHostGroupService;
import com.huawei.ism.drm.host.util.DBRecoveryTools;
import com.huawei.ism.drm.host.util.DrHostUtil;
import com.huawei.ism.drm.host.util.ProtectObjectAppUtil;
import com.huawei.ism.drm.oracle.adapter.service.impl.OracleManagerImpl;
import com.huawei.ism.drm.oracle.constant.OracleConst;
import com.huawei.ism.drm.oracle.hostagent.action.OracleAction;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.ism.drm.storage.manager.proxy.StorageProtectGroupManagerProxy;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.ism.drm.storage.sdk.service.IStorageService;
import com.huawei.ism.drm.util.CastUtil;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.base.ServiceContext;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

public final class OracleAppUtil {
    private static final int MAX_HOST = 8;
    private static final int ERR_INDEX = -1;
    private static final String IS_PDB = "1";
    private static final String IS_CDB = "1";
    private static final List<String> DISK_TYPE_LIST = Arrays.asList("REDO", "DATA");
    private static final Log LOGGER = LogFactory.getInstance(OracleAppUtil.class);

    private OracleAppUtil() {
    }

    public static ProtectObject findPoById(Set<ProtectObject> pos, String poId) {
        if (pos == null) {
            LOGGER.error((Object)"pos is null.");
            return null;
        }
        for (ProtectObject po : pos) {
            if (!po.getUuid().equals(poId)) continue;
            return po;
        }
        return null;
    }

    public static DrHostGroup getRecoveryHostGroup(RecoveryPlan recoveryPlan) {
        DrHostGroup recHostGroup;
        if (recoveryPlan == null) {
            LOGGER.error((Object)"RecoveryPlan is null.");
            return null;
        }
        DrHostGroup hostGroup = null;
        String hostGroupSn = (String)recoveryPlan.getGlobalSettings().get("PO_DISASTER_HOST");
        List hostGroups = OracleAppUtil.getHostGroupService().getHostGroupListByDeviceSN(hostGroupSn);
        if (!VerifyUtil.isEmpty((Collection)hostGroups) && !VerifyUtil.isEmpty((Object)(recHostGroup = (DrHostGroup)hostGroups.get(0)))) {
            hostGroup = recHostGroup;
        }
        return hostGroup;
    }

    public static void filterHasSuccHosts(Set<DrResource> hostsOfHostGroup, String succHosts, int procType) {
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING.getValue() != procType) {
            LOGGER.error((Object)"ProcType is not drilling.");
            return;
        }
        if (null == succHosts) {
            LOGGER.error((Object)"The succHosts is null.");
            return;
        }
        if (null == hostsOfHostGroup) {
            LOGGER.error((Object)"The hostsOfHostGroup is null.");
            return;
        }
        ArrayList<DrResource> hasSuccHosts = new ArrayList<DrResource>(8);
        for (DrResource host : hostsOfHostGroup) {
            if (-1 == succHosts.indexOf(host.getIpAddress())) continue;
            hasSuccHosts.add(host);
        }
        hostsOfHostGroup.removeAll(hasSuccHosts);
    }

    public static DrmEnumDefine.RecoveryPlanExecuteResultE getProcResultBySubProc(Set<RecoveryProcessor> rProcesses) {
        if (rProcesses == null) {
            LOGGER.error((Object)"The rProcesses is null.");
            return DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED;
        }
        boolean hasFailed = false;
        boolean hasPartSuccessed = false;
        boolean hasSuccess = false;
        for (RecoveryProcessor process : rProcesses) {
            if (DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue() == process.getProcStatus()) {
                hasFailed = true;
                continue;
            }
            if (DrmEnumDefine.RecoveryPlanExecuteResultE.PART_SUCCESS.getValue() == process.getProcStatus()) {
                hasPartSuccessed = true;
                continue;
            }
            if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() != process.getProcStatus()) continue;
            hasSuccess = true;
        }
        DrmEnumDefine.RecoveryPlanExecuteResultE procStatus = hasPartSuccessed ? DrmEnumDefine.RecoveryPlanExecuteResultE.PART_SUCCESS : (hasFailed && hasSuccess ? DrmEnumDefine.RecoveryPlanExecuteResultE.PART_SUCCESS : (hasSuccess ? DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS : DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED));
        return procStatus;
    }

    public static void setResult(StringBuffer succHostsSb, String resSN, String resultOfLastTime) {
        if (null == succHostsSb) {
            LOGGER.error((Object)"The succHostsSb is null.");
            return;
        }
        if (null == resultOfLastTime) {
            if (0 != succHostsSb.length()) {
                succHostsSb.append(',');
            }
            succHostsSb.append(resSN);
        } else if (-1 == resultOfLastTime.indexOf(resSN)) {
            if (0 != succHostsSb.length()) {
                succHostsSb.append(',');
            }
            succHostsSb.append(resSN);
        }
    }

    public static String getResult(String resIPAddress, String resultOfLastTime) {
        if (null == resultOfLastTime) {
            resultOfLastTime = resIPAddress;
        } else if (-1 == resultOfLastTime.indexOf(resIPAddress)) {
            resultOfLastTime = resultOfLastTime + ",";
            resultOfLastTime = resultOfLastTime + resIPAddress;
        }
        LOGGER.debug((Object)"get result.");
        return resultOfLastTime;
    }

    public static DatabaseInstance getOracleInstanceByHostAndName(String host, String name) {
        if (name == null) {
            LOGGER.error((Object)"Query instance fail,name is null.");
            return null;
        }
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("dbType", 1);
        props.put("hostSN", host);
        List instances = CommonDAOLocator.getMoDao().findMoBy(DatabaseInstance.class, "name", true, props);
        if (VerifyUtil.isEmpty((Collection)instances)) {
            return null;
        }
        for (DatabaseInstance instance : instances) {
            HashMap<String, Long> args = new HashMap<String, Long>();
            args.put("parentMo.moId", instance.getMoId());
            List databases = CommonDAOLocator.getMoDao().findMoBy(Database.class, "name", true, args);
            if (VerifyUtil.isEmpty((Collection)databases)) continue;
            for (Database database : databases) {
                if (!name.equalsIgnoreCase(database.getName())) continue;
                return instance;
            }
        }
        return null;
    }

    public static List<DatabaseInstance> getOracleInstancesByGroupAndName(String group, String name) {
        ArrayList<DatabaseInstance> instances = new ArrayList<DatabaseInstance>();
        List<String> hosts = OracleAppUtil.getHostGroupListByDeviceSN(group);
        if (VerifyUtil.isEmpty(hosts)) {
            return instances;
        }
        for (String host : hosts) {
            DatabaseInstance instance = OracleAppUtil.getOracleInstanceByHostAndName(host, name);
            if (instance == null) continue;
            instances.add(instance);
        }
        LOGGER.debug((Object)"Get oracle instances by groupAndName.");
        return instances;
    }

    public static List<String> getHostGroupListByDeviceSN(String hostGrpSn) {
        ArrayList<String> hostSNList = new ArrayList<String>();
        IHostGroupService hostGroupService = (IHostGroupService)ServiceContext.getInstance().lookup("DRM_Host/" + IHostGroupService.class.getName());
        List drGroups = hostGroupService.getHostGroupListByDeviceSN(hostGrpSn);
        for (DrHostGroup group : drGroups) {
            for (DrResource host : group.getChildResources()) {
                hostSNList.add(host.getDeviceSn());
            }
        }
        hostSNList.sort(Comparator.reverseOrder());
        LOGGER.debug((Object)"Get HostGroup list by DeviceSN.");
        return hostSNList;
    }

    private static IHostGroupService getHostGroupService() {
        return (IHostGroupService)ServiceContext.getInstance().lookup("DRM_Host/" + IHostGroupService.class.getName());
    }

    public static void startOracleDatabase(ProtectObject protectObject, NeMgrProtocolExtend extend) {
        if ("1".equals(protectObject.getProps().get("IS_PDB"))) {
            OracleAppUtil.startPDB(protectObject, extend);
        } else {
            String cluster = (String)protectObject.getProps().get("IS_CLUSTER");
            if ("1".equals(protectObject.getProps().get("IS_ASM")) && !"1".equals(cluster)) {
                LOGGER.debug((Object)"Start asm: %s", new Object[]{protectObject.getProviderSN()});
                OracleAction action = new OracleAction(extend, (String)extend.getExtendParams().get("mac_address"));
                action.startAsmInstance(protectObject.getProps());
            }
            LOGGER.debug((Object)"Start dbName: %s, providerSn: %s", new Object[]{protectObject.getName(), protectObject.getProviderSN()});
            Map params = protectObject.getProps();
            OracleAction action = new OracleAction(extend, (String)extend.getExtendParams().get("mac_address"));
            action.startDatabase(params);
        }
    }

    public static void stopOracleDatabase(ProtectObject protectObject, NeMgrProtocolExtend extend) {
        LOGGER.debug((Object)"Stop oracle database.");
        OracleAction action = new OracleAction(extend, (String)extend.getExtendParams().get("mac_address"));
        Map params = protectObject.getProps();
        action.stopDatabase(params);
    }

    public static void stopAsmInstance(ProtectObject protectObject, NeMgrProtocolExtend extend) {
        LOGGER.debug((Object)"Stop asm instance.");
        OracleAction action = new OracleAction(extend, (String)extend.getExtendParams().get("mac_address"));
        Map params = protectObject.getProps();
        action.stopAsmInstance(params);
    }

    public static void testConnection(ProtectObject protectObject, NeMgrProtocolExtend extend) {
        if ("1".equals(protectObject.getProps().get("IS_PDB"))) {
            OracleAppUtil.testPDB(protectObject, extend);
        } else {
            LOGGER.debug((Object)"Test oracle connection.");
            OracleAction action = new OracleAction(extend, (String)extend.getExtendParams().get("mac_address"));
            Map params = protectObject.getProps();
            action.testConnection(params);
        }
    }

    public static void freezeOracle(ProtectObject protectObject, NeMgrProtocolExtend extend) {
        LOGGER.debug((Object)"Freeze oracle.");
        OracleAction action = new OracleAction(extend, (String)extend.getExtendParams().get("mac_address"));
        Map params = protectObject.getProps();
        action.freeze(params);
    }

    public static void thrawOracle(ProtectObject protectObject, NeMgrProtocolExtend extend) {
        LOGGER.debug((Object)"Thraw oracle.");
        OracleAction action = new OracleAction(extend, (String)extend.getExtendParams().get("mac_address"));
        Map params = protectObject.getProps();
        action.thraw(params);
    }

    public static void forcedArchive(ProtectObject protectObject, NeMgrProtocolExtend extend) {
        LOGGER.debug((Object)"Forced archive.");
        OracleAction action = new OracleAction(extend, (String)extend.getExtendParams().get("mac_address"));
        Map params = protectObject.getProps();
        action.forcedArchive(params);
    }

    public static void updateProtectObjectInstanceAndServiceName(ProtectObject po) {
        Map poProps = po.getProps();
        poProps.put("INSTANCENAME", "");
        poProps.put("SERVICENAME", "");
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("topMoUuid", po.getProviderSN());
        props.put("name", po.getName());
        IMoDao moDao = CommonDAOLocator.getMoDao();
        List databases = moDao.findMoBy(OracleDatabase.class, "name", true, props);
        if (VerifyUtil.isEmpty((Collection)databases)) {
            LOGGER.error((Object)"Databases is empty, po name: %s, hostSn: %s", new Object[]{po.getName(), po.getProviderSN()});
            DrResource resource = ((IResourceService)ServiceLocator.getInstance().getService(IResourceService.class)).getDrResourceBySn(po.getProviderSN());
            throw new LegoCheckedException(1073948189L, new String[]{resource.getName(), resource.getName()});
        }
        ManagedObject mo = ((OracleDatabase)databases.get(0)).getParentMo();
        if (!(mo instanceof OracleInstance)) {
            LOGGER.error((Object)"Not find the right mo.");
            throw new LegoCheckedException(1073947394L);
        }
        OracleInstance oracleInstance = (OracleInstance)mo;
        poProps.put("INSTANCENAME", oracleInstance.getInstanceName());
        poProps.put("SERVICENAME", oracleInstance.getServiceName());
        if (VerifyUtil.isEmpty((String)((String)poProps.get("INSTANCENAME")))) {
            DrResource resource = ((IResourceService)ServiceLocator.getInstance().getService(IResourceService.class)).getDrResourceBySn(po.getProviderSN());
            LOGGER.error((Object)"The po's props when key is INSTANCENAME, the value is null, poName: %s, poProviderSn: %s", new Object[]{po.getName(), po.getProviderSN()});
            throw new LegoCheckedException(1073948189L, new String[]{resource.getName(), resource.getName()});
        }
    }

    public static void updatePoPropsWithStandbyAfterSwitchover(ProtectObject po) {
        List databases;
        String hostSn = po.getProviderSN();
        ProtectObject poInDb = ProtectObjectAppUtil.getProtectObjectByPoUUID((String)po.getUuid());
        int type = poInDb.getProtectGroup().getTemplate().getType();
        if (type == 47) {
            String dbId = (String)po.getProps().get("DB_ID");
            if (VerifyUtil.isEmpty((String)dbId)) {
                LOGGER.warn((Object)"Can not find dbId in protect object:%s", new Object[]{po.getName()});
            }
            databases = DatabaseApplicationUtil.queryDatabaseByHostSnAndDbId((String)hostSn, (String)dbId, (int)1);
        } else {
            databases = DatabaseApplicationUtil.queryAllDatabaseInstance((String)hostSn, (int)1, new HashMap());
        }
        if (CollectionUtils.isEmpty((Collection)databases)) {
            LOGGER.error((Object)"Not find the databases.");
            return;
        }
        for (Database database : databases) {
            ManagedObject mo = database.getParentMo();
            if (!(mo instanceof OracleInstance)) {
                LOGGER.error((Object)"Not the right type for change.");
                continue;
            }
            OracleInstance oracleInstance = (OracleInstance)database.getParentMo();
            String instanceName = "";
            if (String.valueOf(DrmEnumDefine.ProviderTypeE.HOSTGROUP.getValue()).equals(po.getProps().get("PROVIDER_TYPE"))) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put((Object)"ip", (Object)hostSn);
                jsonObject.put((Object)"INSTANCENAME", (Object)oracleInstance.getInstanceName());
                instanceName = new JSONArray(new Object[]{jsonObject}).toString();
            } else {
                instanceName = oracleInstance.getInstanceName();
            }
            po.setName(database.getName());
            Map poProps = po.getProps();
            poProps.put("DATABASES", database.getName());
            poProps.put("IS_ASM", oracleInstance.getUseAsm() != false ? "1" : "0");
            poProps.put("SERVICENAME", oracleInstance.getServiceName());
            poProps.put("INSTANCENAME", instanceName);
            poProps.put("VERSION", oracleInstance.getDbVersion());
            poProps.put("ORACLE_HOME", oracleInstance.getOracleHome());
        }
    }

    public static ProtectObject clone(ProtectObject po) {
        ProtectObject obj = new ProtectObject();
        obj.setUuid(po.getUuid());
        obj.setMoUuid(po.getMoUuid());
        obj.setName(po.getName());
        obj.getProps().putAll(po.getProps());
        obj.getUsedStorageResourceSet().addAll(po.getUsedStorageResourceSet());
        obj.setProviderSN(po.getProviderSN());
        obj.setPoType(po.getPoType());
        LOGGER.debug((Object)"Clone oracle po.");
        return obj;
    }

    public static void updateProtectObjectInstance(ProtectObject newPo, ProtectObject oldPo) {
        String instanceNames = (String)oldPo.getProps().get("INSTANCENAME");
        if (VerifyUtil.isEmpty((String)instanceNames)) {
            LOGGER.error((Object)"Not find any instanceNames.");
            return;
        }
        JSONArray instanceArray = JSONArray.fromObject((Object)instanceNames);
        for (Object obj : instanceArray) {
            JSONObject jsonObject = JSONObject.fromObject(obj);
            String instanceName = JsonUtil.getString((JSONObject)jsonObject, (String)"INSTANCENAME", (String[])new String[]{""});
            String hostSn = JsonUtil.getString((JSONObject)jsonObject, (String)"ip", (String[])new String[]{""});
            if (VerifyUtil.isEmpty((String)instanceName) || VerifyUtil.isEmpty((String)hostSn)) continue;
            newPo.getProps().put("INSTANCENAME", instanceName);
            newPo.getProps().put("hostSn", hostSn);
            break;
        }
    }

    public static void getPrdHostTmpPoList(List<ProtectObject> list, ProtectObject oldPo) {
        String instanceNames = (String)oldPo.getProps().get("INSTANCENAME");
        if (VerifyUtil.isEmpty((String)instanceNames)) {
            LOGGER.error((Object)"Not find any instanceNames.");
            return;
        }
        JSONArray instanceArray = JSONArray.fromObject((Object)instanceNames);
        for (Object obj : instanceArray) {
            JSONObject jsonObject = JSONObject.fromObject(obj);
            String instanceName = JsonUtil.getString((JSONObject)jsonObject, (String)"INSTANCENAME", (String[])new String[]{""});
            String hostSn = JsonUtil.getString((JSONObject)jsonObject, (String)"ip", (String[])new String[]{""});
            if (VerifyUtil.isEmpty((String)instanceName) || VerifyUtil.isEmpty((String)hostSn)) continue;
            ProtectObject tmp = OracleAppUtil.clone(oldPo);
            tmp.getProps().put("INSTANCENAME", instanceName);
            tmp.getProps().put("hostSn", hostSn);
            tmp.getProps().put("PROVIDER_TYPE", String.valueOf(DrmEnumDefine.ProviderTypeE.HOST.getValue()));
            tmp.setProviderSN(hostSn);
            OracleAppUtil.checkAuthorityParameters(tmp);
            list.add(tmp);
        }
    }

    public static void getDisasterHostTmpPoList(List<ProtectObject> list, ProtectObject po) {
        ProtectGroup protectGroup = po.getProtectGroup();
        String standbyHostSns = (String)protectGroup.getProps().get("STAND_BY_HOSTSNS");
        String dbId = (String)po.getProps().get("DB_ID");
        String standbyDbName = (String)po.getProps().get("STANDBY_DB_NAME");
        for (String sn : standbyHostSns.split(",")) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("hostSN", sn);
            params.put("dbId", dbId);
            List instances = CommonDAOLocator.getMoDao().findMoBy(DatabaseInstance.class, params);
            if (instances.isEmpty()) continue;
            ProtectObject tempPo = OracleAppUtil.clone(po);
            tempPo.getProps().put("INSTANCENAME", ((DatabaseInstance)instances.get(0)).getInstanceName());
            tempPo.getProps().put("DATABASES", standbyDbName);
            tempPo.setName(standbyDbName);
            tempPo.getProps().put("hostSn", sn);
            tempPo.getProps().put("PROVIDER_TYPE", String.valueOf(DrmEnumDefine.ProviderTypeE.HOST.getValue()));
            tempPo.setProviderSN(sn);
            OracleAppUtil.checkAuthorityParameters(tempPo);
            list.add(tempPo);
        }
    }

    public static List<ProtectObject> buildProtectObjects(ProtectObject po) {
        ArrayList<ProtectObject> protectObjects = new ArrayList<ProtectObject>();
        if (DrmEnumDefine.ProviderTypeE.HOSTGROUP.getValue() == NumberUtil.convertToInteger(po.getProps().get("PROVIDER_TYPE")).intValue()) {
            OracleAppUtil.appendProjectObject(po, protectObjects);
        } else {
            protectObjects.add(po);
        }
        if (protectObjects.isEmpty()) {
            LOGGER.error((Object)"Build po(name: %s, providerSn: %s) result is empty.", new Object[]{po.getName(), po.getProviderSN()});
            throw new LegoCheckedException(1073947393L, "the po list is empty.");
        }
        return protectObjects;
    }

    private static void appendProjectObject(ProtectObject po, List<ProtectObject> freezePos) {
        String sn = po.getProviderSN();
        String activeHostSn = (String)po.getProps().get("ACTIVE_NODE_HOST_SN");
        DrResource drResource = ((IResourceService)ServiceLocator.getInstance().getService(IResourceService.class)).getDrResourceBySn(sn);
        if (drResource instanceof DrHostGroup && !VerifyUtil.isEmpty((String)activeHostSn)) {
            LOGGER.debug((Object)"The active HostSn: %s, host size: %s, poName: %s", new Object[]{activeHostSn, drResource.getChildResources().size(), po.getName()});
            for (DrResource childDrResource : drResource.getChildResources()) {
                if (!activeHostSn.equals(childDrResource.getDeviceSn())) continue;
                LOGGER.debug((Object)"The poName: %s, activeHostSn: %s, ip is: %s", new Object[]{po.getName(), activeHostSn, childDrResource.getIpAddress()});
                drResource = childDrResource;
                break;
            }
        }
        OracleAppUtil.generateFreezePos(po, freezePos, drResource);
    }

    private static void generateFreezePos(ProtectObject po, List<ProtectObject> freezePos, DrResource drResource) {
        if (drResource instanceof DrHost) {
            ProtectObject clonePo = OracleAppUtil.clone(po);
            clonePo.setProviderSN(drResource.getDeviceSn());
            OracleAppUtil.updateProtectObjectInstanceAndServiceName(clonePo);
            freezePos.add(clonePo);
            return;
        }
        try {
            freezePos.addAll(OracleAppUtil.decodePOInstanceAndServiceName(po, (DrHostGroup)drResource));
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("Get freeze po failed for host group,po:" + po.getName() + "," + po.getProviderSN()), (long)1073947393L, null, (Log)LOGGER);
        }
    }

    private static List<ProtectObject> decodePOInstanceAndServiceName(ProtectObject po, DrHostGroup hostGroup) {
        ArrayList<ProtectObject> result = new ArrayList<ProtectObject>();
        for (DrResource childResource : hostGroup.getChildResources()) {
            ProtectObject clonePo = OracleAppUtil.clone(po);
            clonePo.setProviderSN(childResource.getDeviceSn());
            OracleAppUtil.updateProtectObjectInstanceAndServiceName(clonePo);
            result.add(clonePo);
        }
        result.sort((Comparator<ProtectObject>)new CommonComparator("providerSN", true));
        return result;
    }

    public static void checkOperationParameters(ProtectObject po) {
        OracleAppUtil.checkAuthorityParameters(po);
        if (null == po.getUsedStorageResourceSet() || po.getUsedStorageResourceSet().isEmpty()) {
            LOGGER.error((Object)"The po's UsedStorageResourceSet is null, poName = %s", new Object[]{po.getName()});
            throw new LegoCheckedException(1073947393L);
        }
    }

    public static void checkAuthorityParameters(ProtectObject po) {
        OracleAppUtil.checkBaseParameters(po);
        Map props = po.getProps();
        if (null == props.get("INSTANCENAME") || null == props.get("SERVICENAME")) {
            LOGGER.error((Object)"The po's instanceName or service name not exists, poName: %s, providerSn: %s", new Object[]{po.getName(), po.getProviderSN()});
            throw new LegoCheckedException(1073947393L);
        }
        if (!"1".equals(props.get("IS_ASM"))) {
            props.put("ASM_INSTANCENAME", "");
        }
        String authType = (String)props.get("AUTH_TYPE");
        String isCloseAsm = (String)props.get("IS_CLOSE_ASM");
        OracleAppUtil.checkAndUpdateProps(po, authType, isCloseAsm);
    }

    public static void updateAuthProps(Map<String, String> params, ProtectObject po) {
        if (params == null || VerifyUtil.isEmpty((Object)po) || VerifyUtil.isEmpty((Map)po.getProps())) {
            LOGGER.debug((Object)"Params is empty");
            return;
        }
        if ("0".equals(po.getProps().get("AUTH_TYPE"))) {
            params.put("USERNAME", (String)po.getProps().get("USERNAME"));
            params.put("PASSWD", (String)po.getProps().get("PASSWD"));
            if ("1".equals(po.getProps().get("IS_ASM"))) {
                params.put("ASM_USERNAME", (String)po.getProps().get("ASM_USERNAME"));
                params.put("ASM_PASSWD", (String)po.getProps().get("ASM_PASSWD"));
            }
        }
    }

    private static void checkAndUpdateProps(ProtectObject po, String authType, String isCloseAsm) {
        Map props = po.getProps();
        if (authType != null && "1".equals(authType)) {
            props.put("USERNAME", "");
            props.put("PASSWD", "");
            props.put("ASMGroupName", "");
            props.put("PROP_KEY_ASM_IS_CHANGED", "");
            props.put("ASM_USERNAME", "");
            props.put("ASM_PASSWD", "");
        } else {
            if (!("1".equals(isCloseAsm) || null != props.get("USERNAME") && null != props.get("PASSWD"))) {
                LOGGER.error((Object)"The po's username or password not exists, poName: %s, providerSn: %s", new Object[]{po.getName(), po.getProviderSN()});
                throw new LegoCheckedException(1073947393L);
            }
            if ("1".equals(isCloseAsm) && (null == props.get("ASM_PASSWD") || null == props.get("ASM_USERNAME"))) {
                LOGGER.error((Object)"The po's asm username or password not exists,poName: %s, providerSn: %s", new Object[]{po.getName(), po.getProviderSN()});
                throw new LegoCheckedException(1073947393L);
            }
        }
    }

    private static void checkBaseParameters(ProtectObject po) {
        if (null == po) {
            LOGGER.error((Object)"Po is null.");
            throw new LegoCheckedException(1073947393L);
        }
        if (1 != po.getPoType()) {
            LOGGER.error((Object)"Po's type is wrong,po: %s, %s", new Object[]{po.getName(), po.getProviderSN()});
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((String)po.getProviderSN())) {
            LOGGER.error((Object)"Po's ProviderSN is null,po: %s", new Object[]{po.getName()});
            throw new LegoCheckedException(1073947393L);
        }
    }

    public static ProtectObject getOperateParam(ProtectObject po) {
        Map props;
        ProtectGroup protectGroup;
        ProtectObject result = new ProtectObject();
        result.setPoType(1);
        result.setProviderSN(po.getProviderSN());
        result.getProps().putAll(po.getProps());
        HashSet<String> asmGroupName = new HashSet<String>();
        for (ProtectObjectStorageInfo info : po.getUsedStorageResourceSet()) {
            String groupName = info.getAsmDiskGroupName();
            if (!VerifyUtil.isEmpty((String)groupName)) {
                asmGroupName.add(groupName);
            }
            ProtectObjectStorageInfo paramInfo = new ProtectObjectStorageInfo();
            paramInfo.setDeviceName(info.getDeviceName());
            paramInfo.setMountPoint(info.getMountPoint());
            paramInfo.setStorageSubType(info.getStorageSubType());
            paramInfo.setStorageType(info.getStorageType());
            paramInfo.setVolumeGroupName(info.getVolumeGroupName());
            result.addHostStorageResourceInfo(paramInfo);
        }
        Integer isAsm = NumberUtil.convertToInteger(po.getProps().get("IS_ASM"));
        if (1 == isAsm && !VerifyUtil.isEmpty(asmGroupName)) {
            result.getProps().put("ASMGroupName", OracleAppUtil.generateASMGroupName(asmGroupName));
        }
        PolicyTemplate template = (protectGroup = po.getProtectGroup()) != null ? protectGroup.getTemplate() : null;
        Map map = props = template != null ? template.getProps() : null;
        if (props != null) {
            result.getProps().put("ORACLE_CAP_THREASHOLD", props.get("ORACLE_CAP_THREASHOLD"));
        } else {
            LOGGER.info((Object)"The template props of po(%s, %s, %s) is null", new Object[]{po.getName(), po.getProviderSN(), po.getUuid()});
        }
        return result;
    }

    private static String generateASMGroupName(Set<String> asmGroupName) {
        StringBuilder buffer = new StringBuilder();
        for (String tmp : asmGroupName) {
            buffer.append(tmp);
            buffer.append('+');
        }
        return buffer.substring(0, buffer.length() - 1);
    }

    public static boolean isProtectArchieveLog(Set<ProtectObject> protectObjectList) {
        if (VerifyUtil.isEmpty(protectObjectList)) {
            LOGGER.error((Object)"ProtectObjectList is null.");
            return false;
        }
        for (ProtectObject protectObject : protectObjectList) {
            String archieve = (String)protectObject.getProps().get("ARCHIVE_LOG");
            if (!"1".equals(archieve)) continue;
            LOGGER.debug((Object)"Protect archive log,po: %s", new Object[]{protectObject.getName()});
            return true;
        }
        LOGGER.debug((Object)"Not protect archive log.");
        return false;
    }

    public static boolean getIsStartApp(Set<RecoverySetting> recoverySettings, ProtectObject po) {
        boolean isStartApp = true;
        for (RecoverySetting rs : recoverySettings) {
            if (!rs.getName().equals("isStart") || !rs.getOwnerId().equals(po.getUuid())) continue;
            isStartApp = Boolean.parseBoolean(rs.getValue());
            break;
        }
        LOGGER.debug((Object)"Get IsStart App.");
        return isStartApp;
    }

    public static void queryPlugDatabase(ProtectObject po) {
        INeMgrProtocolExtendService neMgr = (INeMgrProtocolExtendService)ServiceLocator.getInstance().getService(INeMgrProtocolExtendService.class);
        NeMgrProtocolExtend ne = DrHostUtil.getNeMgrProtocolExtend((INeMgrProtocolExtendService)neMgr, (String)po.getProviderSN());
        OracleAction action = new OracleAction(ne, po.getProviderSN());
        String result = action.queryDatabaseAuth(po.getProps());
        if (VerifyUtil.isEmpty((String)result)) {
            LOGGER.error((Object)"query database isCDB fail, instanceName is %s and providerSN is %s", new Object[]{po.getProps().get("INSTANCENAME"), po.getProviderSN()});
            throw new LegoCheckedException(-1L);
        }
        JSONObject json = JSONObject.fromObject((Object)result);
        String isCdb = json.getString("type");
        po.getProps().put("IS_CDB", isCdb);
        if (!"1".equals(isCdb)) {
            LOGGER.debug((Object)"this database is not pdb, instance name is %s", new Object[]{po.getProps().get("INSTANCENAME")});
            return;
        }
        String pdbs = action.queryPlugDatabase(po.getProps());
        if (VerifyUtil.isEmpty((String)pdbs)) {
            LOGGER.error((Object)"Query pdbs failed, instanceName is %s and providerSN is %s", new Object[]{po.getProps().get("INSTANCENAME"), po.getProviderSN()});
            throw new LegoCheckedException(-1L);
        }
        po.getProps().put("PDB", pdbs);
    }

    private static void startPDB(ProtectObject protectObject, NeMgrProtocolExtend extend) {
        Map params = protectObject.getProps();
        OracleAction action = new OracleAction(extend, (String)extend.getExtendParams().get("mac_address"));
        action.startPDB(params);
    }

    private static void testPDB(ProtectObject protectObject, NeMgrProtocolExtend extend) {
        Map params = protectObject.getProps();
        OracleAction action = new OracleAction(extend, (String)extend.getExtendParams().get("mac_address"));
        action.testPDB(params);
    }

    public static Set<String> getNeedCheckHosts() {
        ISiteService siteService = (ISiteService)ServiceLocator.getInstance().getService(ISiteService.class);
        List allLocalSites = siteService.getAllLocalSites();
        allLocalSites = Optional.ofNullable(allLocalSites).orElseGet(Collections::emptyList);
        HashSet<String> hostSns = new HashSet<String>();
        for (Site localSite : allLocalSites) {
            List allHostResource = siteService.getAllResourceBySite(localSite.getSiteId(), "ism.drm.deviceType.drhost.mainType");
            allHostResource = Optional.ofNullable(allHostResource).orElseGet(Collections::emptyList);
            allHostResource.stream().map(DrResource::getDeviceSn).forEach(hostSns::add);
        }
        return hostSns;
    }

    public static void restorePreparePDB(ProtectObject protectObject, NeMgrProtocolExtend extend) {
        Map params = protectObject.getProps();
        OracleAction action = new OracleAction(extend, (String)extend.getExtendParams().get("mac_address"));
        action.replaceUdevRule(params);
    }

    public static void adgDrilling(ProtectObject protectObject, NeMgrProtocolExtend extend) {
        Map params = protectObject.getProps();
        OracleAction action = new OracleAction(extend, (String)extend.getExtendParams().get("mac_address"));
        action.replaceUdevRuleDrilling(params);
    }

    public static void adgStartupDB(ProtectObject protectObject, NeMgrProtocolExtend extend) {
        Map params = protectObject.getProps();
        OracleAction action = new OracleAction(extend, (String)extend.getExtendParams().get("mac_address"));
        String adgDiskGroupNames = OracleAppUtil.getAdgAdgDiskGroupName(protectObject);
        params.put("ASM_DISK_GROUP_NAMES", adgDiskGroupNames);
        action.adgStartupDb(params);
    }

    public static Set<ProtectObjectStorageInfo> queryMatchedStorages(ProtectObject po, Map<String, Object> paramMap) {
        INeMgrProtocolExtendService neMgr = (INeMgrProtocolExtendService)ServiceLocator.getInstance().getService(INeMgrProtocolExtendService.class);
        NeMgrProtocolExtend ne = DrHostUtil.getNeMgrProtocolExtend((INeMgrProtocolExtendService)neMgr, (String)po.getProviderSN());
        OracleAction action = new OracleAction(ne, po.getProviderSN());
        List databases = paramMap.containsKey("dbId") ? DatabaseApplicationUtil.queryDatabaseByHostSnAndDbId((String)po.getProviderSN(), (String)String.valueOf(paramMap.get("dbId")), (int)1) : DatabaseApplicationUtil.queryAllDatabaseInstance((String)po.getProviderSN(), (int)1, paramMap);
        HashSet<ProtectObjectStorageInfo> matchedStorages = new HashSet<ProtectObjectStorageInfo>();
        for (Database database : databases) {
            Set<ProtectObjectStorageInfo> storageInfos;
            ManagedObject managedObject = database.getParentMo();
            if (!(managedObject instanceof OracleInstance)) continue;
            OracleInstance dbInstance = (OracleInstance)managedObject;
            HashMap<String, String> reqMap = new HashMap<String, String>();
            OracleAppUtil.updateAuthProps(reqMap, po);
            reqMap.put("INSTANCENAME", dbInstance.getInstanceName());
            reqMap.put("DATABASES", database.getName());
            reqMap.put("ORACLE_HOME", dbInstance.getOracleHome());
            reqMap.put("ARCHIVE_LOG", "0");
            try {
                storageInfos = action.queryLuns(reqMap);
                storageInfos.forEach(info -> info.setArchiveLog(Integer.valueOf(Integer.parseInt("0"))));
                if ("1".equals(po.getProps().get("ARCHIVE_LOG"))) {
                    reqMap.put("ARCHIVE_LOG", "1");
                    Set<ProtectObjectStorageInfo> archStorageInfoSet = action.queryLuns(reqMap);
                    OracleAppUtil.mergeArchWithInfo(archStorageInfoSet, storageInfos);
                }
            }
            catch (LegoCheckedException e) {
                LOGGER.error((Object)"Get luns failed by error: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
                return matchedStorages;
            }
            matchedStorages.addAll(storageInfos);
        }
        if (!CollectionUtils.isEmpty((Collection)databases)) {
            po.getProps().put("DATABASES", ((Database)databases.get(0)).getName());
        }
        return matchedStorages;
    }

    private static void mergeArchWithInfo(Set<ProtectObjectStorageInfo> archStorageInfoSet, Set<ProtectObjectStorageInfo> storageInfos) {
        if (!VerifyUtil.isEmpty(archStorageInfoSet)) {
            Set redoUniqSet = storageInfos.stream().map(info -> info.getResourceProviderSN() + ":" + info.getLunWWN() + ":" + info.getVolumeGroupName()).collect(Collectors.toSet());
            archStorageInfoSet.removeIf(archInfo -> redoUniqSet.contains(archInfo.getResourceProviderSN() + ":" + archInfo.getLunWWN() + ":" + archInfo.getVolumeGroupName()));
            archStorageInfoSet.forEach(info -> info.setArchiveLog(Integer.valueOf(Integer.parseInt("1"))));
            storageInfos.addAll(archStorageInfoSet);
        }
    }

    public static List<String> getIpsByRecoveryContext(RecoveryProcessorContext context) {
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        Set recoverySettings = recoveryPlan.getRecoverySettings();
        Optional<String> opt = recoverySettings.stream().filter(setting -> setting.getRecoveryPlan().getPlanId().equals(recoveryPlan.getPlanId())).filter(setting -> "PG_DISASTER_HOST".equals(setting.getName())).map(RecoverySetting::getValue).findFirst();
        if (!opt.isPresent()) {
            LOGGER.error((Object)"Not find hostID from recovery plan setting with PG_DISASTER_HOST");
            throw new LegoCheckedException(1073947394L);
        }
        String hostSn = opt.get();
        ArrayList<String> ips = new ArrayList<String>();
        DrResource resource = ((IResourceService)ServiceLocator.getInstance().getService(IResourceService.class)).getDrResourceBySn(hostSn);
        if (resource instanceof DrHostGroup) {
            resource.getChildResources().forEach(res -> ips.add(res.getDeviceSn()));
        } else {
            ips.add(hostSn);
        }
        return ips;
    }

    public static String getAdgStandbyLogWwn(ProtectObject protectObject) {
        if (VerifyUtil.isEmpty((Object)protectObject) || VerifyUtil.isEmpty((Map)protectObject.getProps())) {
            throw new LegoCheckedException(1073947393L);
        }
        String srcRedoLunWwn = protectObject.getProps().getOrDefault("REDO_LUN_WWN", "");
        Map<String, String> redoWwnByGroup = OracleAppUtil.parseToWwnGroup(srcRedoLunWwn);
        srcRedoLunWwn = String.join((CharSequence)",", redoWwnByGroup.values());
        String srcArchiveWwn = protectObject.getProps().getOrDefault("ARCHIVE_LUN_WWN", "");
        if (!VerifyUtil.isEmpty((String)srcArchiveWwn) && !"--".equals(srcArchiveWwn)) {
            Map<String, String> archWwnByGroup = OracleAppUtil.parseToWwnGroup(srcArchiveWwn);
            srcRedoLunWwn = srcRedoLunWwn + "," + String.join((CharSequence)",", archWwnByGroup.values());
        }
        return srcRedoLunWwn;
    }

    public static String getAdgAllPoStandbyLogWwn(ProtectGroup protectGroup) {
        Set polist = protectGroup.getPolist();
        ArrayList<String> allStandbyLogWwn = new ArrayList<String>();
        for (ProtectObject po : polist) {
            String adgStandbyLogWwn = OracleAppUtil.getAdgStandbyLogWwn(po);
            String[] lunIdArray = adgStandbyLogWwn.split(",");
            List<String> tmpList = Arrays.asList(lunIdArray);
            allStandbyLogWwn.addAll(tmpList);
        }
        return String.join((CharSequence)",", allStandbyLogWwn);
    }

    public static Map<String, String> parseToWwnGroup(String wwnByGroup) {
        if (VerifyUtil.isEmpty((String)wwnByGroup)) {
            return Collections.emptyMap();
        }
        String[] wwnGroup = wwnByGroup.split(";", -1);
        HashMap<String, String> wwnGroupMap = new HashMap<String, String>();
        for (String groupItem : wwnGroup) {
            Object[] wwnArr;
            if (VerifyUtil.isEmpty((String)groupItem) || VerifyUtil.isEmpty((Object[])(wwnArr = groupItem.split(":", -1)))) continue;
            if (wwnArr.length != 2 || VerifyUtil.isEmpty((String)wwnArr[1])) {
                LOGGER.warn((Object)"WwnGroup is wrong: %s", new Object[]{groupItem});
                continue;
            }
            Object groupName = wwnArr[0];
            Object wwnInGroup = wwnArr[1];
            wwnGroupMap.put((String)groupName, (String)wwnInGroup);
        }
        return wwnGroupMap;
    }

    public static String getAdgBackupLunId(ProtectObject po) {
        String backupLunId = po.getProps().getOrDefault("REDO_BACK_UP_LUN_IDS", "");
        if (VerifyUtil.isEmpty((String)backupLunId)) {
            LOGGER.warn((Object)"Backup lun id is empty.");
            return "";
        }
        JSONObject jsonObject = JSONObject.fromObject((Object)backupLunId);
        Object redoObj = jsonObject.get("REDO");
        String redoLunId = "";
        if (redoObj != null) {
            JSONObject redoJson = (JSONObject)CastUtil.castTo((Object)redoObj, JSONObject.class);
            redoLunId = OracleAppUtil.toLunIdStr(redoJson);
        }
        Object archObj = jsonObject.get("ARCHIVE");
        String archLunId = "";
        if (archObj != null) {
            JSONObject redoJson = (JSONObject)CastUtil.castTo((Object)archObj, JSONObject.class);
            archLunId = OracleAppUtil.toLunIdStr(redoJson);
        }
        return String.join((CharSequence)",", redoLunId, archLunId);
    }

    public static String getAdgAllPoBackupLunId(ProtectGroup protectGroup) {
        Set polist = protectGroup.getPolist();
        ArrayList<String> allLunIdList = new ArrayList<String>();
        for (ProtectObject po : polist) {
            List<String> lunIdList = OracleAppUtil.getAdgBackupLunIdList(po);
            allLunIdList.addAll(lunIdList);
        }
        return String.join((CharSequence)",", allLunIdList);
    }

    private static String toLunIdStr(JSONObject jsonObj) {
        Set set = jsonObj.keySet();
        StringBuilder sb = new StringBuilder();
        for (Object o : set) {
            String asmDgName = (String)CastUtil.castTo(o, String.class);
            Object val = jsonObj.get(asmDgName);
            if (val == null) continue;
            JSONArray jsonArray = (JSONArray)CastUtil.castTo((Object)val, JSONArray.class);
            if (VerifyUtil.isEmpty((Collection)jsonArray)) {
                LOGGER.warn((Object)"AsmDg has no lunId: %s", new Object[]{asmDgName});
                continue;
            }
            for (Object object : jsonArray) {
                if (VerifyUtil.isEmpty(object)) continue;
                sb.append(",");
                sb.append(object);
            }
        }
        sb.delete(0, 1);
        return sb.toString();
    }

    public static void checkAllInstanceStatus(ProtectObject po, boolean isAllOk) {
        String instanceNames = (String)po.getProps().get("INSTANCENAME");
        if (VerifyUtil.isEmpty((String)instanceNames)) {
            LOGGER.error((Object)"Not find any instanceNames.");
            return;
        }
        JSONArray instanceArray = OracleAppUtil.getInstanceArray(po, instanceNames);
        boolean hasOk = false;
        ProtectObject tempPo = OracleAppUtil.clone(po);
        LegoCheckedException adgException = null;
        for (Object instanceObj : instanceArray) {
            JSONArray newInstanceArray = new JSONArray();
            JSONObject instance = JSONObject.fromObject(instanceObj);
            String instanceName = JsonUtil.getString((JSONObject)instance, (String)"INSTANCENAME", (String[])new String[]{""});
            String hostSn = JsonUtil.getString((JSONObject)instance, (String)"ip", (String[])new String[]{""});
            if (VerifyUtil.isEmpty((String)instanceName) || VerifyUtil.isEmpty((String)hostSn)) continue;
            newInstanceArray.add((Object)instance);
            tempPo.getProps().put("INSTANCENAME", newInstanceArray.toString());
            tempPo.getProps().put("PROVIDER_TYPE", String.valueOf(DrmEnumDefine.ProviderTypeE.HOSTGROUP.getValue()));
            try {
                OracleManagerImpl service = (OracleManagerImpl)ServiceLocator.getInstance().getService(OracleManagerImpl.class);
                service.checkEnvStatus(tempPo);
                hasOk = true;
            }
            catch (LegoCheckedException e) {
                List parameters = VerifyUtil.isEmpty((Object[])e.getParameters()) ? Collections.emptyList() : Arrays.asList(e.getParameters());
                LOGGER.warn((Object)"Oracle ADG status is not matched, args: %s", new Object[]{parameters});
                if (isAllOk) {
                    throw e;
                }
                adgException = e;
            }
            if (isAllOk || !hasOk) continue;
            break;
        }
        if (!hasOk && adgException != null) {
            LOGGER.error((Object)"Oracle ADG status is not matched on all instance.");
            throw adgException;
        }
    }

    private static JSONArray getInstanceArray(ProtectObject po, String instanceNames) {
        JSONArray instanceArray;
        if (DrmEnumDefine.ProviderTypeE.HOST.getValue() == NumberUtil.convertToInteger(po.getProps().get("PROVIDER_TYPE")).intValue()) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)"INSTANCENAME", (Object)instanceNames);
            jsonObject.put((Object)"ip", (Object)po.getProviderSN());
            instanceArray = new JSONArray(new Object[]{jsonObject});
        } else {
            instanceArray = JSONArray.fromObject((Object)instanceNames);
        }
        return instanceArray;
    }

    public static void checkOneInstanceStatus(ProtectObject po, String targetSn) {
        String instanceNames = (String)po.getProps().get("INSTANCENAME");
        if (VerifyUtil.isEmpty((String)instanceNames)) {
            LOGGER.error((Object)"Not find any instanceNames.");
            return;
        }
        if (DrmEnumDefine.ProviderTypeE.HOSTGROUP.getValue() != NumberUtil.convertToInteger(po.getProps().get("PROVIDER_TYPE")).intValue()) {
            ProtectObject tempPo = OracleAppUtil.clone(po);
            tempPo.getProps().put("hostSn", po.getProviderSN());
            OracleAppUtil.checkAuthorityParameters(tempPo);
            INeMgrProtocolExtendService neMgr = (INeMgrProtocolExtendService)ServiceLocator.getInstance().getService(INeMgrProtocolExtendService.class);
            NeMgrProtocolExtend ne = DrHostUtil.getNeMgrProtocolExtend((INeMgrProtocolExtendService)neMgr, (String)po.getProviderSN());
            OracleAction action = new OracleAction(ne, (String)ne.getExtendParams().get("mac_address"));
            action.inspectAdgStatus(tempPo.getProps());
            return;
        }
        JSONArray instanceArray = JSONArray.fromObject((Object)instanceNames);
        for (Object instanceObj : instanceArray) {
            JSONObject instance = JSONObject.fromObject(instanceObj);
            String hostSn = JsonUtil.getString((JSONObject)instance, (String)"ip", (String[])new String[]{""});
            if (!targetSn.equals(hostSn)) continue;
            JSONArray newInstanceArray = new JSONArray();
            ProtectObject tempPo = OracleAppUtil.clone(po);
            newInstanceArray.add((Object)instance);
            tempPo.getProps().put("INSTANCENAME", newInstanceArray.toString());
            OracleManagerImpl manager = (OracleManagerImpl)ServiceLocator.getInstance().getService(OracleManagerImpl.class);
            try {
                manager.checkEnvStatus(tempPo);
            }
            catch (LegoCheckedException e) {
                List parameters = VerifyUtil.isEmpty((Object[])e.getParameters()) ? Collections.emptyList() : Arrays.asList(e.getParameters());
                LOGGER.error((Object)"Oracle ADG status is not matched, args: %s", new Object[]{parameters});
                throw e;
            }
        }
    }

    public static boolean isArchive(AppStorageInfo appStorageInfo) {
        if (VerifyUtil.isEmpty((Object)appStorageInfo)) {
            return false;
        }
        return OracleConst.DiskGroupType.ARCHIVE.getVal().equals(appStorageInfo.getAsmDgType());
    }

    public static boolean isData(AppStorageInfo appStorageInfo) {
        if (VerifyUtil.isEmpty((Object)appStorageInfo)) {
            return false;
        }
        return OracleConst.DiskGroupType.DATA.getVal().equals(appStorageInfo.getAsmDgType());
    }

    public static List<String> getOldPrdHostSns(ProtectObject po) {
        if (VerifyUtil.isEmpty((Object)po)) {
            LOGGER.error((Object)"Po is empty.");
            return Collections.emptyList();
        }
        String providerSN = po.getProviderSN();
        DrResource drResource = ((IResourceService)ServiceLocator.getInstance().getService(IResourceService.class)).getDrResourceBySn(providerSN);
        ArrayList<String> snList = new ArrayList<String>();
        if (drResource instanceof DrHost) {
            snList.add(drResource.getDeviceSn());
        } else if (drResource instanceof DrHostGroup) {
            Set hosts = drResource.getChildResources();
            hosts.forEach(host -> snList.add(host.getDeviceSn()));
        } else {
            LOGGER.error((Object)"Can not find host sn by:%s", new Object[]{providerSN});
            throw new LegoCheckedException(1073948686L);
        }
        return snList;
    }

    public static boolean isConsistentGroup(ProtectObject po) {
        List<ReplicationPair> pairList = OracleAppUtil.getPairList(po.getProtectGroup(), po.getUuid(), true);
        if (pairList.isEmpty()) {
            LOGGER.info((Object)"Pair list is empty.");
            return false;
        }
        String groupId = pairList.get(0).getConsistentGroupId();
        if (VerifyUtil.isEmpty((String)groupId) || "--".equals(groupId)) {
            LOGGER.info((Object)"Po:%s not use cg.", new Object[]{po.getName()});
            return false;
        }
        return true;
    }

    public static List<ReplicationPair> getPairList(ProtectGroup pg, String poId, boolean isPrimary) {
        IStorageService service = (IStorageService)ServiceLocator.getInstance().getService(IStorageService.class);
        Optional optional = pg.getReplicaList().stream().findFirst();
        if (!optional.isPresent()) {
            LOGGER.error((Object)"Protect group replica list is empty,protect group name:%s", new Object[]{pg.getName()});
            throw new LegoCheckedException(1073947393L);
        }
        ProtectObject po = DBRecoveryTools.getProtectObjectByPoId((Set)pg.getPolist(), (String)poId);
        List<String> lunIdList = isPrimary ? OracleAppUtil.getAdgBackupLunIdList(po) : OracleAppUtil.getRemoteLunIdList(po);
        ProtectGroupReplica replica = (ProtectGroupReplica)optional.get();
        List pairs = service.getReplicationPairsByResourceIds(replica.getRecoveryArray(), lunIdList, !isPrimary, Integer.valueOf(DrmEnumDefine.ResourceTypeE.LUN.getValue()));
        LOGGER.info((Object)"Lun id list size:%s, pair list size:%s", new Object[]{lunIdList.size(), pairs.size()});
        if (pairs.size() != lunIdList.size()) {
            List parisIds = pairs.stream().map(ReplicationPair::getSrcLunId).collect(Collectors.toList());
            List noPairId = lunIdList.stream().filter(id -> !parisIds.contains(id)).collect(Collectors.toList());
            LOGGER.error((Object)"Not all luns has replication pair, lun ids:%s", new Object[]{String.join((CharSequence)",", noPairId)});
            throw new LegoCheckedException(1073947393L);
        }
        return pairs;
    }

    public static List<String> getAdgBackupLunIdList(ProtectObject po) {
        String backLunIds = OracleAppUtil.getAdgBackupLunId(po);
        String[] lunIdArray = backLunIds.split(",");
        return Arrays.asList(lunIdArray);
    }

    public static List<String> getRemoteLunIdList(ProtectObject po) {
        Map props = po.getProps();
        String lunIds = (String)props.get("REMOTE_PAIR_SRCLUNIDS");
        String[] lunIdArray = lunIds.split(",");
        return Arrays.asList(lunIdArray);
    }

    public static HvsProtectionGroup getHvsProtectionGroup(String devSn, String lunId) {
        StorageProtectGroupManagerProxy proxy = StorageProtectGroupManagerProxy.getInstance();
        return proxy.associatedQueryProtectionGroup(devSn, 11, lunId);
    }

    public static String getAdgAllPoRemoteLunIdList(ProtectGroup protectGroup) {
        ArrayList<String> allPoLunIdList = new ArrayList<String>();
        Set polist = protectGroup.getPolist();
        for (ProtectObject po : polist) {
            List<String> remoteLunIdList = OracleAppUtil.getRemoteLunIdList(po);
            allPoLunIdList.addAll(remoteLunIdList);
        }
        return String.join((CharSequence)",", allPoLunIdList);
    }

    public static String getInstanceNameByHostSn(ProtectObject po, String sn) {
        int proType = NumberUtil.convertToInteger(po.getProps().get("PROVIDER_TYPE"));
        String instanceString = po.getProps().getOrDefault("INSTANCENAME", "");
        if (proType != DrmEnumDefine.ProviderTypeE.HOSTGROUP.getValue()) {
            return instanceString;
        }
        JSONArray instanceArray = JSONArray.fromObject((Object)instanceString);
        String instance = "";
        for (Object obj : instanceArray) {
            JSONObject jsonObject = JSONObject.fromObject(obj);
            if (!jsonObject.getString("ip").equals(sn)) continue;
            instance = jsonObject.getString("INSTANCENAME");
            break;
        }
        return instance;
    }

    public static JSONObject queryDbInfo(ProtectObject protectObject) {
        String instanceNames = (String)protectObject.getProps().get("INSTANCENAME");
        if (VerifyUtil.isEmpty((String)instanceNames)) {
            LOGGER.error((Object)"No instanceNames.");
            throw new LegoCheckedException(1073947394L);
        }
        JSONArray instanceArray = OracleAppUtil.getInstanceArray(protectObject, instanceNames);
        if (VerifyUtil.isEmpty((Collection)instanceArray)) {
            LOGGER.error((Object)"No instanceNames info for po: %s", new Object[]{protectObject.getName()});
            throw new LegoCheckedException(1073947394L);
        }
        Object instanceObj = instanceArray.get(0);
        ProtectObject tempPo = OracleAppUtil.clone(protectObject);
        JSONObject instance = JSONObject.fromObject((Object)instanceObj);
        String instanceName = JsonUtil.getString((JSONObject)instance, (String)"INSTANCENAME", (String[])new String[]{""});
        String hostSn = JsonUtil.getString((JSONObject)instance, (String)"ip", (String[])new String[]{""});
        if (VerifyUtil.isEmpty((String)instanceName) || VerifyUtil.isEmpty((String)hostSn)) {
            LOGGER.error((Object)"Not found instanceName info for po: %s", new Object[]{protectObject.getName()});
            throw new LegoCheckedException(1073947394L);
        }
        tempPo.getProps().put("INSTANCENAME", instanceName);
        tempPo.getProps().put("PROVIDER_TYPE", String.valueOf(DrmEnumDefine.ProviderTypeE.HOST.getValue()));
        INeMgrProtocolExtendService neMgr = (INeMgrProtocolExtendService)ServiceLocator.getInstance().getService(INeMgrProtocolExtendService.class);
        NeMgrProtocolExtend neExtend = DrHostUtil.getNeMgrProtocolExtend((INeMgrProtocolExtendService)neMgr, (String)hostSn);
        OracleAction action = new OracleAction(neExtend, hostSn);
        return action.queryDbStatus(tempPo.getProps());
    }

    public static void checkAdgStatus(ProtectGroup protectGroup) {
        Set poList = protectGroup.getPolist();
        for (ProtectObject po : poList) {
            po.getProps().put("QUERY_TYPE", "0");
            try {
                OracleAppUtil.checkAdgNodeOfPo(po);
                AlarmReporter.restoreAlarm((String)"0x3230099", (String[])new String[]{po.getUuid()});
            }
            catch (LegoCheckedException e) {
                String ipAddr = "--";
                if (e.getErrorCode() == 1073948515L && !VerifyUtil.isEmpty((Object[])e.getParameters()) && e.getParameters().length == 2) {
                    ipAddr = e.getParameters()[1];
                }
                String[] params = new String[]{(String)po.getProps().get("DATABASES"), protectGroup.getName(), ipAddr, po.getUuid()};
                LOGGER.error((Object)"Fail to check adg status at: %s, po name:%s", new Object[]{protectGroup.getName(), po.getName()});
                AlarmReporter.sendAlarm((String)"0x3230099", (String)(protectGroup.getUuid() + "_" + po.getUuid()), (String)FaultEnum.AlarmResourceType.DRMOBJECT.getValue(), (FaultEnum.AlarmSeverity)FaultEnum.AlarmSeverity.MAJOR, (String[])params);
            }
        }
    }

    private static void checkAdgNodeOfPo(ProtectObject po) {
        List<ProtectObject> tempPo = OracleAppUtil.createNodeOfPo(po);
        IApplicationManager applicationManager = ApplicationAdapterProxy.getInstance().getAppManager(po.getPoType());
        tempPo.forEach(arg_0 -> ((IApplicationManager)applicationManager).checkEnvStatus(arg_0));
    }

    private static List<ProtectObject> createNodeOfPo(ProtectObject po) {
        ArrayList<ProtectObject> poList = new ArrayList<ProtectObject>();
        int proType = NumberUtil.convertToInteger(po.getProps().get("PROVIDER_TYPE"));
        if (DrmEnumDefine.ProviderTypeE.HOSTGROUP.getValue() == proType) {
            String instanceConfig = (String)po.getProps().get("INSTANCENAME");
            if (VerifyUtil.isEmpty((String)instanceConfig)) {
                LOGGER.error((Object)"Instance config not found: poName=%s", new Object[]{po.getName()});
                return Collections.emptyList();
            }
            JSONArray instanceArray = JSONArray.fromObject((Object)instanceConfig);
            for (Object obj : instanceArray) {
                JSONObject jsonObject = JSONObject.fromObject(obj);
                String instanceName = jsonObject.getString("INSTANCENAME", "");
                String hostSn = jsonObject.getString("ip", "");
                if (VerifyUtil.isEmpty((String)instanceName) || VerifyUtil.isEmpty((String)hostSn)) continue;
                ProtectObject newPo = new ProtectObject();
                newPo.getProps().putAll(po.getProps());
                newPo.setProviderSN(hostSn);
                newPo.setPoType(1);
                newPo.getProps().put("INSTANCENAME", instanceName);
                newPo.getProps().put("PROVIDER_TYPE", String.valueOf(DrmEnumDefine.ProviderTypeE.HOST.getValue()));
                newPo.getProps().put("hostSn", hostSn);
                poList.add(newPo);
            }
        } else {
            poList.add(po);
        }
        return poList;
    }

    public static Map<String, String> getAdgDgByLunIdForAllPo(ProtectGroup protectGroup) {
        if (VerifyUtil.isEmpty((Object)protectGroup) || VerifyUtil.isEmpty((Collection)protectGroup.getPolist())) {
            LOGGER.warn((Object)"Cant get po info.");
            return Collections.emptyMap();
        }
        List<String> jsonKeyList = Arrays.asList("ARCHIVE", "REDO");
        ArrayList<JSONObject> jsonObjects = new ArrayList<JSONObject>();
        for (ProtectObject po : protectGroup.getPolist()) {
            String allLunIdOfPo = po.getProps().getOrDefault("REDO_BACK_UP_LUN_IDS", "");
            if (VerifyUtil.isEmpty((String)allLunIdOfPo)) {
                LOGGER.warn((Object)"All backup lun id is empty: %s", new Object[]{po.getName()});
                continue;
            }
            for (String jsonKey : jsonKeyList) {
                JSONObject jsonObject = JSONObject.fromObject((Object)allLunIdOfPo);
                Object redoObj = jsonObject.get(jsonKey);
                if (redoObj == null) continue;
                JSONObject redoJsonObj = (JSONObject)CastUtil.castTo((Object)redoObj, JSONObject.class);
                jsonObjects.add(redoJsonObj);
            }
        }
        HashMap<String, String> dgToLunId = new HashMap<String, String>();
        for (JSONObject jsonObject : jsonObjects) {
            Set dgNameSet = jsonObject.keySet();
            for (String dgName : dgNameSet) {
                Object val = jsonObject.get(dgName);
                if (VerifyUtil.isEmpty((Object)val)) continue;
                JSONArray lunIdArray = JSONArray.fromObject((Object)val);
                for (Object o : lunIdArray) {
                    String lunId = (String)CastUtil.castTo(o, String.class);
                    dgToLunId.put(lunId, dgName);
                }
            }
        }
        return dgToLunId;
    }

    public static RecoveryPlan getCurrentRecoveryPlan(RecoveryPlan recoveryPlan) {
        IRecoveryPlanService planService = (IRecoveryPlanService)ServiceLocator.getInstance().getService(IRecoveryPlanService.class);
        return planService.getRecoveryPlan(recoveryPlan.getPlanId(), false, false);
    }

    public static String getAdgAdgDiskGroupName(ProtectObject protectObject) {
        if (VerifyUtil.isEmpty((Object)protectObject) || VerifyUtil.isEmpty((Map)protectObject.getProps())) {
            return "";
        }
        Map props = protectObject.getProps();
        String redoWwnByDg = props.getOrDefault("REDO_LUN_WWN", "");
        Map<String, String> redoDgMap = OracleAppUtil.parseToWwnGroup(redoWwnByDg);
        HashSet<String> dgNameSet = new HashSet<String>(redoDgMap.keySet());
        String archWwnByDg = props.getOrDefault("ARCHIVE_LUN_WWN", "");
        if (!VerifyUtil.isEmpty((String)archWwnByDg) && !"--".equals(archWwnByDg)) {
            Map<String, String> archDgMap = OracleAppUtil.parseToWwnGroup(archWwnByDg);
            dgNameSet.addAll(archDgMap.keySet());
        }
        return String.join((CharSequence)",", dgNameSet);
    }

    public static boolean isUsingProtectionGroupInAdg(ProtectObject po) {
        VerifyUtil.checkEmpty((Object)po);
        Set storageResourceSet = po.getUsedStorageResourceSet();
        ProtectObjectStorageInfo storageInfo = (ProtectObjectStorageInfo)CommonUtil.getFirstElement((Collection)storageResourceSet);
        String adgBackupLunId = OracleAppUtil.getAdgBackupLunId(po);
        if (VerifyUtil.isEmpty((String)adgBackupLunId)) {
            return false;
        }
        String lunId = adgBackupLunId.split(",", -1)[0];
        String devSn = storageInfo.getResourceProviderSN();
        StorageProtectGroupManagerProxy groupManagerProxy = StorageProtectGroupManagerProxy.getInstance();
        HvsProtectionGroup hvsPg = groupManagerProxy.associatedQueryProtectionGroup(devSn, 11, lunId);
        return !VerifyUtil.isEmpty((Object)hvsPg) && !VerifyUtil.isEmpty((String)hvsPg.getProtectGroupId());
    }

    public static String generateGroupKey(String uniqKey, boolean isSrcId, boolean isAtoB, String tag) {
        if (isAtoB) {
            return uniqKey + (isSrcId ? "-aToBSrc-" : "-aToBTgt-") + tag;
        }
        return uniqKey + (isSrcId ? "-bToASrc-" : "-bToATgt-") + tag;
    }
}

