/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.oracle.recovery.util;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.app.util.JsonUtil;
import com.huawei.ism.drm.drp.sdk.model.RecoverySetting;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class OracleCDBUtil {
    public static boolean hasStartPDBs(Set<RecoverySetting> recoverySettings, ProtectObject po) {
        List<String> list = OracleCDBUtil.getStartPdbs(recoverySettings, po);
        return !VerifyUtil.isEmpty(list);
    }

    public static List<String> getStartPdbs(Set<RecoverySetting> recoverySettings, ProtectObject po) {
        ArrayList<String> list = new ArrayList<String>();
        if (VerifyUtil.isEmpty((Object)po)) {
            return list;
        }
        String result = (String)po.getProps().get("PDB");
        JSONArray myJsonArray = JSONArray.fromObject((Object)result);
        for (Object obj : myJsonArray) {
            JSONObject jsonObject = JSONObject.fromObject(obj);
            String pdbName = JsonUtil.getString((JSONObject)jsonObject, (String)"pdbName", (String[])new String[]{""});
            String type = JsonUtil.getString((JSONObject)jsonObject, (String)"type", (String[])new String[]{""});
            if (!"PDB".equals(type)) continue;
            list.add(pdbName);
        }
        if (VerifyUtil.isEmpty(recoverySettings)) {
            return list;
        }
        for (RecoverySetting setting : recoverySettings) {
            if (!setting.getOwnerId().equals(po.getUuid()) || !"PDB".equals(setting.getName())) continue;
            JSONArray my = JSONArray.fromObject((Object)setting.getValue());
            for (Object obj : my) {
                JSONObject jsonObject = JSONObject.fromObject(obj);
                Boolean b = JsonUtil.getBoolean((JSONObject)jsonObject, (String)"isStart", (Boolean[])new Boolean[]{true});
                if (null == b || b.booleanValue()) continue;
                list.remove(JsonUtil.getString((JSONObject)jsonObject, (String)"pdbName", (String[])new String[]{""}));
            }
        }
        return list;
    }
}

