/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.kube.connection;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.huawei.ism.drm.kube.sdk.model.Kubernetes;
import com.huawei.ism.drm.kube.util.KubeUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.LegoConfig;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.core.sdk.util.WccEncryptor;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;

public class KubeClientLoader {
    private static final Log LOGGER = LogFactory.getInstance(KubeClientLoader.class);
    private static final Cache<String, KubernetesClient> CLIENT_CACHE = CacheBuilder.newBuilder().maximumSize(10L).expireAfterWrite(2L, TimeUnit.HOURS).build();

    public static KubernetesClient buildKubeClientByConfig(String configContent) {
        VerifyUtil.checkStrs((String[])new String[]{configContent});
        if (Thread.currentThread().getContextClassLoader() == null) {
            LOGGER.warn((Object)"Init kubernetes client class loader empty.");
            Thread.currentThread().setContextClassLoader(KubeClientLoader.class.getClassLoader());
        }
        Config kubeConfig = Config.fromKubeconfig((String)configContent);
        boolean trustCert = LegoConfig.getInstance().getBoolean("kube.trust.cert", Boolean.valueOf(true));
        kubeConfig.setTrustCerts(trustCert);
        return new DefaultKubernetesClient(kubeConfig);
    }

    public static KubernetesClient getKubernetesClient(String sn) {
        VerifyUtil.checkStrs((String[])new String[]{sn});
        try {
            return (KubernetesClient)CLIENT_CACHE.get((Object)sn, () -> KubeClientLoader.buildKubernetesClient(sn));
        }
        catch (ExecutionException e) {
            LOGGER.error((Object)"Get client from cache failed. Error:%s", new Object[]{e.getMessage()});
            throw new LegoCheckedException(-1L);
        }
    }

    private static KubernetesClient buildKubernetesClient(String sn) {
        Kubernetes kubernetes = KubeUtil.getKubernetes(sn);
        String config = WccEncryptor.decrypt((String)kubernetes.getConfig());
        return KubeClientLoader.buildKubeClientByConfig(config);
    }

    public static void invalidCache() {
        LOGGER.warn((Object)"Clean kube client cache.");
        CLIENT_CACHE.invalidateAll();
    }

    static {
        Thread.currentThread().setContextClassLoader(KubeClientLoader.class.getClassLoader());
    }
}

