/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.kube.handler;

import com.huawei.ism.drm.kube.connection.KubeClientLoader;
import com.huawei.ism.drm.kube.connection.KubeConnection;
import com.huawei.ism.drm.kube.handler.MetaClassScanner;
import com.huawei.ism.drm.kube.sdk.IKubeHandler;
import com.huawei.ism.drm.kube.sdk.model.BackupInstanceInfo;
import com.huawei.ism.drm.kube.sdk.model.BackupLocationInfo;
import com.huawei.ism.drm.kube.sdk.model.CSIJson;
import com.huawei.ism.drm.kube.sdk.model.ClusterInfo;
import com.huawei.ism.drm.kube.sdk.model.Domain;
import com.huawei.ism.drm.kube.sdk.model.KubeBackup;
import com.huawei.ism.drm.kube.sdk.model.KubeBackupJob;
import com.huawei.ism.drm.kube.sdk.model.KubeEvent;
import com.huawei.ism.drm.kube.sdk.model.KubeHyperMetroDomainBackend;
import com.huawei.ism.drm.kube.sdk.model.KubePersistentVolume;
import com.huawei.ism.drm.kube.sdk.model.KubeProtectionJob;
import com.huawei.ism.drm.kube.sdk.model.KubeProtectionPlan;
import com.huawei.ism.drm.kube.sdk.model.KubeReProtectionJob;
import com.huawei.ism.drm.kube.sdk.model.KubeRecoveryJob;
import com.huawei.ism.drm.kube.sdk.model.KubeRecoveryPlan;
import com.huawei.ism.drm.kube.sdk.model.KubeResource;
import com.huawei.ism.drm.kube.sdk.model.KubeResourceSetPVC;
import com.huawei.ism.drm.kube.sdk.model.KubeRestoreJob;
import com.huawei.ism.drm.kube.sdk.model.KubeSchedulePolicy;
import com.huawei.ism.drm.kube.sdk.model.KubeStorage;
import com.huawei.ism.drm.kube.sdk.model.KubeVolumeSet;
import com.huawei.ism.drm.kube.sdk.model.Kubernetes;
import com.huawei.ism.drm.kube.sdk.model.PersistentVolumeClaimInfo;
import com.huawei.ism.drm.kube.sdk.model.PodResource;
import com.huawei.ism.drm.kube.sdk.model.ResourceSetInfo;
import com.huawei.ism.drm.kube.sdk.model.StorageClassInfo;
import com.huawei.ism.drm.kube.sdk.model.bo.HookBO;
import com.huawei.ism.drm.kube.sdk.model.bo.LabelBO;
import com.huawei.ism.drm.kube.sdk.model.bo.NamespaceBO;
import com.huawei.ism.drm.kube.sdk.model.bo.PersistentVolumeBO;
import com.huawei.ism.drm.kube.sdk.model.constants.KubeEnumDefine;
import com.huawei.ism.drm.kube.sdk.model.enums.KubeRole;
import com.huawei.ism.drm.kube.sdk.utils.KubeCommonUtils;
import com.huawei.ism.drm.kube.sdk.utils.KubeResourceNameGenerator;
import com.huawei.ism.drm.kube.util.KubeConvertUtil;
import com.huawei.ism.drm.kube.util.KubeExceptionUtil;
import com.huawei.ism.drm.kube.util.KubeUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.Ipv4AddressUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.SecurityUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import io.fabric8.kubernetes.api.model.CSIPersistentVolumeSource;
import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.Event;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.Node;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.OwnerReference;
import io.fabric8.kubernetes.api.model.PersistentVolume;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimSpec;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.apps.DaemonSet;
import io.fabric8.kubernetes.api.model.apps.DaemonSetStatus;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.DeploymentStatus;
import io.fabric8.kubernetes.api.model.apps.ReplicaSet;
import io.fabric8.kubernetes.api.model.apps.ReplicaSetStatus;
import io.fabric8.kubernetes.api.model.apps.StatefulSet;
import io.fabric8.kubernetes.api.model.apps.StatefulSetStatus;
import io.fabric8.kubernetes.api.model.storage.StorageClass;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.huawei.xuanwu.v1.Backup;
import io.huawei.xuanwu.v1.BackupInstance;
import io.huawei.xuanwu.v1.BackupInstanceStatus;
import io.huawei.xuanwu.v1.BackupJob;
import io.huawei.xuanwu.v1.BackupLocation;
import io.huawei.xuanwu.v1.BackupSchedule;
import io.huawei.xuanwu.v1.Cluster;
import io.huawei.xuanwu.v1.Hook;
import io.huawei.xuanwu.v1.HyperMetroDomain;
import io.huawei.xuanwu.v1.ProtectionJob;
import io.huawei.xuanwu.v1.ProtectionPlan;
import io.huawei.xuanwu.v1.ProtectionPlanSpec;
import io.huawei.xuanwu.v1.ProtectionPlanStatus;
import io.huawei.xuanwu.v1.ReProtectionJob;
import io.huawei.xuanwu.v1.ReProtectionJobSpec;
import io.huawei.xuanwu.v1.ReProtectionJobStatus;
import io.huawei.xuanwu.v1.RecoveryJob;
import io.huawei.xuanwu.v1.RecoveryJobSpec;
import io.huawei.xuanwu.v1.RecoveryPlan;
import io.huawei.xuanwu.v1.RecoveryPlanSpec;
import io.huawei.xuanwu.v1.ResourceDetail;
import io.huawei.xuanwu.v1.ResourceDetailStatus;
import io.huawei.xuanwu.v1.ResourceSet;
import io.huawei.xuanwu.v1.ResourceSetSpec;
import io.huawei.xuanwu.v1.ResourceSetStatus;
import io.huawei.xuanwu.v1.RestoreJob;
import io.huawei.xuanwu.v1.SchedulePolicy;
import io.huawei.xuanwu.v1.StorageBackendClaim;
import io.huawei.xuanwu.v1.StorageBackendClaimStatus;
import io.huawei.xuanwu.v1.StorageBackendContent;
import io.huawei.xuanwu.v1.VolumeSet;
import io.huawei.xuanwu.v1.resourcedetailstatus.Resources;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

@Service(name="com.huawei.ism.drm.kube.sdk.IKubeHandler", desc="", interfaceClass=IKubeHandler.class)
public class KubeHandlerImpl
extends BaseService
implements IKubeHandler {
    private static final Log LOGGER = LogFactory.getInstance(KubeHandlerImpl.class);
    private static final Set<Class<? extends HasMetadata>> META_CLASSES = new MetaClassScanner().scan(new String[]{"io.fabric8.kubernetes.api.model", "io.huawei.xuanwu.v1"});
    private static final String RESOURCE_SET_STATUS_REFRESHING = "Refreshing";
    private static final long DURATION = 5000L;
    private static final String POD = "Pod";
    private static final String REPLICA_SET = "ReplicaSet";
    private static final String DAEMON_SET = "DaemonSet";
    private static final String STATEFUL_SET = "StatefulSet";
    private static final String DEPLOYMENT = "Deployment";
    private static final List<String> HANDLE_LABELS_RESOURCE_KIND = Collections.unmodifiableList(Arrays.asList("Pod", "ReplicaSet", "DaemonSet", "StatefulSet"));
    private static final List<String> CHECK_XUANWU_DEPLOYMENT = Collections.unmodifiableList(Arrays.asList("xuanwu-backup-mngt", "xuanwu-backup-service", "xuanwu-base-mngt", "xuanwu-disaster-mngt", "xuanwu-disaster-service", "xuanwu-metadata-service", "xuanwu-volume-service"));

    public List<NamespaceBO> getNamespaces(String devSn) {
        VerifyUtil.checkStrs((String[])new String[]{devSn});
        KubeConnection restConnection = new KubeConnection(devSn);
        List<Namespace> list = restConnection.getList(Namespace.class);
        return list.stream().map(KubeConvertUtil::transNamespace).collect(Collectors.toList());
    }

    public void createNamespace(String devSn, NamespaceBO namespaceBO) {
        VerifyUtil.checkStrs((String[])new String[]{namespaceBO.getName()});
        LOGGER.info((Object)"Start create Namespace %s", new Object[]{namespaceBO.getName()});
        Namespace namespace = KubeConvertUtil.transToNamespaceForKube(namespaceBO);
        this.createResource(devSn, namespace, Namespace.class);
    }

    public boolean deleteNamespace(String devSn, String namespaceName) {
        VerifyUtil.checkStrs((String[])new String[]{namespaceName});
        LOGGER.info((Object)"Start delete namespace %s", new Object[]{namespaceName});
        HashSet<String> resourceNames = new HashSet<String>();
        resourceNames.add(namespaceName);
        return this.deleteKubeResourcesByType(devSn, Namespace.class, resourceNames);
    }

    public boolean deleteVolumeSet(String devSn, String volumeSetName) {
        VerifyUtil.checkStrs((String[])new String[]{volumeSetName});
        LOGGER.info((Object)"Start delete VolumeSet %s", new Object[]{volumeSetName});
        HashSet<String> volumeSets = new HashSet<String>();
        volumeSets.add(volumeSetName);
        return this.deleteKubeResourcesByType(devSn, VolumeSet.class, volumeSets);
    }

    public KubeVolumeSet getVolumeSet(String devSn, String volumeSetName) {
        VerifyUtil.checkStrs((String[])new String[]{volumeSetName});
        KubeConnection connection = new KubeConnection(devSn);
        Optional<VolumeSet> opt = connection.get(VolumeSet.class, volumeSetName);
        return opt.map(KubeConvertUtil::tansToKubeVolumeSet).orElse(null);
    }

    public Optional<NamespaceBO> getNamespace(String devSn, String namespaceName) {
        VerifyUtil.checkStrs((String[])new String[]{devSn});
        VerifyUtil.checkStrs((String[])new String[]{namespaceName});
        KubeConnection restConnection = new KubeConnection(devSn);
        Optional<Namespace> namespaceOptional = restConnection.get(Namespace.class, namespaceName);
        return namespaceOptional.map(KubeConvertUtil::transNamespace);
    }

    public List<HookBO> getHooks(String devSn) {
        VerifyUtil.checkStrs((String[])new String[]{devSn});
        KubeConnection connection = new KubeConnection(devSn);
        List<Hook> hooks = connection.getList(Hook.class);
        return hooks.stream().map(KubeConvertUtil::transHook).collect(Collectors.toList());
    }

    public Optional<HookBO> getHook(String devSn, String hookName) {
        VerifyUtil.checkStrs((String[])new String[]{devSn});
        VerifyUtil.checkStrs((String[])new String[]{hookName});
        KubeConnection restConnection = new KubeConnection(devSn);
        Optional<Hook> namespaceOptional = restConnection.get(Hook.class, hookName);
        return namespaceOptional.map(KubeConvertUtil::transHook);
    }

    public List<PersistentVolumeBO> getPersistentVolumes(String devSn) {
        VerifyUtil.checkStrs((String[])new String[]{devSn});
        KubeConnection connection = new KubeConnection(devSn);
        List<PersistentVolume> volumes = connection.getList(PersistentVolume.class);
        return volumes.stream().map(KubeConvertUtil::transPersistentVolume).collect(Collectors.toList());
    }

    public void checkConnectionByConfig(String config) {
        VerifyUtil.checkStrs((String[])new String[]{config});
        try (KubernetesClient client = KubeClientLoader.buildKubeClientByConfig(config);){
            KubeConnection connection = new KubeConnection(client);
            connection.getList(Hook.class);
        }
        catch (KubernetesClientException e) {
            LOGGER.error((Object)"Check kube client exception, errorMsg:%s", (Throwable)e);
            throw KubeExceptionUtil.checkAndConvert(e);
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"Check cdr connection failed, errorMsg:%s", (Throwable)e);
            throw e;
        }
    }

    public boolean checkConnectionBySN(String devSn) {
        boolean isConnectSuccess;
        try {
            this.getHooks(devSn);
            isConnectSuccess = true;
        }
        catch (LegoCheckedException | KubernetesClientException e) {
            isConnectSuccess = false;
            LOGGER.error((Object)"[kubernetes]Connect to CDR error.", e);
        }
        return isConnectSuccess;
    }

    public boolean checkResourceControllerTerminated(String kubeSn, String kind, String name, String namespace) {
        boolean isTerminated;
        switch (kind) {
            case "ReplicaSet": {
                isTerminated = this.checkReplicaSetTerminated(kubeSn, name, namespace);
                break;
            }
            case "DaemonSet": {
                isTerminated = this.checkDaemonSetTerminated(kubeSn, name, namespace);
                break;
            }
            case "StatefulSet": {
                isTerminated = this.checkStatefulSetTerminated(kubeSn, name, namespace);
                break;
            }
            case "Deployment": {
                isTerminated = this.checkDeploymentTerminated(kubeSn, name, namespace);
                break;
            }
            default: {
                isTerminated = true;
            }
        }
        return isTerminated;
    }

    public Optional<Domain> getHyperMetroDomain(String kubeSn, String domainName) {
        VerifyUtil.checkStrs((String[])new String[]{kubeSn, domainName});
        KubeConnection connection = new KubeConnection(kubeSn);
        Optional<HyperMetroDomain> optional = connection.get(HyperMetroDomain.class, domainName);
        if (!optional.isPresent()) {
            LOGGER.warn((Object)"The HyperMetroDomain (%s) is not present.", new Object[]{domainName});
            return Optional.empty();
        }
        Domain domain = KubeConvertUtil.tansToKubeDomain(optional.get());
        this.buildHyperMetroDomainIpAddress(kubeSn, domain);
        return Optional.of(domain);
    }

    private boolean checkReplicaSetTerminated(String kubeSn, String name, String namespace) {
        KubeConnection connection = new KubeConnection(kubeSn);
        Optional<ReplicaSet> optional = connection.get(ReplicaSet.class, namespace, name);
        if (!optional.isPresent()) {
            return true;
        }
        ReplicaSet replicaSet = optional.get();
        ReplicaSetStatus status = replicaSet.getStatus();
        if (status == null) {
            return false;
        }
        return status.getReadyReplicas() == null || status.getReadyReplicas() == 0;
    }

    private boolean checkDaemonSetTerminated(String kubeSn, String name, String namespace) {
        KubeConnection connection = new KubeConnection(kubeSn);
        Optional<DaemonSet> optional = connection.get(DaemonSet.class, namespace, name);
        if (!optional.isPresent()) {
            return true;
        }
        DaemonSet daemonSet = optional.get();
        DaemonSetStatus status = daemonSet.getStatus();
        if (status == null) {
            return false;
        }
        return status.getNumberReady() == null || status.getNumberReady() == 0;
    }

    private boolean checkStatefulSetTerminated(String kubeSn, String name, String namespace) {
        KubeConnection connection = new KubeConnection(kubeSn);
        Optional<StatefulSet> optional = connection.get(StatefulSet.class, namespace, name);
        if (!optional.isPresent()) {
            return true;
        }
        StatefulSet statefulSet = optional.get();
        StatefulSetStatus status = statefulSet.getStatus();
        if (status == null) {
            return false;
        }
        return status.getReadyReplicas() == null || status.getReadyReplicas() == 0;
    }

    private boolean checkDeploymentTerminated(String kubeSn, String name, String namespace) {
        KubeConnection connection = new KubeConnection(kubeSn);
        Optional<Deployment> optional = connection.get(Deployment.class, namespace, name);
        if (!optional.isPresent()) {
            return true;
        }
        Deployment deployment = optional.get();
        DeploymentStatus status = deployment.getStatus();
        if (status == null) {
            return false;
        }
        return status.getReadyReplicas() == null || status.getReadyReplicas() == 0;
    }

    public List<LabelBO> queryKubeLabelsFromAll(String devSn) {
        VerifyUtil.checkStrs((String[])new String[]{devSn});
        KubeConnection restConnection = new KubeConnection(devSn);
        Set<LabelBO> tmpLabels = this.getResourceLabels(restConnection);
        return new ArrayList<LabelBO>(tmpLabels);
    }

    private Set<LabelBO> getResourceLabels(KubeConnection restConnection) {
        List<Class> classList = Arrays.asList(ReplicaSet.class, Pod.class, Deployment.class, io.fabric8.kubernetes.api.model.Service.class, DaemonSet.class, StatefulSet.class);
        List<String> subResourceKinds = Arrays.asList(ReplicaSet.class.getSimpleName(), Pod.class.getSimpleName());
        return classList.parallelStream().map(restConnection::getList).flatMap(Collection::stream).filter(e -> !subResourceKinds.contains(e.getKind()) || VerifyUtil.isEmpty((Collection)e.getMetadata().getOwnerReferences())).map(resource -> {
            ArrayList<LabelBO> labels = new ArrayList<LabelBO>();
            this.transLabels(restConnection, (HasMetadata)resource, (List<LabelBO>)labels);
            return labels;
        }).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    private <T extends HasMetadata> void transLabels(KubeConnection connection, HasMetadata resource, List<LabelBO> labels) {
        Optional<OwnerReference> ownerReferenceOptional = KubeHandlerImpl.getOwnerReference(resource);
        if (!ownerReferenceOptional.isPresent()) {
            Map labelMap = resource.getMetadata().getLabels();
            labels.addAll(KubeConvertUtil.transLabels(labelMap, resource.getMetadata().getNamespace()));
            return;
        }
        OwnerReference ownerReference = ownerReferenceOptional.get();
        HasMetadata ownerResource = this.getOwnerResource(connection, ownerReference, resource.getMetadata().getNamespace());
        if (ownerResource == null) {
            return;
        }
        this.transLabels(connection, ownerResource, labels);
    }

    private HasMetadata getOwnerResource(KubeConnection connection, OwnerReference ownerReference, String namespace) {
        HasMetadata data = null;
        switch (ownerReference.getKind()) {
            case "ReplicaSet": {
                Optional<ReplicaSet> replicaOptional = connection.get(ReplicaSet.class, namespace, ownerReference.getName());
                if (!replicaOptional.isPresent()) break;
                data = (HasMetadata)replicaOptional.get();
                break;
            }
            case "DaemonSet": {
                Optional<DaemonSet> daemonSetOptional = connection.get(DaemonSet.class, namespace, ownerReference.getName());
                if (!daemonSetOptional.isPresent()) break;
                data = (HasMetadata)daemonSetOptional.get();
                break;
            }
            case "StatefulSet": {
                Optional<StatefulSet> statefulSetOptional = connection.get(StatefulSet.class, namespace, ownerReference.getName());
                if (!statefulSetOptional.isPresent()) break;
                data = (HasMetadata)statefulSetOptional.get();
                break;
            }
            case "Deployment": {
                Optional<Deployment> deploymentOptional = connection.get(Deployment.class, namespace, ownerReference.getName());
                if (!deploymentOptional.isPresent()) break;
                data = (HasMetadata)deploymentOptional.get();
                break;
            }
        }
        return data;
    }

    private static Optional<OwnerReference> getOwnerReference(HasMetadata resource) {
        return resource.getMetadata().getOwnerReferences().stream().filter(ref -> HANDLE_LABELS_RESOURCE_KIND.contains(ref.getKind())).findFirst();
    }

    public ResourceSetInfo createKubeResourceSets(String devSn, ResourceSetInfo info) {
        VerifyUtil.checkStrs((String[])new String[]{devSn});
        info.setKubeId(devSn);
        ResourceSet resourceSet = KubeConvertUtil.transToResourceSet(info);
        LOGGER.info((Object)"Start create ResourceSet %s (namespace %s, labels: %s)", new Object[]{info.getName(), info.getNamespace(), info.getLabels()});
        String id = this.createResource(devSn, resourceSet, ResourceSet.class);
        info.setId(id);
        return info;
    }

    public void refreshKubeResourceSet(String kubeSn, String resourceSetName, Consumer<ResourceSetInfo> callback) {
        LOGGER.info((Object)"Start refresh ResourceSet %s", new Object[]{resourceSetName});
        KubeConnection connection = new KubeConnection(kubeSn);
        connection.edit(ResourceSet.class, resourceSetName, resourceSet -> ((ResourceSetSpec)resourceSet.getSpec()).setManualRefresh(true));
        if (callback != null) {
            long current;
            long startTime = System.currentTimeMillis();
            AtomicBoolean flag = new AtomicBoolean();
            LOGGER.info((Object)"refresh begin time: %s", new Object[]{String.valueOf(startTime)});
            do {
                KubeCommonUtils.sleepAndCatchInterrupt((long)5000L);
                Optional<ResourceSet> optional = connection.get(ResourceSet.class, resourceSetName);
                if (!optional.isPresent()) {
                    String message = "ResourceSet is not exist. name: " + resourceSetName;
                    throw new LegoCheckedException(201L, message);
                }
                ResourceSet resourceSet2 = optional.get();
                String status = ((ResourceSetStatus)resourceSet2.getStatus()).getStatus();
                if (!RESOURCE_SET_STATUS_REFRESHING.equals(status)) {
                    LOGGER.info((Object)"refresh end time: %s", new Object[]{String.valueOf(System.currentTimeMillis())});
                    ResourceSetInfo resourceSetInfo = KubeConvertUtil.transToResourceSet(resourceSet2, kubeSn);
                    this.setRsIncludePods(resourceSetInfo, kubeSn, connection);
                    callback.accept(resourceSetInfo);
                    return;
                }
                if (flag.compareAndSet(false, true)) {
                    LOGGER.warn((Object)"cdr refresh status on %s is not updated", new Object[]{kubeSn});
                    continue;
                }
                LOGGER.info((Object)"waiting for resource set of %s refresh complete", new Object[]{kubeSn});
            } while ((current = System.currentTimeMillis()) - startTime <= TimeUnit.MINUTES.toMillis(5L));
            LOGGER.error((Object)"monitor refresh resource set(%s) timeout", new Object[]{resourceSetName});
            throw new LegoCheckedException(1073947433L);
        }
    }

    private boolean isResourceSetInKube(String devSn, ResourceSetInfo info) {
        List<ResourceSetInfo> existResources = this.getResourceSetInfos(devSn);
        Optional<ResourceSetInfo> opt = existResources.stream().filter(existResource -> info.getName().equals(existResource.getName())).findAny();
        if (opt.isPresent()) {
            LOGGER.info((Object)"ResourceSet name: %s has already created in kube: %s.", new Object[]{info.getName(), info.getKubeId()});
            info.setId(opt.get().getId());
            return true;
        }
        LOGGER.info((Object)"ResourceSet name: %s not in kube: %s.", new Object[]{info.getName(), info.getKubeId()});
        return false;
    }

    public void deleteKubeResourceSet(String devSn, List<ResourceSetInfo> resourceSetList) {
        if (VerifyUtil.isEmpty(resourceSetList)) {
            LOGGER.info((Object)"Not find resourceSet.");
            return;
        }
        VerifyUtil.checkStrs((String[])new String[]{devSn});
        Set<String> nameSet = resourceSetList.stream().filter(item -> this.isResourceSetInKube(devSn, (ResourceSetInfo)item)).map(ResourceSetInfo::getName).collect(Collectors.toSet());
        if (!this.deleteKubeResourcesByType(devSn, ResourceSet.class, nameSet)) {
            throw new LegoCheckedException(1073947760L, new String[]{KubeEnumDefine.KubeResourceType.RESOURCESET.getValue()});
        }
    }

    public List<ResourceSetInfo> getResourceSetInfos(String devSn) {
        VerifyUtil.checkStrs((String[])new String[]{devSn});
        KubeConnection connection = new KubeConnection(devSn);
        List<ResourceSet> resourceSets = connection.getList(ResourceSet.class);
        return resourceSets.stream().map(item -> {
            ResourceSetInfo setInfo = KubeConvertUtil.transToResourceSet(item, devSn);
            this.setRsIncludePods(setInfo, devSn, connection);
            return setInfo;
        }).collect(Collectors.toList());
    }

    public Optional<ResourceSetInfo> getResourceSetInfo(String devSn, String resourceSetName) {
        VerifyUtil.checkStrs((String[])new String[]{devSn, resourceSetName});
        KubeConnection connection = new KubeConnection(devSn);
        Optional<ResourceSet> optional = connection.get(ResourceSet.class, resourceSetName);
        return optional.map(item -> {
            ResourceSetInfo setInfo = KubeConvertUtil.transToResourceSet(item, devSn);
            this.setRsIncludePods(setInfo, devSn, connection);
            return setInfo;
        });
    }

    private void setRsIncludePods(ResourceSetInfo info, String devSn, KubeConnection connection) {
        if (VerifyUtil.isEmpty((String)info.getResourceDetailName())) {
            return;
        }
        Optional<ResourceDetail> opt = this.getResourceDetail(devSn, info.getResourceDetailName());
        if (!opt.isPresent()) {
            LOGGER.error((Object)"Not find ResourceDetail by detailName: %s", new Object[]{info.getResourceDetailName()});
            return;
        }
        KubeConvertUtil.resetRsIncludePods(opt.get(), info, connection, info.getNamespace());
    }

    public List<KubeStorage> getStorageBackendClaims(String devSn) {
        VerifyUtil.checkStrs((String[])new String[]{devSn});
        KubeConnection connection = new KubeConnection(devSn);
        List<StorageBackendClaim> storageBackendClaims = connection.getList(StorageBackendClaim.class);
        List<StorageBackendContent> storageBackendContents = connection.getList(StorageBackendContent.class);
        List kubeStorages = storageBackendClaims.stream().map(sbc -> KubeConvertUtil.transStorageBackendClaim(sbc, storageBackendContents, devSn)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        ArrayList<KubeStorage> nasKubeStorages = new ArrayList<KubeStorage>();
        for (KubeStorage kubeStorage : kubeStorages) {
            KubeStorage storageByConfigMap = this.getStorageByConfigMap(devSn, kubeStorage.getNamespace(), kubeStorage.getName());
            kubeStorage.setIpAddress(storageByConfigMap.getIpAddress());
            kubeStorage.setStorageType(storageByConfigMap.getStorageType());
            nasKubeStorages.add(kubeStorage);
        }
        return nasKubeStorages;
    }

    public Optional<KubeStorage> getStorageBackendClaims(String devSn, String sbcName) {
        VerifyUtil.checkStrs((String[])new String[]{devSn, sbcName});
        KubeConnection connection = new KubeConnection(devSn);
        Optional<StorageBackendClaim> sbcOptional = connection.get(StorageBackendClaim.class, "huawei-csi", sbcName);
        if (!sbcOptional.isPresent()) {
            return Optional.empty();
        }
        StorageBackendClaim sbc = sbcOptional.get();
        Optional<StorageBackendContent> sbctOptional = connection.get(StorageBackendContent.class, ((StorageBackendClaimStatus)sbc.getStatus()).getBoundContentName());
        if (!sbctOptional.isPresent()) {
            return Optional.empty();
        }
        Optional<KubeStorage> kubeStorageOptional = KubeConvertUtil.transStorageBackendClaim(sbc, Collections.singletonList(sbctOptional.get()), devSn);
        if (!kubeStorageOptional.isPresent()) {
            return Optional.empty();
        }
        KubeStorage kubeStorage = kubeStorageOptional.get();
        KubeStorage storageByConfigMap = this.getStorageByConfigMap(devSn, kubeStorage.getNamespace(), kubeStorage.getName());
        kubeStorage.setIpAddress(storageByConfigMap.getIpAddress());
        kubeStorage.setStorageType(storageByConfigMap.getStorageType());
        return Optional.of(kubeStorage);
    }

    public Watch watchHyperMetroDomain(String devSn, String name, BiConsumer<Watcher.Action, Domain> callback) {
        KubeConnection connection = new KubeConnection(devSn);
        return connection.watch(name, HyperMetroDomain.class, (action, hyperMetroDomain) -> callback.accept((Watcher.Action)action, KubeConvertUtil.tansToKubeDomain(hyperMetroDomain)));
    }

    public void refreshHyperMetroDomain(String kubeSn, String domainName) {
        VerifyUtil.checkStrs((String[])new String[]{kubeSn, domainName});
        KubeConnection connection = new KubeConnection(kubeSn);
        Optional<HyperMetroDomain> optional = connection.get(HyperMetroDomain.class, domainName);
        if (!optional.isPresent()) {
            LOGGER.warn((Object)"The HyperMetroDomain (%s) is not present.", new Object[]{domainName});
            return;
        }
        connection.edit(HyperMetroDomain.class, domainName, domain -> {
            ObjectMeta metadata = domain.getMetadata();
            HashMap<String, String> labels = new HashMap<String, String>();
            labels.put("refreshByBcmAt", String.valueOf(System.currentTimeMillis()));
            metadata.setLabels(labels);
        });
    }

    public void modifyVolumeSpeed(String devSn, String planName, String newSpeed) {
        KubeConnection connection = new KubeConnection(devSn);
        Optional<ProtectionPlan> protectionPlanOpt = connection.get(ProtectionPlan.class, planName);
        if (!protectionPlanOpt.isPresent()) {
            LOGGER.error((Object)"Protection plan %s in device %s is not exist.", new Object[]{planName, devSn});
            throw new LegoCheckedException(2117645L);
        }
        connection.edit(ProtectionPlan.class, planName, plan -> {
            ProtectionPlanSpec spec = (ProtectionPlanSpec)plan.getSpec();
            spec.setVolumeSpeed(ProtectionPlanSpec.VolumeSpeed.getVolumeSpeed(newSpeed));
        });
    }

    private KubeStorage getStorageByConfigMap(String devSn, String nameSpace, String name) {
        KubeConnection connection = new KubeConnection(devSn);
        KubeStorage kubeStorage = new KubeStorage();
        Optional<ConfigMap> optionalConfigMap = connection.get(ConfigMap.class, nameSpace, name);
        Optional<CSIJson> csiJsonOpt = this.getCsiJsonFromConfigMap(optionalConfigMap);
        if (!csiJsonOpt.isPresent()) {
            return kubeStorage;
        }
        CSIJson csiJson = csiJsonOpt.get();
        Optional.ofNullable(csiJson.getBackends().getUrls()).ifPresent(urls -> kubeStorage.setIpAddress(Ipv4AddressUtil.getIpv4Addree((String)((String)urls.iterator().next()))));
        if (!"oceanstor-nas".equals(csiJson.getBackends().getStorage())) {
            return kubeStorage;
        }
        kubeStorage.setStorageType("oceanstor-nas");
        return kubeStorage;
    }

    private Optional<CSIJson> getCsiJsonFromConfigMap(Optional<ConfigMap> optionalConfigMap) {
        if (!optionalConfigMap.isPresent()) {
            return Optional.empty();
        }
        Map configDataMap = optionalConfigMap.get().getData();
        CSIJson csiJson = (CSIJson)JSONObject.toBean((String)((String)configDataMap.get("csi.json")), CSIJson.class);
        if (VerifyUtil.isEmpty((Object)csiJson)) {
            return Optional.empty();
        }
        return Optional.of(csiJson);
    }

    public void invalidCache() {
        KubeClientLoader.invalidCache();
    }

    public BackupLocationInfo createBackupLocation(String devSn, BackupLocationInfo locationInfo) {
        VerifyUtil.checkObject((Object)locationInfo);
        LOGGER.info((Object)"Start create BackupLocation %s", new Object[]{locationInfo.getName()});
        BackupLocation backupLocation = KubeConvertUtil.transToBackupLocation(locationInfo);
        String id = this.createResource(devSn, backupLocation, BackupLocation.class);
        locationInfo.setId(id);
        return locationInfo;
    }

    public void rebuildBackupLocation(String devSn, BackupLocationInfo backupLocationInfo) {
        VerifyUtil.checkStrs((String[])new String[]{devSn});
        VerifyUtil.checkObject((Object)backupLocationInfo);
        KubeConnection connection = new KubeConnection(devSn);
        connection.createOrReplace(BackupLocation.class, KubeConvertUtil.transToBackupLocation(backupLocationInfo));
    }

    public KubeSchedulePolicy createKubeSchedulePolicy(String devSn, KubeSchedulePolicy policyInfo) {
        VerifyUtil.checkObject((Object)policyInfo);
        LOGGER.info((Object)"Start create SchedulePolicy %s", new Object[]{policyInfo.getName()});
        SchedulePolicy schedulePolicy = KubeConvertUtil.transToSchedulePolicy(policyInfo);
        String id = this.createResource(devSn, schedulePolicy, SchedulePolicy.class);
        policyInfo.setId(id);
        return policyInfo;
    }

    public Optional<KubeSchedulePolicy> getKubeSchedulePolicy(String devSn, String policyName) {
        VerifyUtil.checkStrs((String[])new String[]{policyName});
        KubeConnection restConnection = new KubeConnection(devSn);
        Optional<SchedulePolicy> policyOptional = restConnection.get(SchedulePolicy.class, policyName);
        return policyOptional.map(KubeConvertUtil::transToSchedulePolicyInfo);
    }

    public BackupInstanceInfo createBackupInstance(String devSn, BackupInstanceInfo backupInstanceInfo) {
        VerifyUtil.checkObject((Object)backupInstanceInfo);
        LOGGER.info((Object)"Start create BackupInstance %s", new Object[]{backupInstanceInfo.getName()});
        BackupInstance backupInstance = KubeConvertUtil.transToBackupInstance(backupInstanceInfo);
        String id = this.createResource(devSn, backupInstance, BackupInstance.class);
        backupInstanceInfo.setId(id);
        return backupInstanceInfo;
    }

    public void rebuildBackupInstance(String devSn, BackupInstanceInfo backupInstanceInfo) {
        VerifyUtil.checkStrs((String[])new String[]{devSn});
        VerifyUtil.checkObject((Object)backupInstanceInfo);
        KubeConnection connection = new KubeConnection(devSn);
        connection.createOrReplace(BackupInstance.class, KubeConvertUtil.transToBackupInstance(backupInstanceInfo));
    }

    public KubeProtectionPlan createProtectionPlan(String devSn, KubeProtectionPlan kubeProtectionPlan) {
        VerifyUtil.checkObject((Object)kubeProtectionPlan);
        LOGGER.info((Object)"Start create ProtectionPlan %s", new Object[]{kubeProtectionPlan.getName()});
        ProtectionPlan protectionPlan = KubeConvertUtil.transToProtectPlan(kubeProtectionPlan);
        String id = this.createResource(devSn, protectionPlan, ProtectionPlan.class);
        kubeProtectionPlan.setId(id);
        return kubeProtectionPlan;
    }

    public Optional<KubeProtectionPlan> getProtectionPlan(String devSn, String name) {
        VerifyUtil.checkStrs((String[])new String[]{devSn});
        KubeConnection connection = new KubeConnection(devSn);
        Optional<ProtectionPlan> protectionPlanOpt = connection.get(ProtectionPlan.class, name);
        return protectionPlanOpt.map(KubeConvertUtil::transToKubeProtectPlan);
    }

    public boolean checkProtectionPlanExist(String devSn, String name) {
        VerifyUtil.checkStrs((String[])new String[]{devSn});
        KubeConnection connection = new KubeConnection(devSn);
        Optional<ProtectionPlan> protectionPlanOpt = connection.get(ProtectionPlan.class, name);
        return protectionPlanOpt.isPresent();
    }

    private <T extends HasMetadata> String createResource(String devSn, T kubeObj, Class<T> clazz) {
        KubeConnection connection = new KubeConnection(devSn);
        String name = kubeObj.getMetadata().getName();
        LOGGER.info((Object)"Begin to create resource with name: %s and type: %s.", new Object[]{name, clazz});
        T retResource = connection.create(clazz, kubeObj);
        String id = retResource.getMetadata().getUid();
        LOGGER.info((Object)"Create resource success with name %s and id: %s.", new Object[]{name, id});
        return id;
    }

    private <T extends HasMetadata> String createOrReplaceResource(String devSn, T kubeObj, Class<T> clazz) {
        KubeConnection connection = new KubeConnection(devSn);
        String name = kubeObj.getMetadata().getName();
        LOGGER.info((Object)"Begin to create resource with name: %s and type: %s.", new Object[]{name, clazz});
        T retResource = connection.createOrReplace(clazz, kubeObj);
        String id = retResource.getMetadata().getUid();
        LOGGER.info((Object)"Create resource success with name %s and id: %s.", new Object[]{name, id});
        return id;
    }

    public KubeRestoreJob createRestoreJob(String devSn, KubeRestoreJob kubeRestoreJob) {
        VerifyUtil.checkObject((Object)kubeRestoreJob);
        LOGGER.info((Object)"Start create RestoreJob %s", new Object[]{kubeRestoreJob.getName()});
        RestoreJob restoreJob = KubeConvertUtil.tansToRestoreJob(kubeRestoreJob);
        String id = this.createResource(devSn, restoreJob, RestoreJob.class);
        kubeRestoreJob.setId(id);
        return kubeRestoreJob;
    }

    public KubeRecoveryJob createRecoveryJob(String devSn, KubeRecoveryJob kubeRecoveryJob) {
        VerifyUtil.checkObject((Object)kubeRecoveryJob);
        LOGGER.info((Object)"Start create RecoveryJob %s of RecoveryPlan %s, operations : %s", new Object[]{kubeRecoveryJob.getName(), kubeRecoveryJob.getRecoveryPlanName(), kubeRecoveryJob.getOperation()});
        RecoveryJob recoveryJob = KubeConvertUtil.tansToRecoveryJob(kubeRecoveryJob);
        String id = this.createResource(devSn, recoveryJob, RecoveryJob.class);
        kubeRecoveryJob.setId(id);
        return kubeRecoveryJob;
    }

    public KubeRecoveryPlan createRecoveryPlan(String devSn, KubeRecoveryPlan kubeRecoveryPlan) {
        VerifyUtil.checkObject((Object)kubeRecoveryPlan);
        LOGGER.info((Object)"Start create RecoveryPlan %s of ProtectionPlan %s, role : %s, post-hook: %s", new Object[]{kubeRecoveryPlan.getName(), kubeRecoveryPlan.getProtectionPlanName(), kubeRecoveryPlan.getRole(), kubeRecoveryPlan.getPostHookName()});
        RecoveryPlan recoveryPlan = KubeConvertUtil.transToRecoveryPlan(kubeRecoveryPlan);
        String id = this.createResource(devSn, recoveryPlan, RecoveryPlan.class);
        kubeRecoveryPlan.setId(id);
        return kubeRecoveryPlan;
    }

    public void createVolumeSet(String devSn, KubeVolumeSet kubeVolumeSet) {
        VerifyUtil.checkObject((Object)kubeVolumeSet);
        LOGGER.info((Object)"Start create VolumeSet %s", new Object[]{kubeVolumeSet.getName()});
        VolumeSet volumeSet = KubeConvertUtil.tansToVolumeSet(kubeVolumeSet);
        String id = this.createResource(devSn, volumeSet, VolumeSet.class);
        kubeVolumeSet.setId(id);
    }

    public void updateVolumeSet(String devSn, KubeVolumeSet kubeVolumeSet) {
        KubeConnection connection = new KubeConnection(devSn);
        VolumeSet volumeSet = KubeConvertUtil.tansToVolumeSet(kubeVolumeSet);
        connection.createOrReplace(VolumeSet.class, volumeSet);
    }

    public void rebuildVolumeSet(String devSn, KubeVolumeSet kubeVolumeSet) {
        VerifyUtil.checkObject((Object)kubeVolumeSet);
        VolumeSet volumeSet = KubeConvertUtil.tansToVolumeSet(kubeVolumeSet);
        KubeConnection connection = new KubeConnection(devSn);
        connection.createOrReplace(VolumeSet.class, volumeSet);
    }

    public void deleteRecoveryPlan(String devSn, String recoveryName) {
        VerifyUtil.checkStrs((String[])new String[]{recoveryName});
        LOGGER.info((Object)"Start delete RecoveryPlan %s", new Object[]{recoveryName});
        HashSet<String> resourceNames = new HashSet<String>();
        resourceNames.add(recoveryName);
        this.deleteKubeResourcesByType(devSn, RecoveryPlan.class, resourceNames);
    }

    public List<KubeResourceSetPVC> getResourceSetPVCs(String devSn, String detailName) {
        if (VerifyUtil.isEmpty((String)detailName)) {
            return Collections.emptyList();
        }
        Optional<ResourceDetail> resourceDetailOpt = this.getResourceDetail(devSn, detailName);
        if (!resourceDetailOpt.isPresent()) {
            LOGGER.error((Object)"Not find resourceDetail by detailName: %s", new Object[]{detailName});
            return Collections.emptyList();
        }
        List<KubeResourceSetPVC> pvcList = KubeConvertUtil.transToResourceSetPVC(resourceDetailOpt.get());
        return pvcList.stream().map(resourceSetPVC -> this.transToPVCWithPVInfo(devSn, (KubeResourceSetPVC)resourceSetPVC)).collect(Collectors.toList());
    }

    private Optional<ResourceDetail> getResourceDetail(String devSn, String detailName) {
        VerifyUtil.checkStrs((String[])new String[]{detailName});
        KubeConnection connection = new KubeConnection(devSn);
        return connection.get(ResourceDetail.class, detailName);
    }

    public List<KubeResource> getDetailResourceList(String devSn, String detailName) {
        Optional<ResourceDetail> resourceDetailOpt = this.getResourceDetail(devSn, detailName);
        if (!resourceDetailOpt.isPresent()) {
            LOGGER.info((Object)"Query ResourceDetail ( %s ) failed, cause is it not present", new Object[]{detailName});
            return Collections.emptyList();
        }
        ResourceDetail resourceDetail = resourceDetailOpt.get();
        ResourceDetailStatus status = (ResourceDetailStatus)resourceDetail.getStatus();
        if (status == null) {
            LOGGER.info((Object)"Query ResourceDetail ( %s ) failed, cause it's status is empty", new Object[]{detailName});
            return Collections.emptyList();
        }
        List<Resources> resources = status.getResources();
        if (VerifyUtil.isEmpty(resources)) {
            LOGGER.info((Object)"Query ResourceDetail ( %s ) failed, cause it's Resources is empty", new Object[]{detailName});
            return Collections.emptyList();
        }
        return resources.stream().map(KubeConvertUtil::transToKubeResource).collect(Collectors.toList());
    }

    public boolean deleteResource(String devSn, String kind, String version, String name, String namespace) {
        Class klass = META_CLASSES.stream().filter(clazz -> clazz.getSimpleName().equals(kind) && Objects.equals(this.getMetadataVersion((Class)clazz), version)).findFirst().orElseThrow(() -> new LegoCheckedException(1073947393L));
        return this.deleteKubeResourcesByType(devSn, klass, version, namespace, Collections.singleton(name));
    }

    public String createReprotectionJob(String kubeSn, String recoveryPlanName, List<String> operations) {
        if (VerifyUtil.isEmpty((String)recoveryPlanName)) {
            throw new LegoCheckedException(1073947393L, "invalid recovery plan name");
        }
        String jobName = KubeResourceNameGenerator.generate();
        this.createReprotectionJob(kubeSn, recoveryPlanName, jobName, operations);
        return jobName;
    }

    public void createReprotectionJob(String kubeSn, String recoveryPlanName, String jobName, List<String> operations) {
        if (VerifyUtil.isEmpty((String)recoveryPlanName)) {
            throw new LegoCheckedException(1073947393L, "invalid recovery plan name");
        }
        KubeConnection connection = new KubeConnection(kubeSn);
        ReProtectionJobSpec spec = new ReProtectionJobSpec();
        spec.setRecoveryPlanName(recoveryPlanName);
        spec.setOperations(operations);
        ReProtectionJob request = new ReProtectionJob();
        ObjectMeta meta = new ObjectMeta();
        meta.setName(jobName);
        request.setMetadata(meta);
        request.setSpec(spec);
        LOGGER.info((Object)"Start create ReProtectionJob %s of RecoveryPlan %s, operations: %s", new Object[]{jobName, recoveryPlanName, String.join((CharSequence)",", operations)});
        connection.create(ReProtectionJob.class, request);
    }

    public String[] queryReprotectionJobProgress(String kubeSn, String jobName, String[] defaults) {
        KubeConnection connection = new KubeConnection(kubeSn);
        return connection.get(ReProtectionJob.class, jobName).map(job -> {
            ReProtectionJobStatus status = (ReProtectionJobStatus)job.getStatus();
            if (status == null) {
                return defaults;
            }
            return new String[]{status.getStage(), status.getState()};
        }).orElse(defaults);
    }

    private KubeResourceSetPVC transToPVCWithPVInfo(String devSn, KubeResourceSetPVC resourceSetPVCInfo) {
        Optional<KubePersistentVolume> opt = this.getPersistentVolume(devSn, resourceSetPVCInfo);
        opt.ifPresent(arg_0 -> ((KubeResourceSetPVC)resourceSetPVCInfo).setKubePV(arg_0));
        return resourceSetPVCInfo;
    }

    private Optional<KubePersistentVolume> getPersistentVolume(String devSn, KubeResourceSetPVC resourceSetPVC) {
        String pvcName = resourceSetPVC.getName();
        String namespace = resourceSetPVC.getNamespace();
        VerifyUtil.checkStrs((String[])new String[]{pvcName, namespace});
        KubeConnection connection = new KubeConnection(devSn);
        Optional<PersistentVolumeClaim> pvcOpt = connection.get(PersistentVolumeClaim.class, namespace, pvcName);
        if (!pvcOpt.isPresent()) {
            LOGGER.error((Object)"Not find PersistentVolumeClaim by name: %s ", new Object[]{pvcName});
            return Optional.empty();
        }
        String volumeName = pvcOpt.map(PersistentVolumeClaim::getSpec).map(PersistentVolumeClaimSpec::getVolumeName).orElse(null);
        if (VerifyUtil.isEmpty((String)volumeName)) {
            return Optional.empty();
        }
        Optional<PersistentVolume> pvOpt = connection.get(PersistentVolume.class, volumeName);
        if (!pvOpt.isPresent()) {
            LOGGER.error((Object)"Not find PersistentVolume by name: %s ", new Object[]{volumeName});
            return Optional.empty();
        }
        return KubeConvertUtil.transToKubePVs(pvOpt.get());
    }

    public void changeProtectionPlan(String devSn, ProtectGroup protectGroup) {
        VerifyUtil.checkStrs((String[])new String[]{devSn});
        ProtectionPlan protectionPlan = new ProtectionPlan();
        KubeConnection connection = new KubeConnection(devSn);
        for (ProtectObject po : protectGroup.getPolist()) {
            Optional<ProtectionPlan> protectionPlanOpt = connection.get(ProtectionPlan.class, po.getName());
            if (!protectionPlanOpt.isPresent()) continue;
            protectionPlan = protectionPlanOpt.get();
            ((ProtectionPlanStatus)protectionPlan.getStatus()).setStatus(String.valueOf(protectGroup.getStatus()));
            connection.createOrReplace(ProtectionPlan.class, protectionPlan);
        }
    }

    public void changeBackUpInstance(String devSn, ProtectGroup protectGroup) {
        VerifyUtil.checkStrs((String[])new String[]{devSn});
        KubeConnection connection = new KubeConnection(devSn);
        for (ProtectObject po : protectGroup.getPolist()) {
            Optional<BackupInstance> backupInstanceOpt = connection.get(BackupInstance.class, po.getName());
            if (!backupInstanceOpt.isPresent()) continue;
            BackupInstance backupInstance = backupInstanceOpt.get();
            ((BackupInstanceStatus)backupInstance.getStatus()).setStatus(String.valueOf(protectGroup.getStatus()));
            connection.createOrReplace(BackupInstance.class, backupInstance);
        }
    }

    public Optional<KubeRecoveryPlan> getKubeRecoveryPlan(String devSn, String recoveryName) {
        VerifyUtil.checkStrs((String[])new String[]{recoveryName});
        KubeConnection restConnection = new KubeConnection(devSn);
        Optional<RecoveryPlan> opt = restConnection.get(RecoveryPlan.class, recoveryName);
        return opt.flatMap(KubeConvertUtil::transToKubeRecoveryPlan);
    }

    public Optional<KubePersistentVolume> getKubePersistentVolume(String devSn, String volumeName) {
        if (VerifyUtil.isEmpty((String)volumeName)) {
            return Optional.empty();
        }
        KubeConnection connection = new KubeConnection(devSn);
        Optional<PersistentVolume> pvOpt = connection.get(PersistentVolume.class, volumeName);
        if (!pvOpt.isPresent()) {
            LOGGER.error((Object)"Not find PersistentVolume by name: %s ", new Object[]{volumeName});
            return Optional.empty();
        }
        return KubeConvertUtil.transToKubePVs(pvOpt.get());
    }

    public boolean deleteBackupInstance(String devSn, List<BackupInstanceInfo> backupInstanceInfos) {
        VerifyUtil.checkStrs((String[])new String[]{devSn});
        if (VerifyUtil.isEmpty(backupInstanceInfos)) {
            LOGGER.warn((Object)"BackupInstanceInfo in device %s is empty", new Object[]{SecurityUtil.desensitization((String)devSn)});
            return true;
        }
        HashSet<String> resourceNames = new HashSet<String>(backupInstanceInfos.size());
        backupInstanceInfos.forEach(backupInstanceInfo -> resourceNames.add(backupInstanceInfo.getName()));
        return this.deleteKubeResourcesByType(devSn, BackupInstance.class, resourceNames);
    }

    public boolean checkInstanceExist(String devSn, String instanceName) {
        VerifyUtil.checkStrs((String[])new String[]{devSn, instanceName});
        KubeConnection connection = new KubeConnection(devSn);
        Optional<BackupInstance> backupInstanceOpt = connection.get(BackupInstance.class, instanceName);
        return backupInstanceOpt.isPresent();
    }

    public boolean deleteBackupInstance(String devSn, String backupInstanceName) {
        VerifyUtil.checkStrs((String[])new String[]{devSn});
        return this.deleteKubeResourcesByType(devSn, BackupInstance.class, Collections.singleton(backupInstanceName));
    }

    public boolean deleteBackupLocations(String devSn, List<BackupLocationInfo> backupLocationInfos) {
        VerifyUtil.checkStrs((String[])new String[]{devSn});
        if (VerifyUtil.isEmpty(backupLocationInfos)) {
            LOGGER.warn((Object)"BackupLocationInfo in device %s is empty", new Object[]{SecurityUtil.desensitization((String)devSn)});
            return true;
        }
        HashSet<String> resourceNames = new HashSet<String>(backupLocationInfos.size());
        backupLocationInfos.forEach(backupLocationInfo -> resourceNames.add(backupLocationInfo.getName()));
        return this.deleteKubeResourcesByType(devSn, BackupLocation.class, resourceNames);
    }

    public boolean deleteProtectionPlan(String devSn, List<KubeProtectionPlan> protectionPlans) {
        VerifyUtil.checkStrs((String[])new String[]{devSn});
        if (VerifyUtil.isEmpty(protectionPlans)) {
            LOGGER.warn((Object)"KubeProtectionPlan in device %s is empty", new Object[]{SecurityUtil.desensitization((String)devSn)});
            return true;
        }
        HashSet<String> resourceNames = new HashSet<String>(protectionPlans.size());
        protectionPlans.forEach(protectionPlan -> resourceNames.add(protectionPlan.getName()));
        return this.deleteKubeResourcesByType(devSn, ProtectionPlan.class, resourceNames);
    }

    public boolean deleteSchedulePolicy(String devSn, List<KubeSchedulePolicy> policyList) {
        VerifyUtil.checkStrs((String[])new String[]{devSn});
        if (VerifyUtil.isEmpty(policyList)) {
            LOGGER.warn((Object)"Schedule in device %s is empty", new Object[]{SecurityUtil.desensitization((String)devSn)});
            return true;
        }
        HashSet<String> resourceNames = new HashSet<String>(policyList.size());
        policyList.forEach(policy -> resourceNames.add(policy.getName()));
        return this.deleteKubeResourcesByType(devSn, SchedulePolicy.class, resourceNames);
    }

    public boolean deletePersistentVolumeClaim(String devSn, List<PersistentVolumeClaimInfo> persistentVolumeClaims) {
        VerifyUtil.checkStrs((String[])new String[]{devSn});
        if (VerifyUtil.isEmpty(persistentVolumeClaims)) {
            LOGGER.warn((Object)"PersistentVolumeClaimInfo in device %s is empty", new Object[]{SecurityUtil.desensitization((String)devSn)});
            return true;
        }
        KubeConnection connection = new KubeConnection(devSn);
        try {
            for (PersistentVolumeClaimInfo persistentVolumeClaimInfo : persistentVolumeClaims) {
                Optional<PersistentVolumeClaim> persistentVolumeClaim = connection.get(PersistentVolumeClaim.class, persistentVolumeClaimInfo.getNameSpace(), persistentVolumeClaimInfo.getName());
                persistentVolumeClaim.ifPresent(volumeClaim -> this.deleteKubeResources(connection, PersistentVolumeClaim.class, volumeClaim));
            }
            return true;
        }
        catch (LegoCheckedException | KubernetesClientException e) {
            LOGGER.error((Object)"Delete kubeResource:%s failed. DeviceSn:%s", new Object[]{PersistentVolumeClaim.class.getName(), SecurityUtil.desensitization((String)devSn)});
            return false;
        }
    }

    public boolean deleteStorageClass(String devSn, List<StorageClassInfo> storageClasses) {
        VerifyUtil.checkStrs((String[])new String[]{devSn});
        if (VerifyUtil.isEmpty(storageClasses)) {
            LOGGER.warn((Object)"StorageClassInfo in device %s is empty", new Object[]{SecurityUtil.desensitization((String)devSn)});
            return true;
        }
        HashSet<String> shouldRemoveSCNames = new HashSet<String>();
        KubeConnection connection = new KubeConnection(devSn);
        for (StorageClassInfo scInfo : storageClasses) {
            StorageClass storageClass;
            Map labels;
            Optional<StorageClass> optional = connection.get(StorageClass.class, scInfo.getName());
            if (!optional.isPresent() || VerifyUtil.isEmpty((Map)(labels = (storageClass = optional.get()).getMetadata().getLabels())) || !labels.containsKey("createByBcmAt")) continue;
            shouldRemoveSCNames.add(storageClass.getMetadata().getName());
        }
        if (VerifyUtil.isEmpty(shouldRemoveSCNames)) {
            return true;
        }
        return this.deleteKubeResourcesByType(devSn, StorageClass.class, shouldRemoveSCNames);
    }

    public StorageClassInfo createStorageClass(String devSn, StorageClassInfo classInfo) {
        VerifyUtil.checkObject((Object)classInfo);
        VerifyUtil.checkStrs((String[])new String[]{classInfo.getName()});
        LOGGER.info((Object)"Start create StorageClass %s", new Object[]{classInfo.getName()});
        StorageClass storageClass = KubeConvertUtil.transToStorageClass(classInfo);
        String id = this.createResource(devSn, storageClass, StorageClass.class);
        classInfo.setId(id);
        return classInfo;
    }

    public List<StorageClassInfo> getStorageClasses(String devSn) {
        VerifyUtil.checkStrs((String[])new String[]{devSn});
        KubeConnection connection = new KubeConnection(devSn);
        List<StorageClass> classList = connection.getList(StorageClass.class);
        return classList.stream().map(KubeConvertUtil::transToSCInfo).collect(Collectors.toList());
    }

    public Optional<StorageClassInfo> getStorageClassByName(String devSn, String name) {
        VerifyUtil.checkStrs((String[])new String[]{name});
        KubeConnection connection = new KubeConnection(devSn);
        Optional<StorageClass> opt = connection.get(StorageClass.class, name);
        return opt.map(KubeConvertUtil::transToSCInfo);
    }

    public Optional<PersistentVolumeClaimInfo> getPersistentVolumeClaimInfo(String devSn, String pvcName, String namespace) {
        VerifyUtil.checkStrs((String[])new String[]{devSn, pvcName, namespace});
        KubeConnection connection = new KubeConnection(devSn);
        Optional<PersistentVolumeClaim> opt = connection.get(PersistentVolumeClaim.class, namespace, pvcName);
        Optional<PersistentVolumeClaimInfo> pvcOpt = opt.map(KubeConvertUtil::transToPVCInfo);
        if (!pvcOpt.isPresent()) {
            return pvcOpt;
        }
        this.buildFileSystemName(devSn, pvcOpt.get());
        return pvcOpt;
    }

    public PersistentVolumeClaimInfo createPersistentVolumeClaim(String devSn, PersistentVolumeClaimInfo claimInfo) {
        VerifyUtil.checkObject((Object)claimInfo);
        LOGGER.info((Object)"Start create PersistentVolumeClaim %s", new Object[]{claimInfo.getName()});
        PersistentVolumeClaim pvc = KubeConvertUtil.transToPVCInKube(claimInfo);
        String id = this.createResource(devSn, pvc, PersistentVolumeClaim.class);
        claimInfo.setId(id);
        return claimInfo;
    }

    private void buildFileSystemName(String devSn, PersistentVolumeClaimInfo pvc) {
        if (VerifyUtil.isEmpty((String)pvc.getVolumeName())) {
            LOGGER.warn((Object)"Build file system name canceled, cause volume name is empty.");
            return;
        }
        KubeConnection connection = new KubeConnection(devSn);
        Optional<PersistentVolume> pvOpt = connection.get(PersistentVolume.class, pvc.getVolumeName());
        if (!pvOpt.isPresent()) {
            LOGGER.error((Object)"Could not find PV by PVC (name: %s, namespace: %s) .", new Object[]{pvc.getName(), pvc.getNameSpace()});
            throw new LegoCheckedException(2117645L);
        }
        CSIPersistentVolumeSource csi = pvOpt.get().getSpec().getCsi();
        if (csi == null) {
            return;
        }
        String volumeHandle = csi.getVolumeHandle();
        if (StringUtils.isEmpty((CharSequence)volumeHandle)) {
            LOGGER.error((Object)"Could not find file system by PVC (name: %s, namespace: %s) .", new Object[]{pvc.getName(), pvc.getNameSpace()});
            throw new LegoCheckedException(2117645L);
        }
        String[] volumeHandleSplitArray = volumeHandle.split("\\.");
        if (volumeHandleSplitArray.length != 2) {
            LOGGER.error((Object)"Could not find file system by PVC (name: %s, namespace: %s) .", new Object[]{pvc.getName(), pvc.getNameSpace()});
            throw new LegoCheckedException(2117645L);
        }
        pvc.setFileSystemName(volumeHandleSplitArray[1]);
    }

    public void rebuildProtectionPlan(String devSn, KubeProtectionPlan kubeProtectionPlan) {
        KubeConnection connection = new KubeConnection(devSn);
        ProtectionPlan protectionPlan = KubeConvertUtil.transToProtectPlan(kubeProtectionPlan);
        connection.createOrReplace(ProtectionPlan.class, protectionPlan);
    }

    public void rebuildProtectionPlan(String devSn, String planName) {
        KubeConnection connection = new KubeConnection(devSn);
        Optional<ProtectionPlan> protectionPlanOpt = connection.get(ProtectionPlan.class, planName);
        if (!protectionPlanOpt.isPresent()) {
            LOGGER.error((Object)"Protection plan %s in device %s is not exist.", new Object[]{planName, devSn});
            throw new LegoCheckedException(2117645L);
        }
        ProtectionPlan plan = protectionPlanOpt.get();
        ((ProtectionPlanSpec)plan.getSpec()).setRebuildSwitch(true);
        connection.createOrReplace(ProtectionPlan.class, plan);
    }

    public void editProtectionPlanWithEnable(String devSn, String planName, boolean isEnable) {
        KubeConnection connection = new KubeConnection(devSn);
        Optional<ProtectionPlan> protectionPlanOpt = connection.get(ProtectionPlan.class, planName);
        if (!protectionPlanOpt.isPresent()) {
            LOGGER.error((Object)"Protection plan %s in device %s is not exist.", new Object[]{planName, devSn});
            throw new LegoCheckedException(2117645L);
        }
        connection.edit(ProtectionPlan.class, planName, plan -> {
            ProtectionPlanSpec spec = (ProtectionPlanSpec)plan.getSpec();
            spec.setEnable(isEnable);
        });
    }

    public List<BackupInstanceInfo> getBackupInstanceInfos(String devSn) {
        VerifyUtil.checkStrs((String[])new String[]{devSn});
        KubeConnection connection = new KubeConnection(devSn);
        List<BackupInstance> backupInstances = connection.getList(BackupInstance.class);
        return backupInstances.stream().map(KubeConvertUtil::transToBackupInstanceInfo).collect(Collectors.toList());
    }

    public BackupInstanceInfo getBackupInstanceInfo(String devSn, String instanceName) {
        VerifyUtil.checkStrs((String[])new String[]{devSn});
        KubeConnection connection = new KubeConnection(devSn);
        BackupInstance backupInstance = connection.get(BackupInstance.class, instanceName).orElseThrow(() -> new LegoCheckedException(2117645L, "BackupInstance not exist."));
        return KubeConvertUtil.transToBackupInstanceInfo(backupInstance);
    }

    public List<BackupLocationInfo> getBackupLocationInfos(String devSn) {
        VerifyUtil.checkStrs((String[])new String[]{devSn});
        KubeConnection connection = new KubeConnection(devSn);
        List<BackupLocation> backupLocations = connection.getList(BackupLocation.class);
        return backupLocations.stream().map(KubeConvertUtil::transToBackupLocationInfo).collect(Collectors.toList());
    }

    public List<KubeSchedulePolicy> getKubeSchedulePolicys(String devSn) {
        VerifyUtil.checkStrs((String[])new String[]{devSn});
        KubeConnection connection = new KubeConnection(devSn);
        List<SchedulePolicy> schedulePolicies = connection.getList(SchedulePolicy.class);
        return schedulePolicies.stream().map(KubeConvertUtil::transToPolicy).collect(Collectors.toList());
    }

    public List<PersistentVolumeClaimInfo> getKubePersistentVolumeClaims(String devSn, String nameSpace) {
        VerifyUtil.checkStrs((String[])new String[]{devSn});
        KubeConnection connection = new KubeConnection(devSn);
        List<PersistentVolumeClaim> persistentVolumeClaims = connection.getList(PersistentVolumeClaim.class, nameSpace);
        ArrayList<PersistentVolumeClaimInfo> infos = new ArrayList<PersistentVolumeClaimInfo>(persistentVolumeClaims.size());
        persistentVolumeClaims.forEach(claim -> infos.add(KubeConvertUtil.transToPersistentVolumeClaimInfo(claim)));
        return infos;
    }

    public List<String> getNameSpaces(String devSn) {
        VerifyUtil.checkStrs((String[])new String[]{devSn});
        KubeConnection connection = new KubeConnection(devSn);
        List<Namespace> namespaceList = connection.getList(Namespace.class);
        if (VerifyUtil.isEmpty(namespaceList)) {
            return Collections.emptyList();
        }
        ArrayList<String> names = new ArrayList<String>();
        namespaceList.forEach(namespace -> names.add(namespace.getMetadata().getName()));
        return names;
    }

    public void createCluster(String devSn, ClusterInfo clusterInfo) {
        VerifyUtil.checkObjs((Object[])new Object[]{devSn, clusterInfo});
        if (VerifyUtil.isEmpty((String)clusterInfo.getName()) || VerifyUtil.isEmpty((String)clusterInfo.getUrl())) {
            LOGGER.error((Object)"Create cluster name or url empty.");
            throw new LegoCheckedException(1073947393L);
        }
        Cluster cluster = KubeConvertUtil.transToCluster(clusterInfo);
        clusterInfo.setId(this.createOrReplaceResource(devSn, cluster, Cluster.class));
    }

    public boolean deleteCluster(String devSn, String clusterName) {
        VerifyUtil.checkStrs((String[])new String[]{clusterName});
        return this.deleteKubeResourcesByType(devSn, Cluster.class, new HashSet<String>(Collections.singletonList(clusterName)));
    }

    public void rebuildSchedule(String devSn, List<KubeSchedulePolicy> policies) {
        KubeConnection connection = new KubeConnection(devSn);
        policies.forEach(policy -> connection.createOrReplace(SchedulePolicy.class, KubeConvertUtil.transToSchedulePolicy(policy)));
    }

    public KubeProtectionJob createProtectionJob(String devSn, KubeProtectionJob kubeProtectionJob) {
        VerifyUtil.checkObject((Object)kubeProtectionJob);
        LOGGER.info((Object)"Start create ProtectionJob %s of ProtectionPlan %s", new Object[]{kubeProtectionJob.getName(), kubeProtectionJob.getProtectionPlanName()});
        ProtectionJob protectionJob = KubeConvertUtil.tansToProtectionJob(kubeProtectionJob);
        String id = this.createResource(devSn, protectionJob, ProtectionJob.class);
        kubeProtectionJob.setId(id);
        return kubeProtectionJob;
    }

    public KubeBackupJob createBackupJob(String devSn, KubeBackupJob backupJob) {
        VerifyUtil.checkObject((Object)backupJob);
        LOGGER.info((Object)"Start create BackupJob %s of BackupInstance %s", new Object[]{backupJob.getName(), backupJob.getBackupInstanceName()});
        BackupJob job = KubeConvertUtil.tansToBackupJob(backupJob);
        String id = this.createResource(devSn, job, BackupJob.class);
        backupJob.setId(id);
        return backupJob;
    }

    private <T extends HasMetadata> boolean deleteKubeResourcesByType(String devSn, Class<T> clazz, Set<String> names) {
        if (VerifyUtil.isEmpty(names)) {
            LOGGER.info((Object)"Delete %s canceled, cause there's no object to be deleted is specified.", new Object[]{clazz.getSimpleName()});
            return true;
        }
        LOGGER.info((Object)"Start delete %s ( %s )", new Object[]{clazz.getSimpleName(), String.join((CharSequence)",", names)});
        return this.deleteKubeResourcesByType(devSn, clazz, null, null, names);
    }

    private <T extends HasMetadata> boolean deleteKubeResourcesByType(String devSn, Class<T> clazz, String version, String namespace, Set<String> names) {
        KubeConnection connection = new KubeConnection(devSn);
        try {
            List<HasMetadata> kubeResources = this.queryKubeResourcesByType(clazz, connection, version, namespace, names);
            kubeResources.forEach(kubeResource -> this.deleteKubeResources(connection, clazz, kubeResource));
        }
        catch (LegoCheckedException | KubernetesClientException e) {
            LOGGER.error((Object)"Delete kubeResource:%s failed. DeviceSn:%s. Error message:%s", new Object[]{clazz.getName(), SecurityUtil.desensitization((String)devSn), e.getMessage()});
            return false;
        }
        return true;
    }

    private <T extends HasMetadata> List<T> queryKubeResourcesByType(Class<T> clazz, KubeConnection connection, String version, String namespace, Set<String> names) {
        return connection.getList(clazz).stream().filter(resource -> version == null || version.equals(this.getMetadataVersion(resource.getClass()))).filter(resource -> namespace == null || namespace.equals(this.getKubeResourceNameSpace(resource))).filter(kubeResource -> names.contains(this.getKubeResourceName(kubeResource))).collect(Collectors.toList());
    }

    private <T extends HasMetadata> String getMetadataVersion(Class<T> clazz) {
        String group = HasMetadata.getGroup(clazz);
        String version = HasMetadata.getVersion(clazz);
        return Stream.of(group, version).filter(item -> !item.isEmpty()).collect(Collectors.joining("/"));
    }

    private <T extends HasMetadata> String getKubeResourceName(T kubeResource) {
        return this.getMetadata(kubeResource, ObjectMeta::getName);
    }

    private <T extends HasMetadata, V> V getMetadata(T kubeResource, Function<ObjectMeta, V> getter) {
        return Optional.ofNullable(kubeResource).map(HasMetadata::getMetadata).map(getter).orElse(null);
    }

    private <T extends HasMetadata> String getKubeResourceNameSpace(T kubeResource) {
        return this.getMetadata(kubeResource, ObjectMeta::getNamespace);
    }

    private <T extends HasMetadata> void deleteKubeResources(KubeConnection connection, Class<T> clazz, T kubeResource) {
        connection.delete(clazz, kubeResource);
    }

    public List<KubeEvent> getKubeEvent(String devSn, String jobName) {
        VerifyUtil.checkStrs((String[])new String[]{devSn, jobName});
        KubeConnection restConnection = new KubeConnection(devSn);
        List<Event> events = restConnection.getByField(Event.class, "involvedObject.name", jobName);
        return events.stream().map(KubeConvertUtil::transKubeEvent).collect(Collectors.toList());
    }

    public Optional<KubeRecoveryJob> getKubeRecoveryJobByName(String devSn, String jobName) {
        VerifyUtil.checkStrs((String[])new String[]{devSn});
        VerifyUtil.checkStrs((String[])new String[]{jobName});
        KubeConnection restConnection = new KubeConnection(devSn);
        Optional<RecoveryJob> recoveryJobOptional = restConnection.get(RecoveryJob.class, jobName);
        return recoveryJobOptional.map(KubeConvertUtil::tansToBcmRecoveryJob);
    }

    public void modifyRecoveryJob(String devSn, String jobName, String newOperation) {
        VerifyUtil.checkStrs((String[])new String[]{devSn, jobName, newOperation});
        LOGGER.info((Object)"Start modify RecoveryJob %s with operation %s", new Object[]{jobName, newOperation});
        KubeConnection connection = new KubeConnection(devSn);
        Optional<RecoveryJob> jobOptional = connection.get(RecoveryJob.class, jobName);
        if (!jobOptional.isPresent()) {
            LOGGER.error((Object)"Modify kubernetes recovery job error, cause target job is not exist. job name : %s", new Object[]{jobName});
            throw new LegoCheckedException(2117645L);
        }
        connection.edit(RecoveryJob.class, jobName, job -> {
            RecoveryJobSpec spec = (RecoveryJobSpec)job.getSpec();
            spec.setOperation(RecoveryJobSpec.Operation.getRecoveryJobOperation(newOperation));
        });
    }

    public void modifyRecoveryPlan(String devSn, String planName, String newHook) {
        VerifyUtil.checkStrs((String[])new String[]{devSn, planName});
        KubeConnection connection = new KubeConnection(devSn);
        Optional<RecoveryPlan> planOptional = connection.get(RecoveryPlan.class, planName);
        if (!planOptional.isPresent()) {
            LOGGER.error((Object)"Modify kubernetes recovery plan error, cause target plan is not exist. plan name : %s", new Object[]{planName});
            throw new LegoCheckedException(2117645L);
        }
        RecoveryPlan existPlan = planOptional.get();
        if (StringUtils.equals((CharSequence)((RecoveryPlanSpec)existPlan.getSpec()).getPostHookName(), (CharSequence)newHook)) {
            LOGGER.warn((Object)"Modify kubernetes recovery plan canceled, cause post hook is same with earlier. plan name : %s, post hook: %s", new Object[]{planName, newHook});
            return;
        }
        LOGGER.info((Object)"Start modify RecoveryPlan %s with hook %s", new Object[]{planName, newHook});
        connection.edit(RecoveryPlan.class, planName, plan -> {
            RecoveryPlanSpec spec = (RecoveryPlanSpec)plan.getSpec();
            spec.setPostHookName(newHook);
        });
    }

    private <T extends HasMetadata> void modifyResource(String devSn, T kubeObj, Class<T> clazz) {
        KubeConnection connection = new KubeConnection(devSn);
        String name = kubeObj.getMetadata().getName();
        LOGGER.info((Object)"Begin to modify resource with name: %s and type: %s.", new Object[]{name, clazz});
        connection.createOrReplace(clazz, kubeObj);
        LOGGER.info((Object)"Modify resource success with name %s", new Object[]{name});
    }

    public void clearClusterTaint(String devSn, List<String> targetKeys) {
        KubeConnection connection = new KubeConnection(devSn);
        List<Node> nodes = connection.getList(Node.class);
        for (Node node : nodes) {
            List taints;
            if (this.isMasterNode(node) || VerifyUtil.isEmpty((Collection)(taints = node.getSpec().getTaints()))) continue;
            boolean shouldUpdate = true;
            int oldTaintSize = taints.size();
            if (!VerifyUtil.isEmpty(targetKeys)) {
                taints.removeIf(taint -> targetKeys.contains(taint.getKey()));
                int newTaintSize = taints.size();
                if (oldTaintSize == newTaintSize) {
                    shouldUpdate = false;
                }
            } else {
                node.getSpec().setTaints(new ArrayList());
            }
            if (!shouldUpdate) continue;
            LOGGER.info((Object)"Start clear cluster taints in handler.DeviceSn: %s", new Object[]{devSn});
            this.modifyResource(devSn, node, Node.class);
        }
    }

    public Optional<KubeRestoreJob> getKubeRestoreJob(String devSn, String jobName) {
        VerifyUtil.checkStrs((String[])new String[]{devSn, jobName});
        KubeConnection connection = new KubeConnection(devSn);
        Optional<RestoreJob> opt = connection.get(RestoreJob.class, jobName);
        return opt.map(KubeConvertUtil::tansToBcmRestoreJob);
    }

    public Optional<KubeReProtectionJob> getKubeReProtectionJob(String devSn, String jobName) {
        VerifyUtil.checkStrs((String[])new String[]{devSn, jobName});
        KubeConnection connection = new KubeConnection(devSn);
        Optional<ReProtectionJob> opt = connection.get(ReProtectionJob.class, jobName);
        return opt.map(KubeConvertUtil::tansToBcmReProtectionJob);
    }

    public void addPodImagePrefix(String kubeSn, String namespace, String podName, String prefix) {
        KubeConnection connection = new KubeConnection(kubeSn);
        Optional<Pod> opt = connection.get(Pod.class, namespace, podName);
        if (!opt.isPresent()) {
            LOGGER.warn((Object)"Disable pod canceled, cause target pod ( name: %s, namespace: %s ) is not present,it may has been deleted", new Object[]{podName, namespace});
            return;
        }
        Consumer<Container> edit = container -> container.setImage(prefix + container.getImage());
        LOGGER.info((Object)"Start add a prefix to image of the pod (pod: %s, namespace: %s, prefix: %s)", new Object[]{podName, namespace, prefix});
        connection.edit(Pod.class, namespace, podName, pod -> {
            PodSpec spec = pod.getSpec();
            spec.getInitContainers().forEach(edit);
            spec.getContainers().forEach(edit);
        });
    }

    public boolean checkAllContainerOfPodDisabled(String kubeSn, String namespace, String podName) {
        KubeConnection connection = new KubeConnection(kubeSn);
        return connection.get(Pod.class, namespace, podName).map(Pod::getStatus).map(status -> status.getContainerStatuses().stream().allMatch(a -> a.getState().getRunning() == null)).orElse(true);
    }

    public void modifyReplicaOfReplicaSet(String kubeSn, String namespace, String replicaSetName, int replica) {
        LOGGER.info((Object)"Start modify replicas of the ReplicaSet %s in namespace %s ( new replicas: %s )", new Object[]{replicaSetName, namespace, replica});
        this.replace(kubeSn, ReplicaSet.class, namespace, replicaSetName, replicaSet -> replicaSet.getSpec().setReplicas(Integer.valueOf(replica)));
    }

    public void modifyReplicaOfDeployment(String kubeSn, String namespace, String deploymentName, int replica) {
        LOGGER.info((Object)"Start modify replicas of the Deployment %s in namespace %s ( new replicas: %s )", new Object[]{deploymentName, namespace, replica});
        this.replace(kubeSn, Deployment.class, namespace, deploymentName, deployment -> deployment.getSpec().setReplicas(Integer.valueOf(replica)));
    }

    public void modifyReplicaOfStatefulSet(String kubeSn, String namespace, String statefulSetName, int replica) {
        LOGGER.info((Object)"Start modify replicas of the StatefulSet %s in namespace %s ( new replicas: %s )", new Object[]{statefulSetName, namespace, replica});
        this.replace(kubeSn, StatefulSet.class, namespace, statefulSetName, statefulSet -> statefulSet.getSpec().setReplicas(Integer.valueOf(replica)));
    }

    private <T extends HasMetadata> void replace(String kubeSn, Class<T> type, String namespace, String name, Consumer<T> function) {
        KubeConnection connection = new KubeConnection(kubeSn);
        Optional<T> optional = connection.get(type, namespace, name);
        if (!optional.isPresent()) {
            return;
        }
        HasMetadata resource = (HasMetadata)optional.get();
        function.accept(resource);
        connection.createOrReplace(type, namespace, resource);
    }

    public void modifyDaemonSetNodeSelector(String kubeSn, String namespace, String daemonSetName, String key, String value) {
        this.replace(kubeSn, DaemonSet.class, namespace, daemonSetName, daemonSet -> {
            PodSpec podSpec = daemonSet.getSpec().getTemplate().getSpec();
            Map nodeSelector = Optional.ofNullable(podSpec.getNodeSelector()).orElseGet(HashMap::new);
            if (value != null) {
                nodeSelector.put(key, value);
            } else {
                nodeSelector.remove(key);
            }
            podSpec.setNodeSelector(nodeSelector);
        });
    }

    public Optional<KubeBackup> getBackupByBackupJob(String kubeSn, String backupJobName) {
        KubeConnection connection = new KubeConnection(kubeSn);
        Optional<Backup> optional = connection.getOneByLabelKey(Backup.class, "backupjob.xuanwu.huawei.io/" + backupJobName);
        return optional.map(KubeConvertUtil::transToBcmBackup);
    }

    public List<KubeBackupJob> getBackupJobByInstance(String kubeSn, String backupInstanceName) {
        KubeConnection connection = new KubeConnection(kubeSn);
        List<BackupJob> backupJobs = connection.getListByLabelAndWithoutLabelKey(BackupJob.class, "backupinstance.xuanwu.huawei.io/" + backupInstanceName, "bcm-backupjob");
        return backupJobs.stream().map(KubeConvertUtil::tansToBcmBackupJob).collect(Collectors.toList());
    }

    public List<KubeProtectionJob> getProtectionJobs(String kubeSn) {
        KubeConnection connection = new KubeConnection(kubeSn);
        List<ProtectionJob> protectionJobs = connection.getList(ProtectionJob.class);
        return protectionJobs.stream().map(KubeConvertUtil::tansToBcmProtectionJob).collect(Collectors.toList());
    }

    public List<KubeProtectionJob> getProtectionJobByPlanName(String kubeSn, String planName) {
        KubeConnection connection = new KubeConnection(kubeSn);
        List<ProtectionJob> protectionJobs = connection.getListByLabelAndWithoutLabelKey(ProtectionJob.class, "protectionschedule.xuanwu.huawei.io/" + planName, "bcm-protectionjob");
        return protectionJobs.stream().map(KubeConvertUtil::tansToBcmProtectionJob).collect(Collectors.toList());
    }

    public void editBackupJobWithLabel(String kubeSn, String jobName, Map<String, String> labels) {
        KubeConnection connection = new KubeConnection(kubeSn);
        connection.edit(BackupJob.class, jobName, job -> job.getMetadata().setLabels(labels));
    }

    public void editProtectionJobWithLabel(String kubeSn, String jobName, Map<String, String> labels) {
        KubeConnection connection = new KubeConnection(kubeSn);
        connection.edit(ProtectionJob.class, jobName, job -> job.getMetadata().setLabels(labels));
    }

    public Optional<KubeProtectionJob> getProtectionJobByName(String kubeSn, String jobName) {
        KubeConnection connection = new KubeConnection(kubeSn);
        Optional<ProtectionJob> optional = connection.get(ProtectionJob.class, jobName);
        return optional.map(KubeConvertUtil::tansToBcmProtectionJob);
    }

    public void checkClusterStatus(String kubeSn) {
        KubeConnection connection = new KubeConnection(kubeSn);
        Kubernetes kubernetes = KubeUtil.getKubernetes(kubeSn);
        List<Deployment> deployments = connection.getList(Deployment.class, "xuanwu");
        if (VerifyUtil.isEmpty(deployments)) {
            throw new LegoCheckedException(1073947759L, new String[]{kubernetes.getIpAddress()});
        }
        Optional<Deployment> abnormalDeploymentOptional = deployments.stream().filter(item -> CHECK_XUANWU_DEPLOYMENT.contains(item.getMetadata().getName()) && (item.getStatus() == null || item.getStatus().getReadyReplicas() == null || item.getStatus().getReadyReplicas() == 0)).findAny();
        if (abnormalDeploymentOptional.isPresent()) {
            throw new LegoCheckedException(1073947759L, new String[]{kubernetes.getIpAddress()});
        }
    }

    public List<KubeBackup> getBackupByBackupInstance(String kubeSn, String backupInstanceName) {
        KubeConnection connection = new KubeConnection(kubeSn);
        List<BackupSchedule> schedules = connection.getListByLabelKey(BackupSchedule.class, "backupinstance.xuanwu.huawei.io/" + backupInstanceName);
        if (VerifyUtil.isEmpty(schedules)) {
            return Collections.emptyList();
        }
        ArrayList<Backup> allBackups = new ArrayList<Backup>();
        for (BackupSchedule schedule : schedules) {
            List<Backup> backups = connection.getListByLabelKey(Backup.class, "backupschedule.xuanwu.huawei.io/" + schedule.getMetadata().getName());
            if (VerifyUtil.isEmpty(backups)) continue;
            allBackups.addAll(backups);
        }
        return allBackups.stream().map(KubeConvertUtil::transToBcmBackup).collect(Collectors.toList());
    }

    public List<PodResource> getPods(String devSn, String nameSpace) {
        KubeConnection connection = new KubeConnection(devSn);
        List<Pod> podList = connection.getList(Pod.class, nameSpace);
        return podList.stream().map(KubeConvertUtil::transPodResource).collect(Collectors.toList());
    }

    public Optional<KubeBackupJob> getBackupJobByName(String kubeSn, String jobName) {
        VerifyUtil.checkStrs((String[])new String[]{kubeSn, jobName});
        KubeConnection restConnection = new KubeConnection(kubeSn);
        Optional<BackupJob> optional = restConnection.get(BackupJob.class, jobName);
        return optional.map(KubeConvertUtil::tansToBcmBackupJob);
    }

    public List<KubeBackup> getBackupByBackupLocation(String kubeSn, String backupLocationName) {
        VerifyUtil.checkStrs((String[])new String[]{kubeSn, backupLocationName});
        KubeConnection connection = new KubeConnection(kubeSn);
        List<Backup> backups = connection.getList(Backup.class);
        return backups.stream().map(KubeConvertUtil::transToBcmBackup).filter(backup -> backup.getLocation().contains(backupLocationName)).collect(Collectors.toList());
    }

    public void deleteBackup(String kubeSn, String replicaName) {
        VerifyUtil.checkStrs((String[])new String[]{kubeSn, replicaName});
        this.removeSingleResource(kubeSn, Backup.class, replicaName);
    }

    private <T extends HasMetadata> void removeSingleResource(String kubeSn, Class<T> clazz, String resourceName) {
        this.removeSingleResource(kubeSn, clazz, resourceName, null);
    }

    private <T extends HasMetadata> void removeSingleResource(String kubeSn, Class<T> clazz, String resourceName, String namespace) {
        LOGGER.info((Object)"Start delete %s ( name: %s, namespace: %s )", new Object[]{clazz.getSimpleName(), resourceName, namespace});
        try {
            KubeConnection connection = new KubeConnection(kubeSn);
            Optional<T> opt = VerifyUtil.isEmpty((String)namespace) ? connection.get(clazz, resourceName) : connection.get(clazz, namespace, resourceName);
            if (!opt.isPresent()) {
                LOGGER.warn((Object)"Delete resource ( name: %s, kind: %s, namespace: %s ) canceled, cause it is not present", new Object[]{resourceName, clazz.getSimpleName(), namespace});
                return;
            }
            LOGGER.info((Object)"Start delete %s ( %s ) in namespace %s", new Object[]{clazz.getSimpleName(), resourceName, namespace});
            connection.delete(clazz, (HasMetadata)opt.get());
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Throwable)e, (Object)"Delete resource ( name: %s, kind: %s, namespace: %s ) failed", new Object[]{resourceName, clazz.getSimpleName(), namespace});
            throw new LegoCheckedException(1073947757L, new String[]{clazz.getSimpleName(), resourceName});
        }
    }

    public List<Domain> getHyperMetroDomain(String devSN) {
        VerifyUtil.checkStrs((String[])new String[]{devSN});
        KubeConnection connection = new KubeConnection(devSN);
        List<HyperMetroDomain> domains = connection.getList(HyperMetroDomain.class);
        ArrayList<Domain> result = new ArrayList<Domain>();
        for (HyperMetroDomain hyperMetroDomain : domains) {
            if (VerifyUtil.isEmpty((Object)hyperMetroDomain.getStatus()) || VerifyUtil.isEmpty((Object)hyperMetroDomain.getMetadata()) || VerifyUtil.isEmpty((String)hyperMetroDomain.getMetadata().getName())) continue;
            Domain domain = KubeConvertUtil.tansToKubeDomain(hyperMetroDomain);
            this.buildHyperMetroDomainIpAddress(devSN, domain);
            result.add(domain);
            domain.setKubeId(devSN);
        }
        return result;
    }

    private void buildHyperMetroDomainIpAddress(String devSn, Domain domain) {
        List backends = domain.getBackends();
        if (VerifyUtil.isEmpty((Collection)backends)) {
            LOGGER.warn((Object)"Backends of the HyperMetroDomain (%s) is empty, could not query ip address of this domain.", new Object[]{domain.getHyperMetroDomainName()});
            return;
        }
        KubeHyperMetroDomainBackend backend = (KubeHyperMetroDomainBackend)CommonUtil.getFirstElement((Collection)backends);
        KubeStorage storageByConfigMap = this.getStorageByConfigMap(devSn, backend.getNamespace(), backend.getName());
        domain.setIpAddress(storageByConfigMap.getIpAddress());
    }

    private boolean isMasterNode(Node node) {
        Map labels = node.getMetadata().getLabels();
        Iterator iterator = labels.entrySet().iterator();
        boolean isMasterNode = false;
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (!((String)entry.getKey()).contains(KubeRole.MASTER.getValue())) continue;
            isMasterNode = true;
            break;
        }
        return isMasterNode;
    }
}

