/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.kube.handler;

import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import io.fabric8.kubernetes.api.model.HasMetadata;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.TypeFilter;

public class MetaClassScanner
extends ClassPathScanningCandidateComponentProvider {
    private static final Log LOGGER = LogFactory.getInstance(MetaClassScanner.class);

    public MetaClassScanner() {
        super(false);
        this.addIncludeFilter((TypeFilter)new AssignableTypeFilter(HasMetadata.class));
    }

    public Set<Class<? extends HasMetadata>> scan(String[] packages) {
        HashSet<Class<? extends HasMetadata>> classes = new HashSet<Class<? extends HasMetadata>>();
        for (String pkg : packages) {
            this.scanKubeMetaClass(pkg, classes::add);
        }
        return classes;
    }

    private void scanKubeMetaClass(String pkg, Consumer<Class<? extends HasMetadata>> callback) {
        Set definitions = this.findCandidateComponents(pkg);
        for (BeanDefinition definition : definitions) {
            Class<?> clazz;
            String className = definition.getBeanClassName();
            try {
                clazz = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                LOGGER.error((Object)"fail to load clazz %s", new Object[]{className, e});
                continue;
            }
            if (!HasMetadata.class.isAssignableFrom(clazz)) continue;
            Class<?> metaClass = clazz;
            callback.accept(metaClass);
        }
    }
}

