/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.kube.protection.replica.builder;

import com.huawei.ism.drm.kube.protection.replica.builder.IReplicationBuilder;
import com.huawei.ism.drm.kube.sdk.IKubeHandler;
import com.huawei.ism.drm.kube.sdk.model.KubePersistentVolume;
import com.huawei.ism.drm.kube.sdk.model.KubeStorage;
import com.huawei.ism.drm.kube.sdk.model.PersistentVolumeClaimInfo;
import com.huawei.ism.drm.kube.sdk.model.constants.KubeEnumDefine;
import com.huawei.ism.drm.kube.sdk.utils.KubeCommonUtils;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class PersistentVolumeBuilder
implements IReplicationBuilder {
    @Override
    public Set<String> getNamespace(ProtectGroup protectGroup) {
        return null;
    }

    @Override
    public Set<String> getStorageClass(ProtectGroup protectGroup) {
        IKubeHandler iKubeHandler = (IKubeHandler)ServiceLocator.getInstance().getService(IKubeHandler.class);
        HashSet<String> storageClass = new HashSet<String>();
        for (ProtectObject po : protectGroup.getPolist()) {
            Optional opt = iKubeHandler.getKubePersistentVolume(protectGroup.getPoProviderSN(), (String)po.getProps().get("kube_persistent_volume"));
            opt.ifPresent(kubePersistentVolume -> storageClass.add(kubePersistentVolume.getStorageClass()));
        }
        return storageClass;
    }

    @Override
    public List<PersistentVolumeClaimInfo> getPVC(ProtectGroup protectGroup) {
        IKubeHandler iKubeHandler = (IKubeHandler)ServiceLocator.getInstance().getService(IKubeHandler.class);
        ArrayList<PersistentVolumeClaimInfo> pvcList = new ArrayList<PersistentVolumeClaimInfo>();
        for (ProtectObject po : protectGroup.getPolist()) {
            Optional opt = iKubeHandler.getKubePersistentVolume(protectGroup.getPoProviderSN(), (String)po.getProps().get("kube_persistent_volume"));
            opt.ifPresent(item -> {
                String[] array = item.getClaim().split("/");
                String namespace = array[0];
                String name = array[1];
                PersistentVolumeClaimInfo pvcInfo = new PersistentVolumeClaimInfo();
                pvcInfo.setName(name);
                pvcInfo.setNameSpace(namespace);
                pvcInfo.setStorageClassName(item.getStorageClass());
                pvcList.add(pvcInfo);
            });
        }
        return pvcList;
    }

    @Override
    public KubeStorage getSBC(ProtectGroup protectGroup, ProtectObject protectObject) {
        IKubeHandler iKubeHandler = (IKubeHandler)ServiceLocator.getInstance().getService(IKubeHandler.class);
        String domainType = protectObject.getProperty("domainType");
        if (KubeEnumDefine.DomainType.AA_TYPE.getValue().equals(domainType)) {
            return KubeCommonUtils.getHyperMetroSystemVStoreBackend((ProtectGroup)protectGroup);
        }
        Optional opt = iKubeHandler.getKubePersistentVolume(protectObject.getProviderSN(), (String)protectObject.getProps().get("kube_persistent_volume"));
        if (!opt.isPresent()) {
            throw new LegoCheckedException(1073947393L);
        }
        List kubeStorages = iKubeHandler.getStorageBackendClaims(protectObject.getProviderSN());
        return kubeStorages.stream().filter(kubeStorage -> Objects.equals(((KubePersistentVolume)opt.get()).getBackend(), kubeStorage.getName())).findAny().orElseThrow(() -> new LegoCheckedException(1073947393L));
    }
}

