/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.kube.protection.replica.builder;

import com.huawei.ism.drm.kube.protection.replica.builder.BaseDisasterProtectionHandler;
import com.huawei.ism.drm.kube.protection.replica.builder.IReplicationBuilder;
import com.huawei.ism.drm.kube.protection.replica.builder.PersistentVolumeBuilder;
import com.huawei.ism.drm.kube.protection.replica.builder.task.ResourceRollBackTask;
import com.huawei.ism.drm.kube.sdk.IKubeHandler;
import com.huawei.ism.drm.kube.sdk.model.KubeProtectionPlan;
import com.huawei.ism.drm.kube.sdk.model.KubeStorage;
import com.huawei.ism.drm.kube.sdk.model.MetadataPairInfo;
import com.huawei.ism.drm.kube.sdk.model.PersistentVolumeClaimInfo;
import com.huawei.ism.drm.kube.sdk.model.StorageClassInfo;
import com.huawei.ism.drm.kube.sdk.model.constants.KubeEnumDefine;
import com.huawei.ism.drm.kube.sdk.model.enums.KubeBackTaskProcessDefine;
import com.huawei.ism.drm.kube.sdk.utils.KubeCommonUtils;
import com.huawei.ism.drm.kube.sdk.utils.RetryableTask;
import com.huawei.ism.drm.kube.util.KubeUtil;
import com.huawei.ism.drm.protection.framework.service.group.context.CreateProtectGroupContext;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.lego.cbb.resource.rollback.IRollbackItem;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;

public class PersistentVolumeHyperMetroHandler
extends BaseDisasterProtectionHandler {
    private static final Log LOGGER = LogFactory.getInstance(BaseDisasterProtectionHandler.class);
    private static final int QUERY_FILE_SYSTEM_RETRY_TIMES = 60;
    private static final long QUERY_FILE_SYSTEM_DURATION = 5L;
    private static final int QUERY_STORAGE_CLASS_RETRY_TIMES = 5;
    private static final long QUERY_STORAGE_CLASS_DURATION = 1L;

    @Override
    public void createKubeProtectPlan(ProtectGroup protectGroup) {
        KubeUtil.checkParam(protectGroup);
        Schedule schedule = (Schedule)protectGroup.getTemplate().getSchedules().iterator().next();
        try {
            this.createCluster(protectGroup, schedule.getSourceSn(), schedule.getTargetSn());
            CreateProtectGroupContext.updateProgress((int)KubeBackTaskProcessDefine.CreateHyperMetroVolumeProtectGroup.CREATE_CLUSTER.getProgress());
            this.createPVC(protectGroup, schedule);
            CreateProtectGroupContext.updateProgress((int)KubeBackTaskProcessDefine.CreateHyperMetroVolumeProtectGroup.CREATE_TARGET_PVC.getProgress());
            this.createVolumeSet(protectGroup, schedule.getTargetSn());
            CreateProtectGroupContext.updateProgress((int)KubeBackTaskProcessDefine.CreateHyperMetroVolumeProtectGroup.CREATE_VOLUME_SET.getProgress());
            this.createProtectPlan(protectGroup, schedule);
            CreateProtectGroupContext.updateProgress((int)KubeBackTaskProcessDefine.CreateHyperMetroVolumeProtectGroup.CREATE_PROTECT_PLAN.getProgress());
        }
        catch (LegoCheckedException exception) {
            LOGGER.error((Object)"Create protect plan failed. error:%s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)exception)});
            this.rollbackTask.execute();
            throw exception;
        }
    }

    @Override
    protected void postCreateProtectPlan(ProtectGroup protectGroup, KubeProtectionPlan protectionPlan) {
        ProtectObject protectObject = (ProtectObject)protectGroup.getPolist().iterator().next();
        protectionPlan.setHyperMetroDomain(protectObject.getProperty("domainName"));
    }

    @Override
    protected void postCreateTargetPVC(String devSn, PersistentVolumeClaimInfo pvc, ProtectGroup protectGroup) {
        String domainType = protectGroup.getProperty("domainType");
        if (KubeEnumDefine.DomainType.AA_TYPE.getValue().equals(domainType)) {
            Optional<ProtectObject> protectObjectOpt = protectGroup.getPolist().stream().filter(po -> StringUtils.equals((CharSequence)pvc.getName(), (CharSequence)po.getName()) && StringUtils.equals((CharSequence)pvc.getNameSpace(), (CharSequence)po.getProperty("namespace"))).findAny();
            if (!protectObjectOpt.isPresent()) {
                LOGGER.error((Object)"Could not find matched protect object from pvc %s in namespace %s", new Object[]{pvc.getName(), pvc.getNameSpace()});
                throw new LegoCheckedException(1073947394L);
            }
            IKubeHandler kubeHandler = (IKubeHandler)ServiceLocator.getInstance().getService(IKubeHandler.class);
            Schedule schedule = (Schedule)protectGroup.getTemplate().getSchedules().iterator().next();
            RetryableTask task = new RetryableTask();
            task.run(5, 1L, TimeUnit.SECONDS, true, () -> {
                Optional targetStorageClassOpt = kubeHandler.getStorageClassByName(schedule.getTargetSn(), pvc.getStorageClassName());
                if (!targetStorageClassOpt.isPresent()) {
                    return false;
                }
                ProtectObject protectObject = (ProtectObject)protectObjectOpt.get();
                StorageClassInfo targetStorageClass = (StorageClassInfo)targetStorageClassOpt.get();
                Map targetStorageClassParameters = targetStorageClass.getParameters();
                String targetBackend = (String)targetStorageClassParameters.get("backend");
                protectObject.setProperty("TargetStorageName", (Object)targetBackend);
                return true;
            });
        }
        KubeUtil.buildHyperMetroPvcFileSystem(devSn, pvc);
    }

    @Override
    protected void postCreateTargetMetaPVC(String sourceSn, PersistentVolumeClaimInfo pvc) {
        Optional<String> volumeNameOpt = KubeUtil.queryVolumeName(sourceSn, pvc.getName(), pvc.getNameSpace());
        if (!volumeNameOpt.isPresent()) {
            LOGGER.error((Object)"Could not find volume name of PVC ( %s ) in namespace ( %s) from cluster ( %s )", new Object[]{pvc.getName(), pvc.getNameSpace(), sourceSn});
            throw new LegoCheckedException(1073947394L);
        }
        HashMap<String, String> annotations = new HashMap<String, String>();
        annotations.put("csi.huawei.com/fileSystemMode", "HyperMetro");
        annotations.put("csi.huawei.com/volumeName", volumeNameOpt.get());
        pvc.setAnnotations(annotations);
        HashMap<String, String> labelMap = new HashMap<String, String>();
        labelMap.put("provisioner", "csi.huawei.com");
        pvc.setLabelMap(labelMap);
    }

    @Override
    protected void checkTargetSCBackend(ProtectGroup protectGroup, Schedule schedule, StorageClassInfo productionStorageClass) {
        Optional disasterStorageClassOptional = this.iKubeHandler.getStorageClassByName(schedule.getTargetSn(), productionStorageClass.getName());
        if (!disasterStorageClassOptional.isPresent()) {
            return;
        }
        KubeUtil.checkHyperMetroStorageClass(protectGroup, productionStorageClass, (StorageClassInfo)disasterStorageClassOptional.get());
    }

    @Override
    protected void doCreateTargetSC(ProtectGroup protectGroup, String targetSn, StorageClassInfo sc) {
        Map parameters = sc.getParameters();
        String sourceBackend = (String)parameters.get("backend");
        Optional<KubeStorage> targetSbcOptional = KubeUtil.matchHyperMetroBackend(protectGroup.getPoProviderSN(), targetSn, sourceBackend);
        if (!targetSbcOptional.isPresent()) {
            LOGGER.error((Object)"Could not find remote backend by source backend %s", new Object[]{sourceBackend});
            throw new LegoCheckedException(1073947771L, new String[]{sourceBackend});
        }
        KubeStorage targetStorage = targetSbcOptional.get();
        sc.getParameters().put("backend", targetStorage.getName());
        this.iKubeHandler.createStorageClass(targetSn, sc);
        this.rollbackTask.addItem((IRollbackItem)new ResourceRollBackTask(targetSn, sc.getName(), KubeEnumDefine.RollBackType.SC));
    }

    @Override
    protected IReplicationBuilder getBuilder() {
        return new PersistentVolumeBuilder();
    }

    @Override
    protected Optional<KubeStorage> getTargetKubeStorage(ProtectGroup protectGroup, Schedule schedule) {
        String domainType = protectGroup.getProperty("domainType");
        if (KubeEnumDefine.DomainType.AA_TYPE.getValue().equals(domainType)) {
            Optional<KubeStorage> systemVStoreStorageOpt = super.getTargetKubeStorage(protectGroup, schedule);
            String systemVStoreBackendName = this.getTargetBackendName(schedule);
            if (!systemVStoreStorageOpt.isPresent()) {
                LOGGER.error((Object)"Could not find target backend of system vStore at cluster side, backend %s", new Object[]{systemVStoreBackendName});
                throw new LegoCheckedException(1073947394L);
            }
            ProtectObject protectObject = (ProtectObject)CommonUtil.getFirstElement((Collection)protectGroup.getPolist());
            String pvcBackendName = protectObject.getProperty("TargetStorageName");
            Optional pvcStorageOpt = this.iKubeHandler.getStorageBackendClaims(schedule.getTargetSn(), pvcBackendName);
            if (!pvcStorageOpt.isPresent()) {
                LOGGER.error((Object)"Could not find target backend of PVC at cluster side, backend %s", new Object[]{pvcBackendName});
                throw new LegoCheckedException(1073947394L);
            }
            if (!StringUtils.equals((CharSequence)systemVStoreStorageOpt.get().getDeviceSn(), (CharSequence)((KubeStorage)pvcStorageOpt.get()).getDeviceSn())) {
                LOGGER.error((Object)"The system vStore backend( %s ) and the backend for provisioning the PV( %s ) do not belong to the same storage.", new Object[]{systemVStoreBackendName, pvcBackendName});
                throw new LegoCheckedException(1073947770L, new String[]{systemVStoreBackendName, pvcBackendName});
            }
            return systemVStoreStorageOpt;
        }
        String sourceBackend = this.getSourceBackend(protectGroup);
        Optional<KubeStorage> targetSbcOptional = KubeUtil.matchHyperMetroBackend(protectGroup.getPoProviderSN(), schedule.getTargetSn(), sourceBackend);
        if (!targetSbcOptional.isPresent()) {
            LOGGER.error((Object)"Could not find remote backend by source backend %s", new Object[]{sourceBackend});
            throw new LegoCheckedException(1073947771L, new String[]{sourceBackend});
        }
        return targetSbcOptional;
    }

    private String getSourceBackend(ProtectGroup protectGroup) {
        String domainType = protectGroup.getProperty("domainType");
        if (KubeEnumDefine.DomainType.AA_TYPE.getValue().equals(domainType)) {
            return KubeCommonUtils.getHyperMetroSystemVStoreBackend((ProtectGroup)protectGroup).getName();
        }
        ProtectObject protectObject = (ProtectObject)protectGroup.getPolist().iterator().next();
        return protectObject.getProperty("storageBackend");
    }

    @Override
    protected MetadataPairInfo getMetadataPairInfo(ProtectGroup protectGroup, String targetSn) {
        Map props = protectGroup.getProps();
        String pvcMeta = (String)props.get("kube_metadata_pvc_name");
        String[] array = pvcMeta.split("/");
        MetadataPairInfo pairInfo = new MetadataPairInfo();
        boolean hasFindFileSystemName = false;
        for (int retryTime = 0; retryTime < 60; ++retryTime) {
            CommonUtil.sleep((long)5L, (TimeUnit)TimeUnit.SECONDS);
            Optional srcOpt = this.iKubeHandler.getPersistentVolumeClaimInfo(protectGroup.getPoProviderSN(), array[1], array[0]);
            Optional targetOpt = this.iKubeHandler.getPersistentVolumeClaimInfo(targetSn, array[1], array[0]);
            if (!srcOpt.isPresent() || !targetOpt.isPresent()) {
                LOGGER.warn((Object)"No FileSystemName in pvc:%s at retryTime:%s.", new Object[]{array[1], retryTime});
                continue;
            }
            String srcFileSystemName = ((PersistentVolumeClaimInfo)srcOpt.get()).getFileSystemName();
            String targetFileSystemName = ((PersistentVolumeClaimInfo)targetOpt.get()).getFileSystemName();
            if (VerifyUtil.isEmpty((String)srcFileSystemName) || VerifyUtil.isEmpty((String)targetFileSystemName)) {
                LOGGER.warn((Object)"No FileSystemName in pvc:%s at retryTime:%s.", new Object[]{array[1], retryTime});
                continue;
            }
            hasFindFileSystemName = true;
            pairInfo.setPrimaryPVName(srcFileSystemName);
            pairInfo.setSecondaryPVName(targetFileSystemName);
            break;
        }
        if (!hasFindFileSystemName) {
            LOGGER.error((Object)"Could not find FileSystemName in pvc: %s.", new Object[]{array[1]});
            throw new LegoCheckedException(1073937958L);
        }
        pairInfo.setPvcMeta(pvcMeta);
        return pairInfo;
    }

    @Override
    protected MetadataPairInfo transToVolumePair(PersistentVolumeClaimInfo claimInfo, String providerSn, String targetSn) {
        MetadataPairInfo pairInfo = new MetadataPairInfo();
        pairInfo.setPvcMeta(claimInfo.getNameSpace() + "/" + claimInfo.getName());
        Optional priOpt = this.iKubeHandler.getPersistentVolumeClaimInfo(providerSn, claimInfo.getName(), claimInfo.getNameSpace());
        Optional targetOpt = this.iKubeHandler.getPersistentVolumeClaimInfo(targetSn, claimInfo.getName(), claimInfo.getNameSpace());
        priOpt.ifPresent(item -> pairInfo.setPrimaryPVName(item.getFileSystemName()));
        targetOpt.ifPresent(item -> pairInfo.setSecondaryPVName(item.getFileSystemName()));
        return pairInfo;
    }
}

