/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.kube.protection.replica.builder;

import com.huawei.ism.drm.kube.protection.replica.builder.IReplicationBuilder;
import com.huawei.ism.drm.kube.sdk.IKubeHandler;
import com.huawei.ism.drm.kube.sdk.model.KubePersistentVolume;
import com.huawei.ism.drm.kube.sdk.model.KubeResourceSetPVC;
import com.huawei.ism.drm.kube.sdk.model.KubeStorage;
import com.huawei.ism.drm.kube.sdk.model.PersistentVolumeClaimInfo;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class ResourceSetBuilder
implements IReplicationBuilder {
    @Override
    public Set<String> getNamespace(ProtectGroup protectGroup) {
        IKubeHandler iKubeHandler = (IKubeHandler)ServiceLocator.getInstance().getService(IKubeHandler.class);
        HashSet<String> namespace = new HashSet<String>();
        for (ProtectObject po : protectGroup.getPolist()) {
            List pvc = iKubeHandler.getResourceSetPVCs(protectGroup.getPoProviderSN(), (String)po.getProps().get("resourceDetailName"));
            namespace.addAll(pvc.stream().map(KubeResourceSetPVC::getNamespace).collect(Collectors.toSet()));
        }
        return namespace;
    }

    @Override
    public Set<String> getStorageClass(ProtectGroup protectGroup) {
        IKubeHandler iKubeHandler = (IKubeHandler)ServiceLocator.getInstance().getService(IKubeHandler.class);
        HashSet<String> storageClass = new HashSet<String>();
        for (ProtectObject po : protectGroup.getPolist()) {
            List pvc = iKubeHandler.getResourceSetPVCs(protectGroup.getPoProviderSN(), (String)po.getProps().get("resourceDetailName"));
            storageClass.addAll(pvc.stream().map(KubeResourceSetPVC::getKubePV).filter(Objects::nonNull).map(KubePersistentVolume::getStorageClass).filter(Objects::nonNull).collect(Collectors.toSet()));
        }
        return storageClass;
    }

    @Override
    public List<PersistentVolumeClaimInfo> getPVC(ProtectGroup protectGroup) {
        IKubeHandler iKubeHandler = (IKubeHandler)ServiceLocator.getInstance().getService(IKubeHandler.class);
        ArrayList<PersistentVolumeClaimInfo> pvcList = new ArrayList<PersistentVolumeClaimInfo>();
        for (ProtectObject po : protectGroup.getPolist()) {
            List pvc = iKubeHandler.getResourceSetPVCs(protectGroup.getPoProviderSN(), (String)po.getProps().get("resourceDetailName"));
            pvcList.addAll(pvc.stream().map(item -> {
                PersistentVolumeClaimInfo pvcInfo = new PersistentVolumeClaimInfo();
                pvcInfo.setName(item.getName());
                pvcInfo.setNameSpace(item.getNamespace());
                return pvcInfo;
            }).collect(Collectors.toList()));
        }
        return pvcList;
    }

    @Override
    public KubeStorage getSBC(ProtectGroup protectGroup, ProtectObject protectObject) {
        IKubeHandler iKubeHandler = (IKubeHandler)ServiceLocator.getInstance().getService(IKubeHandler.class);
        List kubeStorages = iKubeHandler.getStorageBackendClaims(protectObject.getProviderSN());
        List pvc = iKubeHandler.getResourceSetPVCs(protectObject.getProviderSN(), (String)protectObject.getProps().get("resourceDetailName"));
        String backendName = pvc.stream().map(KubeResourceSetPVC::getKubePV).filter(Objects::nonNull).map(KubePersistentVolume::getBackend).filter(Objects::nonNull).findAny().orElseThrow(() -> new LegoCheckedException(1073947393L));
        return kubeStorages.stream().filter(kubeStorage -> backendName.equals(kubeStorage.getName())).findAny().orElseThrow(() -> new LegoCheckedException(1073947393L));
    }
}

