/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.kube.protection.task;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.kube.sdk.IKubeHandler;
import com.huawei.ism.drm.kube.util.KubeUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;

public class RebuildHyperMetroProtectionPlanTask
implements Runnable {
    private static final Log LOGGER = LogFactory.getInstance(RebuildHyperMetroProtectionPlanTask.class);
    private final IKubeHandler kubeHandler = (IKubeHandler)ServiceLocator.getInstance().getService(IKubeHandler.class);
    private ProtectGroup protectGroup;

    public RebuildHyperMetroProtectionPlanTask(ProtectGroup protectGroup) {
        this.protectGroup = protectGroup;
    }

    @Override
    public void run() {
        try {
            String srcSn = this.protectGroup.getPoProviderSN();
            String targetSn = ((Schedule)this.protectGroup.getTemplate().getSchedules().iterator().next()).getTargetSn();
            String planName = this.protectGroup.getProperty("kube_protection_plan");
            LOGGER.info((Object)"Start rebuilding protection plan %s", new Object[]{planName});
            this.kubeHandler.rebuildProtectionPlan(srcSn, planName);
            KubeUtil.checkProtectPlanStatusNormalOrError(this.protectGroup, srcSn, planName);
            this.kubeHandler.rebuildProtectionPlan(targetSn, planName);
            KubeUtil.checkProtectPlanStatusNormalOrError(this.protectGroup, targetSn, planName);
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"Monitor protection plan status failed. ProtectGroup name:%s.", new Object[]{this.protectGroup.getName()});
            ProtectGroup curProtectGroup = ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).getProtectGroupByID(this.protectGroup.getUuid());
            curProtectGroup.setStatus(DrmEnumDefine.ProtectGroupStatus.INVALID.getStatus());
            CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)curProtectGroup);
            KubeUtil.sendAlarm(this.protectGroup);
            throw e;
        }
    }
}

