/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.kube.protection.template.filter;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.kube.sdk.IKubeHandler;
import com.huawei.ism.drm.kube.sdk.model.Domain;
import com.huawei.ism.drm.kube.sdk.model.constants.KubeEnumDefine;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.protection.template.sdk.service.AbstractPolicyTemplateFilter;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class KubeHyperMetroDomainAaFilter
extends AbstractPolicyTemplateFilter {
    private static final Log LOGGER = LogFactory.getInstance(KubeHyperMetroDomainAaFilter.class);

    public int getType() {
        return 60;
    }

    public boolean isMatch(List<ProtectObject> protectObjects, PolicyTemplate policyTemplate) {
        if (VerifyUtil.isEmpty(protectObjects)) {
            LOGGER.error((Object)"The parameter protectObjects is empty!");
            throw new LegoCheckedException(1073948191L);
        }
        this.checkProtectObjectType(protectObjects);
        String domainName = this.checkAndGetDomainName(protectObjects);
        this.checkHyperMetroDomain(protectObjects, domainName, policyTemplate);
        return true;
    }

    public boolean isMatch(List<ProtectObject> protectObjects) {
        return true;
    }

    private void checkProtectObjectType(List<ProtectObject> protectObjects) {
        Optional<ProtectObject> invalidProtectObjectOpt = protectObjects.stream().filter(e -> e.getPoType() != 21).findAny();
        if (invalidProtectObjectOpt.isPresent()) {
            LOGGER.error((Object)"Match HyperMetroDomain template failed, the type of protect object is invalid for kubernetes HyperMetro scene");
            throw new LegoCheckedException(1073948191L);
        }
    }

    private String checkAndGetDomainName(List<ProtectObject> protectObjects) {
        List domainNames = protectObjects.stream().map(e -> (String)e.getProperty("domainName", String.class)).distinct().collect(Collectors.toList());
        if (VerifyUtil.isEmpty(domainNames)) {
            LOGGER.error((Object)"Match HyperMetroDomain template failed, can not find HyperMetro domain protect object");
            throw new LegoCheckedException(1073948191L);
        }
        if (domainNames.size() > 1) {
            LOGGER.error((Object)"Match HyperMetroDomain template failed, the protected objects belong to different HyperMetro domains (%s)", new Object[]{StringUtils.join(domainNames, (String)",")});
            throw new LegoCheckedException(1073948191L);
        }
        return (String)CommonUtil.getFirstElement(domainNames);
    }

    private void checkHyperMetroDomain(List<ProtectObject> protectObjects, String domainName, PolicyTemplate policyTemplate) {
        ProtectObject protectObject;
        IKubeHandler kubeHandler = (IKubeHandler)ServiceLocator.getInstance().getService(IKubeHandler.class);
        Optional domainOptional = kubeHandler.getHyperMetroDomain((protectObject = (ProtectObject)CommonUtil.getFirstElement(protectObjects)).getProviderSN(), domainName);
        if (!domainOptional.isPresent()) {
            LOGGER.error((Object)"Target HyperMetroDomain (%s) is not present", new Object[]{domainName});
            throw new LegoCheckedException(1073948191L);
        }
        String domainType = (String)protectObject.getProperty("domainType", String.class);
        if (KubeEnumDefine.DomainType.AA_TYPE.getValue().equals(domainType) && policyTemplate.getType() != 60) {
            LOGGER.error((Object)"Could not show policy template (%s) with hyper metro domain type (%s)", new Object[]{policyTemplate.getType(), domainType});
            throw new LegoCheckedException(1073948191L);
        }
        if (KubeEnumDefine.DomainType.AP_TYPE.getValue().equals(domainType) && policyTemplate.getType() != 61) {
            LOGGER.error((Object)"Could not show policy template (%s) with hyper metro domain type (%s)", new Object[]{policyTemplate.getType(), domainType});
            throw new LegoCheckedException(1073948191L);
        }
        this.checkHyperMetroDomainAvailable(protectObjects.get(0).getProviderSN(), domainName);
    }

    private void checkHyperMetroDomainAvailable(String kubeSn, String domainName) {
        IKubeHandler kubeHandler = (IKubeHandler)ServiceLocator.getInstance().getService(IKubeHandler.class);
        kubeHandler.refreshHyperMetroDomain(kubeSn, domainName);
        CommonUtil.sleep((long)2L, (TimeUnit)TimeUnit.SECONDS);
        Optional opt = kubeHandler.getHyperMetroDomain(kubeSn, domainName);
        if (!opt.isPresent()) {
            LOGGER.error((Object)"The HyperMetroDomain ( %s ) is not present.", new Object[]{domainName});
            throw new LegoCheckedException(2117645L);
        }
        Domain domain = (Domain)opt.get();
        if (!StringUtils.equals((CharSequence)domain.getStatus(), (CharSequence)KubeEnumDefine.DomainStatus.NORMAL.getValue())) {
            LOGGER.error((Object)"Status of the HyperMetroDomain ( %s ) is %s, but not normal.", new Object[]{domainName, domain.getStatus()});
            throw new LegoCheckedException(1073947765L, new String[]{domainName});
        }
    }
}

