/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.kube.protection.template.filter;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.kube.connection.KubeConnection;
import com.huawei.ism.drm.kube.sdk.IKubeHandler;
import com.huawei.ism.drm.kube.sdk.model.KubeResourceSetPVC;
import com.huawei.ism.drm.kube.sdk.model.KubeStorage;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.protection.template.sdk.service.AbstractPolicyTemplateFilter;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import io.huawei.xuanwu.v1.ResourceDetail;
import io.huawei.xuanwu.v1.ResourceDetailStatus;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class ResourceSetLocalBackupFilter
extends AbstractPolicyTemplateFilter {
    private static final Log LOG = LogFactory.getInstance(ResourceSetLocalBackupFilter.class);
    private static final int MAX_BACKUP_SCHEDULE_SIZE = 4;

    public boolean isMatch(List<ProtectObject> protectObjects) {
        if (VerifyUtil.isEmpty(protectObjects)) {
            LOG.warn((Object)"The parameter protectObjects is empty!");
            throw new LegoCheckedException(1073948191L);
        }
        ResourceSetLocalBackupFilter.checkResourcesExist(protectObjects);
        this.checkAndGetLocalBackendStorage(protectObjects);
        return true;
    }

    protected static void checkResourcesExist(List<ProtectObject> protectObjects) {
        for (ProtectObject protectObject : protectObjects) {
            String detailName;
            String kubeSn = protectObject.getProviderSN();
            KubeConnection connection = new KubeConnection(kubeSn);
            Optional<ResourceDetail> opt = connection.get(ResourceDetail.class, detailName = (String)protectObject.getProps().get("resourceDetailName"));
            List resources = Optional.ofNullable(opt.get().getStatus()).map(ResourceDetailStatus::getResources).orElse(Collections.emptyList());
            if (!resources.isEmpty()) continue;
            LOG.error((Object)"Resources is empty. kubeSn:%s,detailName:%s", new Object[]{kubeSn, detailName});
            throw new LegoCheckedException(1073947394L);
        }
    }

    protected Optional<String> checkAndGetLocalBackendStorage(List<ProtectObject> protectObjects) {
        String kubeSn = protectObjects.iterator().next().getProviderSN();
        IKubeHandler kubeHandler = (IKubeHandler)ServiceLocator.getInstance().getService(IKubeHandler.class);
        List kubeStorages = kubeHandler.getStorageBackendClaims(kubeSn);
        HashSet<String> storageBackendName = new HashSet<String>();
        for (ProtectObject protectObject : protectObjects) {
            Set<String> backends = this.getProtectObjectStorageBackends(protectObject, kubeStorages);
            storageBackendName.addAll(backends);
        }
        if (storageBackendName.size() > 1) {
            LOG.error((Object)"Resource set must in same storage device. Current backend:%s", new Object[]{storageBackendName});
            throw new LegoCheckedException(1073948191L);
        }
        if (storageBackendName.size() == 0 || VerifyUtil.isEmpty((String)((String)storageBackendName.iterator().next()))) {
            return Optional.empty();
        }
        return Optional.of(storageBackendName.iterator().next());
    }

    protected Set<String> getProtectObjectStorageBackends(ProtectObject protectObject, List<KubeStorage> kubeStorageList) {
        String kubeSn = protectObject.getProviderSN();
        String detailName = (String)protectObject.getProps().get("resourceDetailName");
        IKubeHandler kubeHandler = (IKubeHandler)ServiceLocator.getInstance().getService(IKubeHandler.class);
        List pvcList = kubeHandler.getResourceSetPVCs(kubeSn, detailName);
        return this.getPVStorage(pvcList, kubeStorageList);
    }

    private Set<String> getPVStorage(List<KubeResourceSetPVC> pvcList, List<KubeStorage> kubeStorages) {
        Set storageBackendNameSet = kubeStorages.stream().filter(item -> "huawei-csi".equals(item.getNamespace())).map(KubeStorage::getName).collect(Collectors.toSet());
        HashSet<String> storageBackendName = new HashSet<String>();
        for (KubeResourceSetPVC kubeResourceSetPVC : pvcList) {
            String backend = kubeResourceSetPVC.getKubePV().getBackend();
            if (VerifyUtil.isEmpty((String)backend) || !storageBackendNameSet.contains(backend)) continue;
            storageBackendName.add(backend);
        }
        return storageBackendName;
    }

    public int getType() {
        return 49;
    }

    protected int getScheduleLimit() {
        return 4;
    }

    public boolean checkPolicyTemplate(PolicyTemplate policyTemplate) {
        Set scheduleSet = policyTemplate.getSchedules();
        if (VerifyUtil.isEmpty((Collection)scheduleSet)) {
            LOG.error((Object)"Schedule is null.");
            throw new LegoCheckedException(1073947393L);
        }
        if (scheduleSet.size() > this.getScheduleLimit()) {
            LOG.error((Object)"Exceed schedule limit. Policy type:%d, Count:%d", new Object[]{policyTemplate.getType(), scheduleSet.size()});
            throw new LegoCheckedException(1073947393L);
        }
        HashSet<Integer> scheduleTypeSet = new HashSet<Integer>();
        for (Schedule schedule : scheduleSet) {
            if (schedule.getScheduleMode() == 1) continue;
            if (scheduleTypeSet.contains(schedule.getPeriodType())) {
                LOG.error((Object)"Duplicate schedule type. Schedule type:%s.", new Object[]{String.valueOf(schedule.getPeriodType())});
                throw new LegoCheckedException(1073947393L);
            }
            scheduleTypeSet.add(schedule.getPeriodType());
        }
        return true;
    }
}

