/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.kube.protection.template.filter;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.kube.protection.template.filter.AbstractReplicationFilter;
import com.huawei.ism.drm.kube.sdk.IKubeHandler;
import com.huawei.ism.drm.kube.sdk.model.ResourceSetInfo;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class ResourceSetReplicationFilter
extends AbstractReplicationFilter {
    private static final Log LOGGER = LogFactory.getInstance(ResourceSetReplicationFilter.class);

    @Override
    protected int getProtectObjectType() {
        return 20;
    }

    @Override
    public boolean isMatch(List<ProtectObject> protectObjects) {
        if (!super.isMatch(protectObjects)) {
            return false;
        }
        this.checkResourceSet(protectObjects);
        return true;
    }

    protected final void checkResourceSet(List<ProtectObject> protectObjects) {
        String providerSN = protectObjects.iterator().next().getProviderSN();
        IKubeHandler kubeHandler = (IKubeHandler)ServiceLocator.getInstance().getService(IKubeHandler.class);
        List resourceSets = kubeHandler.getResourceSetInfos(providerSN);
        List namesInKube = resourceSets.stream().map(ResourceSetInfo::getName).collect(Collectors.toList());
        if (VerifyUtil.isEmpty(namesInKube)) {
            LOGGER.error((Object)"Not find any resourceSet in kube.");
            throw new LegoCheckedException(1073948191L);
        }
        List selectedNames = protectObjects.stream().map(ProtectObject::getName).collect(Collectors.toList());
        Optional<String> opt = selectedNames.stream().filter(name -> !namesInKube.contains(name)).findAny();
        if (opt.isPresent()) {
            LOGGER.error((Object)"The selected resourceSet name: %s is not in kube.", new Object[]{opt.get()});
            throw new LegoCheckedException(1073948191L);
        }
    }

    @Override
    public int getType() {
        return 54;
    }
}

