/*
 * Decompiled with CFR 0.152.
 */
package io.huawei.xuanwu.v1;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.client.utils.Serialization;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"parameters", "provider", "replicationModel"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class VolumeReplicationGroupSpec
implements KubernetesResource {
    @JsonProperty(value="parameters")
    @JsonPropertyDescription(value="User defined parameter for extension Non-public attributes, put them here. For now, include: primaryBackendName/secondaryBackendName/primaryBackendSN/secondaryBackendSN/syncRate")
    @JsonSetter(nulls=Nulls.SKIP)
    private Map<String, String> parameters;
    @JsonProperty(value="provider")
    @JsonPropertyDescription(value="Provider is required in VolumeReplicationGroup, used to filter the provider to create group")
    @JsonSetter(nulls=Nulls.SKIP)
    private String provider;
    @JsonProperty(value="replicationModel")
    @JsonPropertyDescription(value="ReplicationModel is optional in VolumeReplicationGroup, default ReplicationModelType is Async")
    @JsonSetter(nulls=Nulls.SKIP)
    private ReplicationModel replicationModel = (ReplicationModel)((Object)Serialization.unmarshal((String)"\"Async\"", ReplicationModel.class));

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public ReplicationModel getReplicationModel() {
        return this.replicationModel;
    }

    public void setReplicationModel(ReplicationModel replicationModel) {
        this.replicationModel = replicationModel;
    }

    public static enum ReplicationModel {
        SYNC("Sync"),
        ASYNC("Async");

        String value;

        private ReplicationModel(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }
    }
}

