/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.kube.discovery.process;

import com.huawei.ism.base.sdk.model.NetworkEntity;
import com.huawei.ism.cbb.discover.framework.AbstractContext;
import com.huawei.ism.cbb.discover.framework.IProcessor;
import com.huawei.ism.drm.base.util.AlarmReporter;
import com.huawei.ism.drm.kube.discovery.util.ProcessorUtil;
import com.huawei.ism.drm.kube.sdk.IKubeHandler;
import com.huawei.ism.drm.kube.sdk.model.KubernetesNE;
import com.huawei.ism.drm.kube.sdk.model.enums.KubeBackTaskProcessDefine;
import com.huawei.ism.drm.kube.service.IKubeService;
import com.huawei.ism.drm.kube.service.impl.KubeServiceImpl;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import java.util.Collection;
import java.util.List;

public class KubeQueryProcessor
implements IProcessor {
    private static final Log LOGGER = LogFactory.getInstance(KubeQueryProcessor.class);
    private final IKubeService kubeService = new KubeServiceImpl();

    public boolean process(AbstractContext context) {
        KubernetesNE networkEntity = ProcessorUtil.getKubeNe(context);
        LOGGER.info((Object)"[kubernetes]KubeProcessor start, server ip: %s", new Object[]{networkEntity.getLinkIp()});
        String deviceSn = networkEntity.getSn();
        if (!this.kubeService.checkCDRStatusBySN(deviceSn)) {
            this.sendAlarm(deviceSn, (NetworkEntity)networkEntity);
            context.setAttribute("kubeCdrStatus", (Object)false);
            LOGGER.error((Object)"CDR status error.");
            throw new LegoCheckedException(1073947398L, new String[]{"kubernetes"});
        }
        this.restoreAlarm(deviceSn, (NetworkEntity)networkEntity);
        IKubeHandler kubeHandler = (IKubeHandler)ServiceLocator.getInstance().getService(IKubeHandler.class);
        try {
            context.setAttribute("kubeResourceSet", (Object)kubeHandler.getResourceSetInfos(deviceSn));
            List storages = kubeHandler.getStorageBackendClaims(deviceSn);
            if (VerifyUtil.isEmpty((Collection)storages)) {
                LOGGER.error((Object)"Not find any storages by %s.", new Object[]{deviceSn});
            }
            context.setAttribute("kubeStorage", (Object)storages);
            context.setAttribute("hyperMetroDomain", (Object)kubeHandler.getHyperMetroDomain(deviceSn));
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"Query CDR resource failed. Error code:%s. Error message: %s.", new Object[]{e.getErrorCode(), e.getMessage()});
        }
        context.updateBackTaskProgress(KubeBackTaskProcessDefine.Discovery.QUERY_INFO.getProgress());
        return true;
    }

    private void sendAlarm(String deviceSn, NetworkEntity extendInfo) {
        String[] alarmParams = new String[]{extendInfo.getName(), extendInfo.getLinkIp(), String.valueOf(extendInfo.getMoId()), extendInfo.getProductModel()};
        AlarmReporter.sendAlarm((String)"0x000803220005", (String)deviceSn, (String)FaultEnum.AlarmResourceType.NETWORKENTITY.getValue(), (FaultEnum.AlarmSeverity)FaultEnum.AlarmSeverity.CRITICAL, (String[])alarmParams);
    }

    private void restoreAlarm(String deviceSn, NetworkEntity extendInfo) {
        String[] alarmParams = new String[]{String.valueOf(extendInfo.getMoId())};
        AlarmReporter.restoreAlarm((String)"0x000803220005", (String[])alarmParams);
    }

    public void postProcess(AbstractContext abstractContext) {
    }

    public void clean(AbstractContext abstractContext) {
    }
}

