/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.kube.discovery.process;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.discover.framework.AbstractContext;
import com.huawei.ism.cbb.discover.framework.IProcessor;
import com.huawei.ism.drm.kube.discovery.util.ProcessorUtil;
import com.huawei.ism.drm.kube.sdk.model.Domain;
import com.huawei.ism.drm.kube.sdk.model.KubeStorage;
import com.huawei.ism.drm.kube.sdk.model.KubernetesNE;
import com.huawei.ism.drm.kube.sdk.model.enums.KubeBackTaskProcessDefine;
import com.huawei.ism.drm.kube.service.IKubeService;
import com.huawei.ism.drm.kube.utils.KubeRefreshResourceUtils;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;

public class KubeSaveProcessor
implements IProcessor {
    private static final Log LOGGER = LogFactory.getInstance(KubeSaveProcessor.class);

    public boolean process(AbstractContext context) {
        KubernetesNE kubernetesNE;
        Object domainsObj;
        Object kubeStoragesObj;
        KubernetesNE networkEntity = ProcessorUtil.getKubeNe(context);
        LOGGER.info((Object)"[kubernetes]KubeSaveProcessor start, server ip: %s", new Object[]{networkEntity.getLinkIp()});
        Boolean isConnectCdrSuccess = (Boolean)context.getAttribute("kubeCdrStatus", Boolean.class);
        if (isConnectCdrSuccess != null && !isConnectCdrSuccess.booleanValue()) {
            LOGGER.error((Object)"[kubernetes]Kubernetes save process canceled, cause could not connect to CDR. server ip:%s", new Object[]{context.getAttribute("kubeServerIp")});
            return false;
        }
        String deviceSn = networkEntity.getSn();
        Object resourceSetObj = context.getAttribute("kubeResourceSet");
        if (!VerifyUtil.isEmpty((Object)resourceSetObj)) {
            List resourceSets = (List)resourceSetObj;
            KubeRefreshResourceUtils.saveOrUpdateOrDeleteResourceSet(deviceSn, resourceSets, true);
        }
        if (!VerifyUtil.isEmpty((Object)(kubeStoragesObj = context.getAttribute("kubeStorage")))) {
            List kubeStorages = (List)kubeStoragesObj;
            this.saveOrUpdateOrDeleteKubeStorage(deviceSn, kubeStorages);
        }
        if (!VerifyUtil.isEmpty((Object)(domainsObj = context.getAttribute("hyperMetroDomain"))) && domainsObj instanceof List) {
            List domains = (List)domainsObj;
            this.saveOrUpdateOrDeleteDomain(deviceSn, domains);
        }
        if (VerifyUtil.isEmpty((Object)(kubernetesNE = (KubernetesNE)context.getAttribute("StorageDevice", KubernetesNE.class)))) {
            LOGGER.error((Object)"Can not get retrieved device data for kube!");
            throw new LegoCheckedException(0x200909L);
        }
        this.saveKubeDeviceToDB(kubernetesNE);
        context.updateBackTaskProgress(KubeBackTaskProcessDefine.Discovery.SAVE_OTHER_INFO.getProgress());
        return true;
    }

    private void saveOrUpdateOrDeleteDomain(String deviceSn, List<Domain> domains) {
        if (VerifyUtil.isEmpty(domains)) {
            LOGGER.warn((Object)"[Domain]Cancel save or update storages, cause storages is empty.");
            this.getKubeService().deleteDomains(this.getKubeService().getHyperMetroDomains(deviceSn, "", Boolean.valueOf(false)));
            return;
        }
        List oldDomains = this.getKubeService().getHyperMetroDomains(deviceSn, "", Boolean.valueOf(false));
        HashMap newDomainMap = new HashMap();
        domains.forEach(domain -> newDomainMap.put(domain.getId(), domain));
        this.getKubeService().saveDomains(domains);
        this.getKubeService().deleteDomains(oldDomains.stream().filter(domain -> !newDomainMap.containsKey(domain.getId())).collect(Collectors.toList()));
    }

    private void saveKubeDeviceToDB(KubernetesNE kubeNe) {
        LOGGER.info((Object)"Begin to save kubeNe info, moId: %s.", new Object[]{String.valueOf(kubeNe.getMoId())});
        CommonDAOLocator.getMoDao().getTransactionTemplate().execute((TransactionCallback)new SaveKubeTransactionCallback(kubeNe));
    }

    private void saveOrUpdateOrDeleteKubeStorage(String deviceSn, List<KubeStorage> newKubeStorageList) {
        if (VerifyUtil.isEmpty(newKubeStorageList)) {
            LOGGER.warn((Object)"[kubernetes]Cancel save or update storages, cause storages is empty.");
            this.getKubeService().removeLocalkubeStorage(this.getKubeService().getKuberStorages(deviceSn));
            return;
        }
        List oldKubeStorageList = this.getKubeService().getKuberStorages(deviceSn);
        HashMap newKubeStorageMap = new HashMap();
        newKubeStorageList.forEach(kubeStorage -> newKubeStorageMap.put(kubeStorage.getKubeId() + kubeStorage.getId(), kubeStorage));
        this.getKubeService().batchSaveOrUpdateKubeStorage(newKubeStorageList);
        this.getKubeService().removeLocalkubeStorage(oldKubeStorageList.stream().filter(kubeStorage -> !newKubeStorageMap.containsKey(kubeStorage.getKubeId() + kubeStorage.getId())).collect(Collectors.toList()));
    }

    public void postProcess(AbstractContext abstractContext) {
    }

    public void clean(AbstractContext abstractContext) {
    }

    private IKubeService getKubeService() {
        return (IKubeService)ServiceLocator.getInstance().getService(IKubeService.class);
    }

    static class SaveKubeTransactionCallback
    implements TransactionCallback {
        private final KubernetesNE kubeNe;

        public SaveKubeTransactionCallback(KubernetesNE kubeNe) {
            this.kubeNe = kubeNe;
        }

        public Object doInTransaction(TransactionStatus ts) {
            try {
                CommonDAOLocator.getMoDao().addMoAndSubMo((ManagedObject)this.kubeNe);
            }
            catch (Exception ex) {
                ts.setRollbackOnly();
                ExceptionUtil.rethrowException((Throwable)ex, (String)"Save kube info.", (long)132416L, null, (Log)LOGGER);
            }
            return new HashMap();
        }
    }
}

