/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.kube.discovery.validate;

import com.huawei.ism.drm.kube.sdk.IKubeHandler;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.core.sdk.util.WccEncryptor;
import com.huawei.lego.nem.discover.sdk.model.DiscParamVilidateResult;
import com.huawei.lego.nem.discover.sdk.model.DiscoveryPolicy;
import com.huawei.lego.nem.discover.sdk.service.IDisParamValidator;
import java.util.Optional;

public class KubernetesParamValidator
implements IDisParamValidator {
    private static final Log LOGGER = LogFactory.getInstance(KubernetesParamValidator.class);

    public DiscParamVilidateResult validate(DiscoveryPolicy discoveryPolicy) {
        DiscParamVilidateResult result = new DiscParamVilidateResult();
        String config = (String)discoveryPolicy.getParamMap().get("config");
        if (VerifyUtil.isEmpty((String)config)) {
            LOGGER.error((Object)"[kubernetes]Kubernetes config empty.");
            result.setResult(false);
            return result;
        }
        String configText = WccEncryptor.decrypt((String)config);
        IKubeHandler iKubeHandler = (IKubeHandler)ServiceLocator.getInstance().getService(IKubeHandler.class);
        result.setResult(true);
        try {
            iKubeHandler.checkConnectionByConfig(configText);
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"The error is: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            result.setResult(false);
            result.setErrorCode(e.getErrorCode());
            result.setErrorMsgKey(e.getParameters()[0]);
        }
        return result;
    }

    public String getValidatorKey() {
        return "ism.drm.deviceType.container.mainType";
    }

    public Optional<LegoCheckedException> convertValidateResult2Exception(DiscParamVilidateResult result) {
        String info = result.getErrorMsgKey();
        if (result.getErrorCode() == 1073947753L) {
            return Optional.of(new LegoCheckedException(result.getErrorCode(), new String[]{info, info}));
        }
        if (result.getErrorCode() == 1073947398L) {
            return Optional.of(new LegoCheckedException(result.getErrorCode(), new String[]{info}));
        }
        return Optional.empty();
    }
}

