/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.kube.execute.process;

import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.kube.execute.process.AbstractCDRMonitorAction;
import com.huawei.ism.drm.kube.sdk.model.enums.KubeEventKeywords;
import com.huawei.ism.drm.protection.action.model.ActionContext;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;

public class CDRMonitorPreHookAction
extends AbstractCDRMonitorAction {
    private static final Log LOGGER = LogFactory.getInstance(CDRMonitorPreHookAction.class);

    public void preExcute(ActionContext context) {
        ProtectGroup protectGroup = null;
        if (context.getObject("PG_ENTITY") instanceof ProtectGroup) {
            protectGroup = (ProtectGroup)context.getObject("PG_ENTITY");
        }
        if (VerifyUtil.isEmpty(protectGroup)) {
            LOGGER.error((Object)"The protectGroup is null.");
            throw new LegoCheckedException(2117645L);
        }
        this.setEnable(this.checkPreHook(protectGroup));
    }

    @Override
    public boolean doExecute(ActionContext context) {
        ProtectGroup protectGroup = null;
        if (context.getObject("PG_ENTITY") instanceof ProtectGroup) {
            protectGroup = (ProtectGroup)context.getObject("PG_ENTITY");
        }
        if (protectGroup == null) {
            LOGGER.error((Object)"The protectGroup is null.");
            throw new LegoCheckedException(2117645L);
        }
        if (!this.checkPreHook(protectGroup)) {
            LOGGER.info((Object)"Pg: %s not has preHook, return.", new Object[]{protectGroup.getName()});
            return true;
        }
        if (PolicyTemplateType.KUBE_REPLICATION_TYPES.contains(protectGroup.getTemplate().getType())) {
            return this.listenReplicationAction(context, protectGroup, "preHook");
        }
        return this.listenBackupAction(context, protectGroup, "preHook");
    }

    @Override
    protected String getStartKeyword() {
        return KubeEventKeywords.DisasterProtectionJob.PRE_HOOK_START.getValue();
    }

    @Override
    protected String getEndKeyword() {
        return KubeEventKeywords.DisasterProtectionJob.PRE_HOOK_END.getValue();
    }
}

